/*	
 *	search.h
 *
 *	POSIXW̃jAT[`֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2014 Naoyuki Sawa
 *
 *	* Mon Jan 13 19:05:18 JST 2014 Naoyuki Sawa
 *	- lfind()lsearch()̐錾Aclippce.hinclude/search.h֕܂B
 *	- lfind()lsearch()̎Aclippce.cclipsrch.c֕܂B
 *	* Fri Feb 14 21:17:26 JST 2014 Naoyuki Sawa
 *	- hcreate(),hsearch(),hdestroy(),hcreate_r(),hsearch_r(),hdestroy_r()ǉ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef _SEARCH_H
#define _SEARCH_H

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *	
 ****************************************************************************/

void* lfind(const void* key, const void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2));
void* lsearch(const void* key, void* base, size_t* num, size_t width, int (*compare)(const void* elem1, const void* elem2));

/****************************************************************************
 *	
 ****************************************************************************/

/* POSIX.1-2001 */
typedef enum { FIND, ENTER } ACTION;
typedef struct entry {
	char* key;
	void* data;
} ENTRY;
int hcreate(size_t nel);
ENTRY* hsearch(ENTRY item, ACTION action);
void hdestroy();

/* GNU extensions */
struct hsearch_data {
	struct hsearch_internal_data* internal;
};
int hcreate_r(size_t nel, struct hsearch_data* htab);
int hsearch_r(ENTRY item, ACTION action, ENTRY** retval, struct hsearch_data* htab);
void hdestroy_r(struct hsearch_data* htab);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif/*_SEARCH_H*/
