;	
;	framppua.s
;
;	P/ECE PPU (RICOH RP2C02) Emulator
;
;	CLiP - Common Library for P/ECE
;	Copyright (C) 2001-2005 Naoyuki Sawa
;
;	* Sun Jan 30 21:25:00 JST 2005 Naoyuki Sawa
;	- 쐬JnB
;	* Tue Feb 22 06:43:00 JST 2005 Naoyuki Sawa
;	- ppu_draw_chr̃RgԈĂ̂C܂B
;	  vOɂ͕ω܂B
;
#include "clipppua.h"
#ifdef PPU_ASM

	.code
	.align 1

;****************************************************************************
;	
;****************************************************************************

;
;	PPU\
;
#define PPU_CONTROL1	 0	; + 0, 1
#define PPU_CONTROL2	 1	; + 1, 1
#define PPU_STATUS	 2	; + 2, 1
#define SPRRAM_ADDRESS	 3	; + 3, 1
#define VRAM_ADDRESS1	 4	; + 4, 2
#define VRAM_ADDRESS2	 6	; + 6, 2
#define FLAGS		 8	; + 8, 1
#define VRAM_BUFFER	 9	; + 9, 1
#define SCAN_START	10	; +10, 1
#define SCAN_END	11	; +11, 1
#define VBUFF		12	; +12, 4
#define CLUT		16	; +16,32

;****************************************************************************
;	
;****************************************************************************

	.global ppu_reduce
ppu_reduce:
	xld.w	%r14, 256*2			; 2C̃ItZbg (pɂɎĝŃWX^ɕێ)
	xld.w	%r15, 256*1			; 1C̃ItZbg (pɂɎĝŃWX^ɕێ)
	;
	xld.w	%r4, 240/30			; z = 240/30
ppu_reduce_DO_Z:				; do {
	;
	xld.w	%r5, 3				;   i = 3
	xld.w	%r6, 11				;   y = 11
ppu_reduce_DO_Y:				;   do {
	;
	xld.w	%r7, 256/4			;     x = 256/4
ppu_reduce_DO_X:				;     do {
	;
	xld.w	%r9 , [%r13+512]		;       v = tmp[0] + tmp[256] + tmp[512]
	xld.w	%r10, [%r13+256]
	 ld.w	%r11, [%r13]+			;       tmp += 4
	add	%r10, %r9
	add	%r11, %r10
	;
	ld.w	%r10, %r11			;       c   = v
	xsrl	%r11, 8				;       v >>= 8
	add	%r10, %r11			;       c  += v
	ld.ub	%r10, %r10			;       *dst++ = (unsigned char)c >> 4
	xsrl	%r10, 4
	ld.b	[%r12]+, %r10
	;
	xsrl	%r11, 8				;       v >>= 8
	;
	ld.w	%r10, %r11			;       c   = v
	xsrl	%r11, 8				;       v >>= 8
	add	%r10, %r11			;       c  += v
	ld.ub	%r10, %r10			;       *dst++ = (unsigned char)c >> 4
	xsrl	%r10, 4
	ld.b	[%r12]+, %r10
	;
	xsub	%r7, %r7, 1			;     } while(--x)
	xjrne	ppu_reduce_DO_X
	;
	xsub	%r5, %r5, 1			;     --i
	jrne.d	4				;             X[vA1C֐ił܂B
	add	%r13, %r14			;     *delay* ܂ŁA2Ci߂܂B(v3C)
	sub	%r13, %r15			;     (skip?) i == 0Ȃ΁A1C߂܂B(v2C)
	ld.w	%r5, 3				;     (skip?) i = 3
	;
	xsub	%r6, %r6, 1			;   } while(--y)
	xjrne	ppu_reduce_DO_Y
	;
	xsub	%r4, %r4, 1			; } while(--z)
	xjrne	ppu_reduce_DO_Z
	;
	ret

;****************************************************************************
;	
;****************************************************************************

;
; [in]
;	%r12	xpos
;	%r13	ypos
;	%r14	code
;	%r15	palno
;
	.global	ppu_draw_chr
ppu_draw_chr:
	xld.w	%r7, ppu			; %r7 = ppu
	;
	xld.ub	%r4, [%r7+SCAN_START]		; %r4 = scan_start
	xld.ub	%r5, [%r7+SCAN_END]		; %r5 = scan_end
	;
	sub	%r4, 8				; if(ypos <= scan_start-8) goto EXIT
	cmp	%r13, %r4
	xjrle.d	ppu_draw_chr_EXIT
	add	%r4, 8				; *delay*
	cmp	%r13, %r5			; if(ypos >= scan_end) goto EXIT
	xjrge	ppu_draw_chr_EXIT
	xcmp	%r12, 0-8			; if(xpos <= 0-8) goto EXIT
	xjrle	ppu_draw_chr_EXIT
	xcmp	%r12, 256			; if(xpos >= 256) goto EXIT
	xjrge	ppu_draw_chr_EXIT
	;
	xld.w	%r6, [%r7+VBUFF]		; %r6 = vbuff
	xadd	%r7, %r7, CLUT			; %r7 = clut
	;
	xsla	%r13, 8				; vbuff += ypos * 256 + xpos
	add	%r6, %r13
	xsra	%r13, 8
	add	%r6, %r12
	;
	xsll	%r15, 2				; clut += palno << 2
	add	%r7, %r15
	;
	xsll	%r14, 4				; %r14 = pattern = &vram[0x0000|code<<4]
	ext	ppu_vram+0x0000@ah
	ext	ppu_vram+0x0000@al
	add	%r14, %r14
	;
	cmp	%r13, %r4			; if(ypos < scan_start) goto CLIP
	xjrlt	ppu_draw_chr_CLIP
	sub	%r5, 8				; if(ypos > scan_end-8) goto CLIP
	cmp	%r13, %r5
	xjrgt.d	ppu_draw_chr_CLIP
	add	%r5, 8				; *delay*
	xcmp	%r12, 256-8			; if(xpos < 0 || xpos > 256-8) goto CLIP
	xjrugt	ppu_draw_chr_CLIP
	;--------------------------------------------------------------------
ppu_draw_chr_FAST:
	xld.w	%r13, 8				; %r13 = y = 8
ppu_draw_chr_FAST_DO_Y:				; do {
	;
	xld.ub	%r10, [%r14+0]			;   %r10 = pattern[0] (lobit = 00000000 00000000 00000000 abcdefgh)
	xld.ub	%r11, [%r14+8]			;   %r11 = pattern[8] (hibit = 00000000 00000000 00000000 ABCDEFGH)
	rr	%r10, 8				;   lobit = abcdefgh 00000000 00000000 00000000
	rr	%r11, 7				;   hibit = BCDEFGH0 00000000 00000000 0000000A
	;
	xld.w	%r12, 8				;   %r12 = x = 8
ppu_draw_chr_FAST_DO_X:				;   do {
	;
	xand	%r15, %r11, 1			;     %r15  = 00000000 00000000 00000000 0000000A
	add	%r10, %r10			;     lobit = bcdefgh0 00000000 00000000 00000000, %psr(C) = a
	adc	%r15, %r15			;     %r15  = 00000000 00000000 00000000 000000Aa
	xjreq.d	ppu_draw_chr_FAST_SKIP_X	;     if(!v) goto SKIP_X
	rl	%r11, 1				;     hibit = CDEFGH00 00000000 00000000 0000000B  *delay*
	;
	add	%r15, %r7			;     *vbuff = clut[v]
	ld.ub	%r15, [%r15]
	ld.b	[%r6], %r15
	;
ppu_draw_chr_FAST_SKIP_X:
	xsub	%r12, %r12, 1
	xjrne.d	ppu_draw_chr_FAST_DO_X		;   } while(--x)
	add	%r6, 1				;   vbuff++ *delay*
	;
	xadd	%r6, %r6, 256-8			;   vbuff += 256-8
	;
	xsub	%r13, %r13, 1
	xjrne.d	ppu_draw_chr_FAST_DO_Y		; } while(--y)
	add	%r14, 1				; pattern++ *delay*
	;
	xjp	ppu_draw_chr_EXIT
	;--------------------------------------------------------------------
ppu_draw_chr_CLIP:
	pushn	%r1
	;
	xld.w	%r1, 8				; %r1 = y = 8
ppu_draw_chr_CLIP_DO_Y:				; do {
	;
	cmp	%r13, %r4			;   if(ypos < scan_start) goto SKIP_Y
	xjrlt	ppu_draw_chr_CLIP_SKIP_Y
	cmp	%r13, %r5			;   if(ypos >= scan_end) goto SKIP_Y
	xjrge	ppu_draw_chr_CLIP_SKIP_Y
	;
	xld.ub	%r10, [%r14+0]			;   %r10 = pattern[0] (lobit = 00000000 00000000 00000000 abcdefgh)
	xld.ub	%r11, [%r14+8]			;   %r11 = pattern[8] (hibit = 00000000 00000000 00000000 ABCDEFGH)
	rr	%r10, 8				;   lobit = abcdefgh 00000000 00000000 00000000
	rr	%r11, 7				;   hibit = BCDEFGH0 00000000 00000000 0000000A
	;
	xld.w	%r0, 8				;   %r0 = x = 8
ppu_draw_chr_CLIP_DO_X:				;   do {
	;
	xand	%r15, %r11, 1			;     %r15  = 00000000 00000000 00000000 0000000A
	add	%r10, %r10			;     lobit = bcdefgh0 00000000 00000000 00000000, %psr(C) = a
	adc	%r15, %r15			;     %r15  = 00000000 00000000 00000000 000000Aa
	xjreq.d	ppu_draw_chr_CLIP_SKIP_X	;     if(!v) goto SKIP_X
	rl	%r11, 1				;     hibit = CDEFGH00 00000000 00000000 0000000B  *delay*
	;
	xcmp	%r12, 256			;     if(x < 0 || x >= 256) goto SKIP_X
	xjruge	ppu_draw_chr_CLIP_SKIP_X
	;
	add	%r15, %r7			;     *vbuff = clut[v]
	ld.ub	%r15, [%r15]
	ld.b	[%r6], %r15
	;
ppu_draw_chr_CLIP_SKIP_X:
	xadd	%r12, %r12, 1			;     xpos++
	;
	xsub	%r0, %r0, 1
	xjrne.d	ppu_draw_chr_CLIP_DO_X		;   } while(--x)
	add	%r6, 1				;   vbuff++ *delay*
	;
	xsub	%r12, %r12, 8			;   xpos -= 8
	xsub	%r6, %r6, 8			;   vbuff -= 8
ppu_draw_chr_CLIP_SKIP_Y:
	xadd	%r13, %r13, 1			;   ypos++
	xadd	%r6, %r6, 256			;   vbuff += 256
	;
	xsub	%r1, %r1, 1
	xjrne.d	ppu_draw_chr_CLIP_DO_Y		; } while(--y)
	add	%r14, 1				; pattern++ *delay*
	;
	popn	%r1
	;--------------------------------------------------------------------
ppu_draw_chr_EXIT:
	ret

;****************************************************************************
;	
;****************************************************************************

#endif /*PPU_ASM*/
