/*	
 *	framgbs.h
 *
 *	P/ECE GBS Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Thu Jan 15 20:09:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"

/****************************************************************************
 *	DMGG~[VpO֐
 ****************************************************************************/

void
gbs_dmg_write(DMG* dmg, unsigned short addr, unsigned char data)
{
	GBSDRIVER* gbs = (GBSDRIVER*)dmg;

	switch(addr >> 12) {
	/*===== 2000-3fff: ROM Area1oN =====*/
	case 0x2:
	case 0x3:
		gbs_rom1_bank(gbs, data);
		return;
	/*===== a000-bfff: 8KBJ[gbWRAM ====*/
	/*===== c000-dfff: 8KBRAM         ====*/
	case 0xa:
	case 0xb:
	case 0xc:
	case 0xd:
		gbs->mem[addr] = data;
		return;
	/*===== ff00-ff7f: I/O(㔼͋) ====*/
	/*===== ff80-fffe: X^bN&[NRAM ====*/
	/*===== ffff: 荞݋WX^ =====*/
	case 0xf:
		if(addr >= 0xff00) gbs_dmg_out(dmg, (unsigned char)addr, data);
		return;
	}
}

