/*	
 *	clipunic.h
 *
 *	Unicode
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2015-2016 Naoyuki Sawa
 *
 *	* Thu Mar 05 21:20:02 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Fri Mar 06 21:21:37 JST 2015 Naoyuki Sawa
 *	- strdup_ShiftJisToUtf8(),strdup_Utf8ToShiftJis()ǉ܂B
 *	* Sat Mar 07 13:24:35 JST 2015 Naoyuki Sawa
 *	- k@uCanonical Huffman Code(CHC)vuRange Coder(RC)vuByte Pair Encoding(BPE)vIł悤ɂ܂B
 *	  O܂ł́uRCvŒłAk@ɂႢrƎvłB
 *	- k@̑ÍAW[̃rhCOMPRESSION_METHOD̒`鎖ōŝŁAAvP[VI鎖͂ł܂B
 *	  k@rƂuCHCvxƗeʂ̃oXǂƎv̂ŁÁ݂uCHCv(COMPRESSION_METHOD=1)IĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Thu Mar 10 21:38:25 JST 2016 Naoyuki Sawa
 *	- u[eBeB֐(VtgJISUnicode(UCS-2))vǉ܂B
 *	- u[eBeB֐(UTF-8UCS-2)vǉ܂B
 *	* Fri Mar 11 21:58:48 JST 2016 Naoyuki Sawa
 *	- u[eBeB֐(VtgJISUnicode(UCS-2))vu[eBeB֐(UTF-8UCS-2)vǉƂɔA
 *	  ́u[eBeB֐(VtgJISUTF-8)vAu[eBeB֐(VtgJISUnicode(UCS-2))vu[eBeB֐(UTF-8UCS-2)v𗘗p悤ɕύX܂B
 *	  ʂ͂܂łƓłB
 *	* Mon May 02 21:51:14 JST 2016 Naoyuki Sawa
 *	- uϊ(VtgJISUTF-8)vǉ܂B
 *	  ܂ł́uϊ(VtgJISUnicode(UCS-2))vƁuϊ(UTF-8UCS-2)vgݍ킹ĕϊKvLAڕϊo悤ɂȂ܂B
 *	- uϊ(VtgJISUTF-8)vǉɔÁu[eBeB֐(VtgJISUTF-8)vAuϊ(VtgJISUTF-8)v𗘗p悤ɕύX܂B
 *	  ʂ͂܂łƓłB
 *	* Sun May 08 23:30:59 JST 2016 Naoyuki Sawa
 *	- ܂ł͌ʂɉĂobNXbV̕ϊAW[ŋz鎖ɂ܂B
 *	  W[ŋzɂA/clip/tool/dpsprsht/app.cpp/clip/clipyaml.čʂ̏svɂȂ܂B
 *	  ڍׂ́AL̃t@C̓̃RgQƂĉB
 *	* Fri May 13 21:43:38 JST 2016 Naoyuki Sawa
 *	- ShiftJisToUnicodeStr(),UnicodeToShiftJisStr(),Utf8ToUcs2Str(),Ucs2ToUtf8Str(),ShiftJisToUtf8Str(),Utf8ToShiftJisStr()֐srcLenǉ܂B
 *	- VKstrndup_ShiftJisToUtf8(),strndup_Utf8ToShiftJis(),strndup_ShiftJisToUnicode(),strndup_UnicodeToShiftJis(),strndup_Utf8ToUcs2(),strndup_Ucs2ToUtf8()֐ǉ܂B
 *	* Sat May 14 21:51:15 JST 2016 Naoyuki Sawa
 *	- Windowsł̓ɗ]TL̂ShiftJisToUnicodeChr(),UnicodeToShiftJisChr()̌ʂۑč鎖ɂ܂B
 *	  {IɂTBL_ShiftJisToUnicode[]kȂΗǂ̂łAł͑gݍ݊p̃ASY؂ɂȂȂ̂ŁAԂĂ@ō鎖ɂ܂B
 */
#ifndef __CLIP_UNIC_H__
#define __CLIP_UNIC_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	R[hϊ(VtgJISUnicode(UCS-2))
 ****************************************************************************/
/* VtgJISR[hAUnicodeR[hɕϊ܂B
 * [in]
 *	c		VtgJISR[h
 * [out]
 *	߂l		UnicodeR[h
 * [note]
 *	- ϊłȂꍇ́A'?'(0x003F)Ԃ܂B
 */
int ShiftJisToUnicodeChr(int c);
/* UnicodeR[hAVtgJISR[hɕϊ܂B
 * [in]
 *	c		UnicodeR[h
 * [out]
 *	߂l		VtgJISR[h
 * [note]
 *	- ϊłȂꍇ́A'?'(0x3F)Ԃ܂B
 */
int UnicodeToShiftJisChr(int c);
/****************************************************************************
 *	ϊ(VtgJISUnicode(UCS-2))
 ****************************************************************************/
/* VtgJISAUnicodeɕϊ܂B
 * [in]
 *	s		VtgJIS
 *	srcLen		s̃oCg(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃oCg߂̒lw肷ƁAs̎ۂ̃oCg܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		Unicodei[obt@		(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊUnicodẽ[hBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=ShiftJisToUnicodeStr(s,-1,NULL,0);	//ϊ̃[h(I[܂܂)߂B
 *	buf=malloc((len+1)*sizeof(wchar_t));		//obt@mۂBI[(+1)sizeof(wchar_t){鎖Yꂸ!!
 *	ShiftJisToUnicodeStr(s,-1,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int ShiftJisToUnicodeStr(const char* _s, int srcLen/*-1*/, wchar_t buf[/*cap*/]/*NULL*/, int cap/*0*/);
/* UnicodeAVtgJISɕϊ܂B
 * [in]
 *	s		Unicode
 *	srcLen		s̃[h(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃[h߂̒lw肷ƁAs̎ۂ̃[h܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		VtgJISi[obt@	(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊ̃VtgJIS̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=UnicodeToShiftJisStr(s,-1,NULL,0);	//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);				//obt@mۂBI[(+1)Yꂸ!!
 *	UnicodeToShiftJisStr(s,-1,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int UnicodeToShiftJisStr(const wchar_t* s, int srcLen/*-1*/, char buf[/*cap*/]/*NULL*/, int cap/*0*/);
/****************************************************************************
 *	ϊ(UTF-8UCS-2)
 ****************************************************************************/
/* UTF-8AUCS-2ɕϊ܂B
 * [in]
 *	s		UTF-8
 *	srcLen		s̃oCg(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃oCg߂̒lw肷ƁAs̎ۂ̃oCg܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		UCS-2i[obt@		(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊUCS-2̃[hBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=Ucs2ToUtf8Str(s,-1,NULL,0);		//ϊ̃[h(I[܂܂)߂B
 *	buf=malloc((len+1)*sizeof(wchar_t));		//obt@mۂBI[(+1)sizeof(wchar_t){鎖Yꂸ!!
 *	Ucs2ToUtf8Str(s,-1,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int Utf8ToUcs2Str(const unsigned char* s, int srcLen/*-1*/, wchar_t buf[/*cap*/]/*NULL*/, int cap/*0*/);
/* UCS-2AUTF-8ɕϊ܂B
 * [in]
 *	s		UCS-2
 *	srcLen		s̃[h(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃[h߂̒lw肷ƁAs̎ۂ̃[h܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		UTF-8i[obt@		(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊUTF-8̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=Ucs2ToUtf8Str(s,-1,NULL,0);		//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);				//obt@mۂBI[(+1)Yꂸ!!
 *	Ucs2ToUtf8Str(s,-1,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int Ucs2ToUtf8Str(const wchar_t* s, int srcLen/*-1*/, unsigned char buf[/*cap*/]/*NULL*/, int cap/*0*/);
/****************************************************************************
 *	ϊ(VtgJISUTF-8)
 ****************************************************************************/
/* VtgJISAUTF-8ɕϊ܂B
 * [in]
 *	s		VtgJIS
 *	srcLen		s̃oCg(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃oCg߂̒lw肷ƁAs̎ۂ̃oCg܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		UTF-8i[obt@		(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊUTF-8̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=ShiftJisToUtf8Str(s,-1,NULL,0);		//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);				//obt@mۂBI[(+1)Yꂸ!!
 *	ShiftJisToUtf8Str(s,-1,buf,len+1);		//ϊ̕(I[܂)i[B
 */
int ShiftJisToUtf8Str(const char* _s, int srcLen/*-1*/, unsigned char buf[/*cap*/]/*NULL*/, int cap/*0*/);
/* UTF-8AVtgJISɕϊ܂B
 * [in]
 *	s		UTF-8
 *	srcLen		s̃oCg(I[̃k܂܂)	int^łŉ߂܂Bs̎ۂ̃oCg߂̒lw肷ƁAs̎ۂ̃oCg܂ŏ܂BvɁAi(-1)w肷Ώ\łB
 *	buf		VtgJISi[obt@	(cap=0)w肵ꍇ́Abuf͎QƂȂ̂ŁA(buf=NULL)ł\܂B
 *	cap		buf̗vf				srcLenŉ߂̂ɑ΂āAcap͕tŉ߂鎖ɒӂĉB(cap<0)w肷ƁA(cap=0)w肵̂ƓʂɂȂ܂B
 * [out]
 *	߂l		ϊ̃VtgJIS̃oCgBI[͊܂݂܂B
 *			capƓȏ̒lԂꂽꍇAjꂽ܂B
 * [note]
 *	gp
 *	len=Utf8ToShiftJisStr(s,NULL,0);	//ϊ̃oCg(I[܂܂)߂B
 *	buf=malloc(len+1);			//obt@mۂBI[(+1)Yꂸ!!
 *	Utf8ToShiftJisStr(s,buf,len+1);	//ϊ̕(I[܂)i[B
 */
int Utf8ToShiftJisStr(const unsigned char* s, int srcLen/*-1*/, char buf[/*cap*/]/*NULL*/, int cap/*0*/);
/****************************************************************************
 *	[eBeB֐(VtgJISUTF-8)
 ****************************************************************************/
unsigned char* strdup_ShiftJisToUtf8(const char* s);
unsigned char* strndup_ShiftJisToUtf8(const char* s, int srcLen/*-1*/);
char* strdup_Utf8ToShiftJis(const unsigned char* s);
char* strndup_Utf8ToShiftJis(const unsigned char* s, int srcLen/*-1*/);
/****************************************************************************
 *	[eBeB֐(VtgJISUnicode(UCS-2))
 ****************************************************************************/
wchar_t* strdup_ShiftJisToUnicode(const char* s);
wchar_t* strndup_ShiftJisToUnicode(const char* s, int srcLen/*-1*/);
char* strdup_UnicodeToShiftJis(const wchar_t* s);
char* strndup_UnicodeToShiftJis(const wchar_t* s, int srcLen/*-1*/);
/****************************************************************************
 *	[eBeB֐(UTF-8UCS-2)
 ****************************************************************************/
wchar_t* strdup_Utf8ToUcs2(const unsigned char* s);
wchar_t* strndup_Utf8ToUcs2(const unsigned char* s, int srcLen/*-1*/);
unsigned char* strdup_Ucs2ToUtf8(const wchar_t* s);
unsigned char* strndup_Ucs2ToUtf8(const wchar_t* s, int srcLen/*-1*/);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_UNIC_H__
