/*
 *	cliptaps.h
 *
 *	TAPV[PT
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Sun Sep 13 20:50:05 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Mon Nov 16 21:09:12 JST 2015 Naoyuki Sawa
 *	- ST_TapSeqInfo.nEvt,iEvtMskAyсATapSeq_EvtGet(),TapSeq_EvtOvr()ǉ܂B
 *	  荞ݓŔ\̗LeCxgA荞݊OŎ擾ď邽߂̎dg݂łB
 *	  Oobt@̎́Acliprinb.cW[ɏĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 *	* Mon Jan 11 21:31:05 JST 2016 Naoyuki Sawa
 *	- St[Y̎R~̃oOC܂B
 *	  ʏt[YƓlɎR~ׂƂAԃt[YƓlɎ̃t[YĐĂ܂B
 *	  TapLogCh_Exec()̏(-2)ԈĎ̃t[YԍƌȂĂ܂ĂoOłB
 *	* Tue Feb 16 21:10:19 JST 2016 Naoyuki Sawa
 *	- TapSeq_AcqLogCh()ɂāAfoCX`l肷鎞́A_`lԍ̗Dx̑召tɂ܂B
 *	  ύXÓA_`lԍ傫قǗDxႭAfoCX`l肳ՂƂĂ܂B
 *	  ύX́A_`lԍقǗDxႭAfoCX`l肳Ղ悤ɂ܂B
 *	  ύXŔAvO̍쐬rŘ_`l̐݌vύXɁAォǉ_`l(=_`lԍ傫)قǁAʏ̉o肵čĐ(=Dx)P[XłB
 *	- TapSeq_AcqLogCh()ɂāA~̃foCX`lAcTAPZbg𑖍ɁAAfoCX`l̊lֈڍs悤ɕύX܂B
 *	  ܂ł́A~̃foCX`lĂAcTAPZbg̑pĂAʂłB
 *	* Tue Aug 02 21:11:08 JST 2016 Naoyuki Sawa
 *	- RJڒʒmǉ܂B
 *	  ܂ł́Aŏ̃t[YĐJn鎞Ãt[Yֈڍs鎞AʂŁAĐJnʒm(fnPlay)ĂяoĂ܂B
 *	  ́Aŏ̃t[YĐJn鎞͍ĐJnʒm(fnPlay)Ãt[Yֈڍs鎞͎RJڒʒm(fnNext)Ăяo悤ɂ܂B
 *	- ύXŔAfoCXV[XAĐ@\Ăꍇ(ADX2)ɁÃt[Yֈڍs鎞͖IȍĐJnsȂ悤ɂ鎖o悤ɁAAvP[V҂ʏo悤ɂ邽߂łB
 *	  foCX̃V[XAĐ@\𗘗pꍇ́AAvP[V`(*fnNext)()֐ł́AsȂ悤ɂĉB
 *	  ܂AfoCXɐݒ肷V[XAĐ̃vCobNXgƁAW[ŊǗt[Y`FCAō쐬ĉB
 *	  foCXۂɍĐĂt[YƁAW[FĂ'ݍĐ̃t[Y'v邽߂łB
 *	- foCXV[XAĐ@\ĂȂꍇ(P/ECEDxLib)́A܂ŒʂARJڎɂIȍĐsĉB
 *	  ̓Iɂ́AAvP[V`(*fnNext)()֐ɂ(*fnPlay)()ƓsÁA֐|C^ݒ肵ĉB
 *	* Fri Aug 19 21:29:24 JST 2016 Naoyuki Sawa
 *	- ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂B
 *	  tB[h̐錾p~ŁACAEg͕ςĂ܂B
 *	- L̃tB[hp~ŔAvf[0]̃tB[hɑΉĂȂRpCƁAR[hʉ邽߂łB
 *	  IɃAhX߂鏈قǕGȖł̂ŁA#ifdefŏRpCR[hʉՂƎv܂B
 *	* Thu Oct 13 21:52:21 JST 2016 Naoyuki Sawa
 *	- fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
 *	  Hł͂Ǝv܂ATAPV[PT̕CX^X쐬AR[obN֐LꍇɁAǂ̃CX^XĂяoꂽ𔻒f邽߂łB
 *	  gṕAclipxmp1.cW[QƂĉB
 */
#ifndef __CLIP_TAPS_H__
#define __CLIP_TAPS_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/*****************************************************************************
 *	萔A\
 *****************************************************************************/
//foCX`l
typedef struct _ST_TapDevCh {
	uint8_t				iLogCh;					//+ 0,  1 ̃foCX`l𐧌䂵Ă_`lԍ	UINT8_MAX=(~Ӗ)
} ST_TapDevCh;									//= 1
/*---------------------------------------------------------------------------*/
//_`l
typedef struct _ST_TapLogCh {
	uint16_t			iPhr;					//+ 0,  2 t[Yԍ						UINT16_MAX=(~Ӗ)
	uint8_t				iLoop;					//+ 2,  1 [v						0=[v,1`UINT8_MAX=c胋[v
	uint8_t				iAtt;					//+ 3,  1 						0=,1`UINT8_MAX=L(AvP[VCӂɉ߂)
	 int8_t				iPan;					//+ 4,  1 p							0=p,INT8_MIN`-1=p(AvP[VCӂɉ߂),1`INT8_MAX=Ep(AvP[VCӂɉ߂)
	uint8_t				iDevCh;					//+ 5,  1 ̘_`l䂵ĂfoCX`lԍ	UINT8_MAX=(~,,ĐJnɃfoCX`lloȂ,,ĐJnɃfoCX`l肳ꂽӖ)
	uint8_t				iSeqCh;					//+ 6,  1 ̘_`l𐧌䂵ĂV[PT`lԍ	UINT8_MAX=(V[PT`lɐ䂳ĂȂӖB~Ӗ̂ł͂Ȃɒӂ)
	uint8_t				iCont;					//+ 7,  1 [vt[Yp[ms]
	 int32_t			iWait;					//+ 8,  4 ҂[ms]
} ST_TapLogCh;									//=12
/*---------------------------------------------------------------------------*/
//V[PT`l
typedef struct _ST_TapSeqCh {
	const uint8_t*			pData;					//+ 0,  4 V[PXf[^					NULL=(~Ӗ)
	 int32_t			iWait;					//+ 4,  4 ҂[ms]
} ST_TapSeqCh;									//= 8
/*---------------------------------------------------------------------------*/
//Cxgobt@
#define TapEvt_Play			0					//ĐJnʒm
#define TapEvt_Stop			1					//Đ~ʒm
#define TapEvt_Loop			2					//R[vʒm
#define TapEvt_End			3					//R~ʒm	
#define TapEvt_Next			4					//RJڒʒm							//{{2016/08/02ǉ:RJڒʒmǉ܂B}}
#define TapEvt_Ctrl			5					//Rg[ʒm
typedef struct _ST_TapEvt {
	uint8_t				iEvt;					//+ 0, 1							TapEvt_Play,TapEvt_Stop,TapEvt_Loop,TapEvt_End,TapEvt_Next,TapEvt_Ctrl																																		//{{2016/08/02RgύX:RJڒʒmǉ܂B}}
	uint8_t				iLogCh;					//+ 1, 1							0`(nLogCh-1)
	uint16_t			iPhr;					//+ 2, 2							0`(nPhr-1)
} ST_TapEvt;									//= 4
typedef struct _ST_TapEvtBuf {
	uint8_t				iAddPos;				//+ 0, 1 vfވʒu					0`nEvt
	uint8_t				iGetPos;				//+ 1, 1 vfǂݏoʒu					0`nEvt
	uint16_t			nOvrCnt;				//+ 2, 2 I[o[				0`UINT16_MAX	I[o[ꍇAɃobt@ɗLvf͈ێAƂvfB
//{{2016/08/19폜:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	ST_TapEvt			TBL_Buf[0/*(nEvt+1)*/];			//+ 4,(4*(nEvt+1))
//}}2016/08/19폜:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
} ST_TapEvtBuf;									//= 4+(4*(nEvt+1))
/*---------------------------------------------------------------------------*/
//V[PT
typedef struct _ST_TapSeq {
	const struct _ST_TapSeqInfo*	pInfo;					//+ 0,  4 
    //	ST_TapDevCh			TBL_DevCh[(nDevCh+3)&~3];		//+ 4, 1N foCX`l
    //	ST_TapLogCh			TBL_LogCh[ nLogCh      ];		//+ ?,12N _`l
    //	ST_TapSeqCh			TBL_SeqCh[ nSeqCh      ];		//+ ?, 8N V[PT`l
    //	ST_TapEvtBuf			    EvtBuf;				//+ ?,  * Cxgobt@					(nEvt=0)ȂΑ݂ȂB
    //	ST_TapEvt			TBL_Buf[(nEvt+1)];			//+ ?,  * Cxg						(nEvt=0)ȂΑ݂ȂB
} ST_TapSeq;									//= ?
/*---------------------------------------------------------------------------*/
//
typedef struct _ST_TapSeqInfo {
	uint16_t			nPhr;					//+ 0,  2 t[Y						1`UINT16_MAX	̃tB[h̓G[ô߂ɎgpĂBG[osvȂΏUINT16_MAXݒ肵č\ȂB
	uint8_t				nDevCh;					//+ 2,  1 foCX`l					1`UINT8_MAX
	uint8_t				nLogCh;					//+ 3,  1 _`l					1`UINT8_MAX
	uint8_t				nSeqCh;					//+ 4,  1 V[PT`l					1`UINT8_MAX
	uint8_t				iCont;					//+ 5,  1 [vt[Yp[ms]			0`UINT8_MAX	0Ȃ΃[vt[YpsȂB
	uint8_t				nEvt;					//+ 6,  1 CxgL^					0`UINT8_MAX	0Ȃ΃CxgL^ȂB			(ST_RinBuf.iMaxPos)ɑlłB]Ďۂ̔zvf(nEvt+1)mۂB
	uint8_t				iEvtMsk;				//+ 7,  1 Cxg}XN					1<<TapEvt_Play,1<<TapEvt_Stop,1<<TapEvt_Loop,1<<TapEvt_End,1<<TapEvt_Next,1<<TapEvt_Ctrl̑gݍ킹BrbgZbgĂCxg̎ނL^܂BʓIɂ(~(1<<TapEvt_Ctrl))w肷̂ǂ낤BTapEvt_Ctrl͕pxăobt@鋰ꂪL邵ATapEvt_Ctrlɑ΂Ċ荞݊Oōs낤B		//{{2016/08/02RgύX:RJڒʒmǉ܂B}}
//{{2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//	void (*fnPlay)(int iLogCh, ST_TapLogCh* pLogCh);			//+ 8,  4 ĐJnʒm
//	void (*fnStop)(int iLogCh, ST_TapLogCh* pLogCh);			//+12,  4 Đ~ʒm
//	void (*fnLoop)(int iLogCh, ST_TapLogCh* pLogCh);			//+16,  4 R[vʒm					fnPlayƓR[obN֐ݒ肵ĂǂB
//	void (*fnEnd )(int iLogCh, ST_TapLogCh* pLogCh);			//+20,  4 R~ʒm						fnStopƓR[obN֐ݒ肵ĂǂB
//	void (*fnNext)(int iLogCh, ST_TapLogCh* pLogCh);			//+24,  4 RJڒʒm						fnPlayƓR[obN֐ݒ肵ĂǂB			//{{2016/08/02ǉ:RJڒʒmǉ܂B}}
//	void (*fnCtrl)(int iLogCh, ST_TapLogCh* pLogCh);			//+28,  4 Rg[ʒm
//	int  (*fnGetPhrTime)(int iPhr);						//+32,  4 t[Y[ms]擾B				(0`INT_MAX)ԂB
//	int  (*fnGetPhrNext)(int iPhr);						//+36,  4 t[Y`FC̎̃t[Yԍ擾B	ʏt[YȂ-1ԂBSt[YȂ-2ԂBԃt[YȂ0`(nPhr-1),,iPhrȊO̒lԂB[vt[YȂiPhrԂB
//2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
	void (*fnPlay)(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+ 8,  4 ĐJnʒm
	void (*fnStop)(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+12,  4 Đ~ʒm
	void (*fnLoop)(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+16,  4 R[vʒm					fnPlayƓR[obN֐ݒ肵ĂǂB
	void (*fnEnd )(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+20,  4 R~ʒm						fnStopƓR[obN֐ݒ肵ĂǂB
	void (*fnNext)(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+24,  4 RJڒʒm						fnPlayƓR[obN֐ݒ肵ĂǂB			//{{2016/08/02ǉ:RJڒʒmǉ܂B}}
	void (*fnCtrl)(ST_TapSeq* pTapSeq, int iLogCh, ST_TapLogCh* pLogCh);	//+28,  4 Rg[ʒm
	int  (*fnGetPhrTime)(ST_TapSeq* pTapSeq, int iPhr);			//+32,  4 t[Y[ms]擾B				(0`INT_MAX)ԂB
	int  (*fnGetPhrNext)(ST_TapSeq* pTapSeq, int iPhr);			//+36,  4 t[Y`FC̎̃t[Yԍ擾B	ʏt[YȂ-1ԂBSt[YȂ-2ԂBԃt[YȂ0`(nPhr-1),,iPhrȊO̒lԂB[vt[YȂiPhrԂB
//}}2016/10/13ύX:fnPlay,fnStop,fnLoop,fnEnd,fnNext,fnCtrl,fnGetPhrTime,fnGetPhrNexẗɁApTapSeqǉ܂B
//{{2016/08/19폜:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
//	const uint8_t*		TBL_TapSet[0/*nLogCh*/];			//+40, 4N TAPZbg
//}}2016/08/19폜:ST_TapEvtBuf.TBL_Buf[0]tB[h,y,ST_TapSeqInfo.TBL_TapSet[0]tB[hp~āAŖIɃAhX߂悤ɂ܂BtB[h̐錾p~ŁACAEg͕ςĂ܂B
} ST_TapSeqInfo;								//= ?
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -*/
//dv
//AvP[V`̃R[obN֐̒AW[̊֐ĂяoĂ͂ȂB
//W[̎́AR[obN֐̌ĂяoɁAW[̓ԂωȂOƂĂB
//AR[obN֐̒瓖W[̊֐ĂяoƁAԂωė\łȂ쌋ʂƂȂB
/*****************************************************************************
 *	O[o֐錾
 *****************************************************************************/
//V[PT
ST_TapSeq* TapSeq_New(const ST_TapSeqInfo* pInfo);
void TapSeq_Init(ST_TapSeq* pTapSeq, const ST_TapSeqInfo* pInfo);
void TapSeq_Free(ST_TapSeq* pTapSeq);
void TapSeq_Exec(ST_TapSeq* pTapSeq, int iElapTime);
//_`l
void TapLogCh_Play(ST_TapSeq* pTapSeq, int iLogCh, int iPhr, int iLoop, int iAtt, int iPan);
void TapLogCh_Stop(ST_TapSeq* pTapSeq, int iLogCh);
void TapLogCh_Ctrl(ST_TapSeq* pTapSeq, int iLogCh, int iAtt, int iPan);
//V[PT`l
void TapSeqCh_Play(ST_TapSeq* pTapSeq, int iSeqCh, const void* pData);
void TapSeqCh_Stop(ST_TapSeq* pTapSeq, int iSeqCh);
//
ST_TapDevCh* TapSeq_GetDevCh(ST_TapSeq* pTapSeq, int iDevCh);
ST_TapLogCh* TapSeq_GetLogCh(ST_TapSeq* pTapSeq, int iLogCh);
ST_TapSeqCh* TapSeq_GetSeqCh(ST_TapSeq* pTapSeq, int iSeqCh);
//Cxg
ST_TapEvt* TapSeq_EvtGet(ST_TapSeq* pTapSeq);	//(nEvt=0)w肵ꍇ͌ĂяoĂ͂ȂB
int TapSeq_EvtOvr(ST_TapSeq* pTapSeq);		//(nEvt=0)w肵ꍇ͌ĂяoĂ͂ȂB
/****************************************************************************
 *	dTapSeqC.exeo͂oCi`߂̃[eBeB֐
 ****************************************************************************/
#define USE_TAPDEF_BIN	//[eBeB֐svȂ΂̃V{`RgAEgĂB
#ifdef  USE_TAPDEF_BIN
void TapSeqCh_PlayNo(ST_TapSeq* pTapSeq, int iTapSeqCh, const void* pTapDefBin, int iTapSeqNo);
#endif//USE_TAPDEF_BIN
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_TAPS_H__
