/*	
 *	clipt18.h
 *
 *	P/ECE TMS9918(A) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Mon Jan 3 13:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sun Jan 30 21:25:00 JST 2005 Naoyuki Sawa
 *	- RgԈႦSN76489ƏĂ܂ĂƂTMS9918ɏCB
 *	  vOe̕ύX͂܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_T18_H__
#define __CLIP_T18_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* TMS9918_ASMV{`ǂݍ݂܂B
 * TMS9918_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipt18a.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef TMS9918_ASM
#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

typedef struct _TMS9918 {
	unsigned short addr;		/* + 0,  2: Address (0x0000-0x3fff) gppx̂1߂ŃANZXł悤擪ɔzu */
	         short latch;		/* + 2,  2: Port#1ւ̏ݒlێ (-1:) */
	unsigned char  reg[8];		/* + 4,  8: Register */
	unsigned char  status;		/* +12,  1: Status */
	unsigned char  resv[3];		/* +13,  3: (\) */
	unsigned char  vram[0x4000];	/* +16,16K: VRAM (16KB) */
} TMS9918;

/****************************************************************************
 *
 ****************************************************************************/

/* TMS9918_GRAYSCALEV{`ƁA16~OCXP[o͂ƂȂ܂B
 * TMS9918_GRAYSCALEV{`Ȃ΁A16pbgJ[o͂ƂȂ܂B
 */
#ifdef PIECE
#define TMS9918_GRAYSCALE
#endif /*PIECE*/

#ifdef TMS9918_GRAYSCALE
/* TMS9918W[gpłBAvP[VgKv͂܂B */
extern const unsigned char tms9918_grayscale_table[16];
#else /*TMS9918_GRAYSCALE*/
/* 16FJ[̃pbg`܂BWin32BITMAPINFO.bmiColors[]̐ݒɗpĂB */
extern const unsigned char tms9918_color_table[16][3/*R,G,B*/];
#endif /*TMS9918_GRAYSCALE*/

/****************************************************************************
 *	gp
 ****************************************************************************/

void tms9918_update_graphics1(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Graphics I */
void tms9918_update_graphics2(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Graphics II */
void tms9918_update_multicolor(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Multicolor */
void tms9918_update_text(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);		/* Text */

void tms9918_update_sprite00(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Size0, MAG0 */
void tms9918_update_sprite01(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Size0, MAG1 */
void tms9918_update_sprite10(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Size1, MAG0 */
void tms9918_update_sprite11(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);	/* Size1, MAG1 */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* TMS9918RAZbg܂B
 * [in]
 *	tms9918		TMS9918\́B
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ATMS9918ZbgsꍇɁAKvɉČĂяoĂB
 */
void tms9918_reset(TMS9918* tms9918);

/* TMS99181oCgǂݏo܂B
 * [in]
 *	tms9918		TMS9918\́B
 *	mode		  0 : Port#0 (VRAM)
 *			  1 : Port#1 (Status)
 */
int tms9918_read(TMS9918* tms9918, int mode);

/* TMS99181oCg݂܂B
 * [in]
 *	tms9918		TMS9918\́B
 *	mode		  0 : Port#0 (VRAM)
 *			  1 : Port#1 (Register/Address)
 *	data		ރf[^B
 */
void tms9918_write(TMS9918* tms9918, int mode, int data);

/* ʂ`悵܂B
 * [in]
 *	tms9918		TMS9918\́B
 *	vbuff		256x192ʃobt@B
 *
 * [note]
 *	* TMS9918_GRAYSCALE`ĂƁA16~OCXP[o͂ƂȂ܂B
 *	  TMS9918_GRAYSCALE`ĂȂ΁A16pbgJ[o͂ƂȂ܂B
 *	* P/ECEp128x88ʂ쐬ɂ́A256x192ʂ쐬ƂŁA
 *	  tms9918_reduce()Ăŉʃobt@̓ekĂB
 *	  256x192128x88ʃobt@͋L\Ȃ̂ŁA256x192ʃobt@pӂΏ[łB
 *	  ڂ́Atms9918_reduce()̃RgQƂĂB
 */
int tms9918_update(TMS9918* tms9918, unsigned char vbuff[/*256 * 192*/]);

#ifdef TMS9918_GRAYSCALE
/* 256x192x16~OCXP[A128x88x16~OCXP[֏kRs[܂B
 * [in]
 *	src		256x192x16~OCXP[ʃobt@B
 *	dst		128x 88x16~OCXP[ʃobt@B
 *
 * [note]
 *	* srcdst͓AhXwĂĂ\܂B
 *	  ŏII128x88̉ʃC[WKvȂ΁A256x192128x88̉ʃobt@ʉāA
 *	  ߖł܂B
 *		unsigned char vbuff[256*192]; // O[128*88]ƂĎgp
 *		tms9918_update(tms9918, vbuff);
 *		tms9918_reduce(vbuff, vbuff);
 *	* ̊֐́ATMS9918W[̑̕犮SɓƗĂ܂B
 *	  256x192x16GS128x88x16GSksʂ΁APƂŗp\łB
 */
void tms9918_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*256*192*/]);
/* TMS9918W[gpłBAvP[VgKv͂܂B */
extern const unsigned char tms9918_div6_table[15 * 6 + 1];
#endif TMS9918_GRAYSCALE

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_T18_H__*/
