/*	
 *	cliprenf.h
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2008 Naoyuki Sawa
 *
 *	* Sun Aug 10 01:12:48 JST 2008 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Aug 17 22:24:29 JST 2008 Naoyuki Sawa
 *	- vecfvec3fAmatfmat3fAvecxvec3xAmatxmat3xɖOύX܂B
 *	  Suŕϊ̂ŁA{ȑÕRgȂǂׂĖOύXĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_RENF_H__
#define __CLIP_RENF_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	RENDF
 *****************************************************************************/

typedef struct _RENDF_SAVE {
	mat3f matrix;		/* + 0,48 */
	TEXTURE* texture;	/* +48, 4 */
} RENDF_SAVE;			/* =52    */
#define RENDF_SAVE_MAX	8	/*  */

typedef struct _RENDF {
	//{{RENDF_SAVE
	mat3f matrix;		/* + 0,48 */
	TEXTURE* texture;	/* +48, 4 */
	//}}RENDF_SAVE
	SURFACE* surface;	/* +52, 4 */
	float front;		/* +56, 4 */
	float back;		/* +60, 4 */
	float left;		/* +64, 4 */
	float right;		/* +68, 4 */
	float top;		/* +72, 4 */
	float bottom;		/* +76, 4 */
	//
	/*{{View Frustum Culling*/
	mat3f vfc_matrix;	/* (r[|[gϊ~ϊ)̋ts */
	float vfc_width_2;	/* ONbsOʂ̔̕ */
	float vfc_height_2;	/* ONbsOʂ̍̔ */
	/*}}View Frustum Culling*/
	//
	int save_cnt;
	RENDF_SAVE save[RENDF_SAVE_MAX];
} RENDF;

/*---------------------------------------------------------------------------*/

void rendf_init(RENDF* r, SURFACE* surface, int x, int y, int width, int height, float front, float back, float fovy);
void rendf_save(RENDF* r);
void rendf_restore(RENDF* r);
void rendf_mesh(RENDF* r, const MESH* mesh); /* MESH̒_Wvec3f[]Ƃ */
void rendf_wire(RENDF* r, const WIRE* wire, int color); /* WIRE̒_Wvec3f[]Ƃ */
void rendf_line(RENDF* r, const vec3f* v0, const vec3f* v1, int color);

/*---------------------------------------------------------------------------*
 *	JO
 *---------------------------------------------------------------------------*/

/* EgāAJO(VFC: View Frustum Culling)̃eXgs܂B
 * [in]
 *	r		RENDFւ̃|C^B
 *	bounding_sphere	E̔aB
 * [out]
 *	߂l		E̊SɓɗL邩Aꕔ܂ޏꍇA0ȊO̒lԂ܂B
 *			E̊SɊOɗLꍇA0Ԃ܂B
 * [note]
 *	* <gp>
 *		float bounding_sphere = meshf_bounding_sphere(mesh);	// E̔a߂Ă
 *			...
 *		mat3f_...(&rendf.matrix, ...);				// ړA]Ȃ
 *		if(rendf_vfc_sphere(&rendf, bounding_sphere)) {		// E̒ɌĂȂ
 *			rendf_mesh(&rendf, mesh);			// ۂɕ`s܂
 *		}
 *	* ϊs̕sړgāAE̒SW𔻒fAJOs܂B
 *	  rendf_vfc_sphere()́Aϊs̃XP[Ol܂B
 *	  gAk̕ϊsĂꍇArendf_vfc_sphere()̖߂ĺAʂƂȂ܂B
 *	  gAk̕ϊsĂꍇAĂяoɂāAE̔a悸KvL܂B
 *	* SẴIuWFNgɑ΂ĎJOs킯ł͂Ȃ̂ŁAčĂ܂B
 *	  JO̒ŖA(r[|[gϊ~ϊ)̋ts|(fr[ϊ)擾A
 *	  (r[|[gϊ~ϊ)(fr[ϊ)𕪂ĕێĂAJO͍ɂȂ܂B
 *	  A`悾sȂ(r[|[gϊ~ϊ~fr[ϊ)ĕێłB
 *	  JO͕⏕IɗpAJOɕ`sƍlāA`̍d܂B
 */
int rendf_vfc_sphere(RENDF* r, float bounding_sphere);

/* bVf̋E̔a߂܂B
 * [in]
 *	mesh		bVfւ̃|C^B
 * [out]
 *	߂l		E̔aB
 */
float meshf_bounding_sphere(const MESH* mesh);

/* C[t[f̋E̔a߂܂B
 * [in]
 *	mesh		C[t[fւ̃|C^B
 * [out]
 *	߂l		E̔aB
 */
float wiref_bounding_sphere(const WIRE* wire);

/*---------------------------------------------------------------------------*/

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_RENF_H__*/
