/*	
 *	clipmenu.h
 *
 *	ėpj[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2006 Naoyuki Sawa
 *
 *	* Sat Jul 01 20:20:32 JST 2006 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Jul 02 15:36:40 JST 2006 Naoyuki Sawa
 *	- XN[ʒu(MENU.top)̐ݒA`撼O(menu_disp())ɍs悤ύXB
 *	* Tue Nov 07 13:03:08 JST 2006 Naoyuki Sawa
 *	- clipmisc.hARRAYLISTOύXɒǏ]܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_MENU_H__
#define __CLIP_MENU_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/*****************************************************************************
 *	ėpj[
 *****************************************************************************/

/* j[pbg\̂łB
 * - menu_set_palette()ւ̈ƂĎg܂B
 *   ʏ4KAсA16K[hṕAWpbg`ς݂łB
 *   ܂́AAvP[VvOɂāAƎɒ`邱Ƃ\łB
 */
typedef struct _MENUPALETTE {
	unsigned char item;	/* j[ڕ */
	unsigned char back;	/* j[ڔwi */
	unsigned char title;	/* ^Cg */
	unsigned char border;	/* ^CgwiAсAg */
} MENUPALETTE;
extern const MENUPALETTE menu_palette_std;	/*  4KWj[pbg */
extern const MENUPALETTE menu_palette_ldir;	/* 16KWj[pbg */

/* j[\̂łB
 * - AvP[VvOA\̃oݒEQƂĂ͂܂B
 *   KAmenu_*()֐gpĂB
 */
typedef struct _MENU {
	int sel;		/* ݂̑I */
	int top;		/* ݂̍ŏi (XN[) */
	//			/* toṕAmenu_disp()̒ŗp܂B                                        */
	//			/* top̐ݒA`撼Oɍs܂B́gځĥ߂̑łB   */
	//			/* menu_set_sel()ɂIύXɁAItopύX邱Ƃ͂܂B     */
	//			/* Ȃ킿Atop͏ɐXN[ʒu(ŏi)wĂƂ͌܂B */
	//			/* AvP[VځAtopQƂݒ肵肵Ȃ悤ӂĂB   */
	//
	int x;			/* j[̈ */
	int y;
	int w;
	int h;
	int font;		/* tHg (0 or 1 or 2) */
	MENUPALETTE palette;	/* pbg */
	//
	char* title;		/* ^Cg (ĕێBNULL = ) */
	LIST* items;		/* j[ڂ̃Xg */
} MENU;

/* j[쐬܂B
 * [out]
 *	߂l		쐬j[B
 * [note]
 *	* j[쐬̏Ԃ́Aȉ̒ʂłB
 *		I	I𖳂
 *		j[̈	ʑS̕\
 *		tHg	10hbg{tHg
 *		pbg	4KWj[pbg
 *		^Cg	
 *		j[	
 *	  j[쐬ɁAKvɉāAݒ̕ύXƃj[ڂ̒ǉsĂB
 *	* j[svɂȂAmenu_delete()ĂяoāAj[폜ĂB
 */
MENU* menu_create();

/* j[폜܂B
 * [in]
 *	menu		폜郁j[B
 */
void menu_delete(MENU* menu);

/* IԂݒ肵܂B
 * [in]
 *	menu		j[B
 *	sel		0`j[ڐ-1EEEIځB
 *			                 -1EEEI𖳂B
 */
void menu_set_sel(MENU* menu, int sel);

/* IԂ擾܂B
 * [in]
 *	menu		j[B
 * [out]
 *	߂l		0`j[ڐ-1EEEIځB
 *			                 -1EEEI𖳂B
 * [note]
 *	* j[OAсAj[̂łĂяo\łB
 */
int menu_get_sel(MENU* menu);

/* j[̈ݒ肵܂B
 * [in]
 *	menu		j[B
 *	(x,y,w,h)	j[̈B
 *			^Cg(L)AсAg̗̈܂݂܂B
 */
void menu_set_pos(MENU* menu, int x, int y, int w, int h);

/* tHgݒ肵܂B
 * [in]
 *	menu		j[B
 *	font		0܂0x80EEE5~10hbg{tHgB
 *			1܂0x81EEE8~10hbgptHgB
 *			2܂0x82EEE4~ 6hbgptHgB
 * [note]
 *	* tHgԍbit7(stO)͖܂B
 *	  bit7ZbgĂȂĂAe܂B
 */
void menu_set_font(MENU* menu, int font);

/* pbgݒ肵܂B
 * [in]
 *	menu		j[B
 *	palette		pbgB
 * [note]
 *	* menu_set_palette()́Aw肳ꂽpbg𕡐Ċi[܂B
 *	  ĂяoɂāApaletteɎw肵̓eێKv͂܂B
 */
void menu_set_palette(MENU* menu, const MENUPALETTE* palette);

/* ^Cgݒ肵܂B
 * [in]
 *	menu		j[B
 *	title		^CgB
 *			NULLw肷ƁA^CgƂȂ܂B
 * [note]
 *	* menu_set_title()́AtitleɎw肳ꂽ𕡐Ċi[܂B
 *	  ĂяoɂāAtitleɎw肵̓eێKv͂܂B
 */
void menu_set_title(MENU* menu, const char* title);

/* ɁAj[ڂǉ܂B
 * [in]
 *	menu		j[B
 *	item		j[ڕB
 *			NULLw肷邱Ƃ͂ł܂B
 * [note]
 *	* umenu_insert_item(menu, menu_num_items(menu), item);vƓłB
 */
void menu_add_item(MENU* menu, const char* item);

/* w肳ꂽʒuɁAj[ڂǉ܂B
 * [in]
 *	menu		j[B
 *	i_item		j[ڃCfNXB
 *			  0`j[ڐ-1EEErɃj[ڂǉ܂B
 *			     j[ڐ  EEEɃj[ڂǉ܂B
 *	item		j[ڕB
 *			NULLw肷邱Ƃ͂ł܂B
 * [note]
 *	* menu_add_item()AсAmenu_insert_item()́AitemɎw肳ꂽ𕡐Ċi[܂B
 *	  ĂяoɂāAitemɎw肵̓eێKv͂܂B
 *	* j[ڂԂA߂̍ڂǉƂAIɂ̍ڂI܂B
 *	  ߈ȍ~̃j[ڂǉƂ́AIԂύX܂B
 *	- I𖳂̏ԂłĂA߂̃j[ڒǉłȂ΁AIԂύX܂B
 *	  ̗QlɂĂB
 *	  (menu_add_item()gėᎦĂ܂Amenu_insert_item()łlłB)
 *
 *		menu = menu_create();
 *		menu_add_item(menu, ""); // ߂Ȃ̂ŁAIɑI
 *		menu_add_item(menu, ""); // ""Iꂽ܂
 *		menu_set_sel(menu, -1);      // IɑI𖳂ɂ
 *		menu_add_item(menu, ""); // I𖳂̂܂
 *		menu_clear_items(menu);      // j[ڂԂɖ߂
 *		menu_add_item(menu, ""); // ߂Ȃ̂ŁAIɑI
 */
void menu_insert_item(MENU* menu, int i_item, const char* item);

/* j[ڂύX܂B
 * [in]
 *	menu		j[B
 *	i_item		j[ڃCfNXB(0`j[ڐ-1)
 *	item		j[ڕB
 *			NULLw肷邱Ƃ͂ł܂B
 */
void menu_set_item(MENU* menu, int i_item, const char* item);

/* j[ڂ폜܂B
 * [in]
 *	menu		j[B
 *	i_item		j[ڃCfNXB(0`j[ڐ-1)
 * [note]
 *	* 폜ȎIڂƁA폜鍀ڂɂāAIԂ͓K؂ɕω܂B
 *	  ԂAςǂ̋łƎv܂B
 *	  ڍׂ́A֐RgQƂĂB
 */
void menu_remove_item(MENU* menu, int i_item);

/* j[ڂׂĔj܂B
 * [in]
 *	menu		j[B
 */
void menu_clear_items(MENU* menu);

/* j[ڂ擾܂B
 * [in]
 *	menu		j[B
 *	i_item		j[ڃCfNXB(0`j[ڐ-1)
 *	buf		j[ڕi[obt@B
 *			NULLw肷ƁAj[ڕi[܂B
 *	buflen		obt@̃oCgB
 *			j[ڕ(buflen-1)ꍇA擪(buflen-1)̂݊i[A
 *			buflenڂ'\0'i[܂B
 * [out]
 *	߂l		j[ڕB(I['\0'͊܂܂Ȃ)
 *			obt@Ɋi[ł͂ȂAۂ̃j[ڕԂ܂B
 * [note]
 *	* mɃj[ڕ񂷂ׂĂ󂯎邽߂ɂ́Â悤ɎgpĂB
 *
 *		len = menu_get_item(menu, i_item, NULL, 0);
 *		buf = malloc(len + 1);
 *		menu_get_item(menu, i_item, buf, len + 1);
 *		** bufɊi[ꂽgp **
 *		free(buf);
 *
 *	  炩߁A[傫ȃobt@pӂłꍇ́APɈĂяoł\܂B
 */
int menu_get_item(MENU* menu, int i_item, char* buf, int buflen);

/* j[ڐ擾܂B
 * [in]
 *	menu		j[B
 * [out]
 *	߂l		j[ڐB
 */
int menu_num_items(MENU* menu);

/* j[1Xebvs܂B
 * [in]
 *	menu		j[B
 * [out]
 *	߂l		j[A0ȊOԂ܂B
 *			j[pꍇ́A0Ԃ܂B
 * [note]
 *	* j[v́Aȉ̒ʂłB
 *	- IEEEj[ڂIꂽԂA{^ꂽB
 *	  j[ڂIĂȂԂł́AIł܂B
 *	  ]āAj[ڂꍇ́ALZł܂B
 *	- LZEEEB{^ꂽB
 *	  LŹAł\łB
 *	  LZsƂꍇ́Â悤ɌĂяoĂB
 *
 *		retval = menu_action(menu, joy & ~TRG_B);
 *
 *	* j[ɁAmenu_get_sel()ĂяoĂB
 *	  menu_get_sel()̖߂l-1Ȃ΁Av̓LZłB
 *	  menu_get_sel()̖߂l0ȏȂ΁Av͑IłA
 *	  menu_get_sel()̖߂lAIꂽj[ڂ̃CfNXłB
 *
 *		menu = menu_create();
 *		menu_set_title(menu, "Sample Menu");
 *		menu_add_item(menu, "One");
 *		menu_add_item(menu, "Two");
 *		menu_add_item(menu, "Three");
 *		for(;;) {
 *			schedule();
 *			if(menu_action(menu)) { // j[
 *				break;
 *			}
 *			menu_disp(menu); // j[`
 *		}
 *		retval = menu_get_sel(menu);
 *		if(retval >= 0) {
 *			// j[[retval]I肳܂B
 *		} else {
 *			// LZ܂B
 *		}
 *		menu_delete(menu);
 */
int menu_action(MENU* menu, int joy);

/* j[`܂B
 * [in]
 *	menu		j[B
 */
void menu_disp(MENU* menu, RENDER* render);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif/*__CLIP_MENU_H__*/
