/*	
 *	clipffa.h
 *
 *	L̉Z (Finite Field Arithmetic)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2015 Naoyuki Sawa
 *
 *	* Sun Aug 16 19:57:01 JST 2015 Naoyuki Sawa
 *	- 쐬JnB
 *	* Sat Aug 22 15:44:43 JST 2015 Naoyuki Sawa
 *	- Polynomial_Parse()ǉ܂B
 *	* Tue Aug 25 00:57:49 JST 2015 Naoyuki Sawa
 *	- Polynomial_ParseF(),Polynomial_ParseV()ǉ܂B
 *	* Wed Aug 26 23:08:45 JST 2015 Naoyuki Sawa
 *	- BCH̊֐쐬Jn܂B
 *	* Fri Aug 28 20:48:55 JST 2015 Naoyuki Sawa
 *	- GaloisField_Det(),GaloisField_Cof(),GaloisField_Solve()ǉ܂B
 *	* Sat Aug 29 00:01:08 JST 2015 Naoyuki Sawa
 *	- BCH_Decode()ǉ܂B
 *	* Sun Aug 30 13:35:11 JST 2015 Naoyuki Sawa
 *	- GaloisField_Deg()ǉ܂B
 *	* Sun Aug 30 18:40:22 JST 2015 Naoyuki Sawa
 *	- [h\̊֐쐬Jn܂B
 *	* Mon Aug 31 21:31:32 JST 2015 Naoyuki Sawa
 *	- GaloisField_NewDeg()ǉ܂B
 *	* Mon Oct 19 22:47:19 JST 2015 Naoyuki Sawa
 *	- BCH_EncodeN(),BCH_DecodeN(),ReedSolomon_EncodeN(),ReedSolomon_DecodeN()ɃRgǋL܂B
 *	  ܂͕ύXĂ܂B
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_FFA_H__
#define __CLIP_FFA_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
/****************************************************************************
 *	KA
 ****************************************************************************/
typedef struct _ST_GaloisField {
	uint8_t		max;		//(2^deg)-1	(2^deg)-1=1`255	rbg\̍ől
	uint8_t		deg;		//   deg	   deg=1`8		g原
	uint8_t		exp[256];	//exp[i]=a^i	i=0`max-1,a^i=1`max	w\˃rbg\
	uint8_t		log[256];	//log[a^i]=i	a^i=1`max,i=0`max-1	rbg\ˎw\
} ST_GaloisField;
/*--------------------------------------------------------------------------*/
ST_GaloisField* GaloisField_New(int Gx);
ST_GaloisField* GaloisField_NewDeg(int deg);
void GaloisField_Free(ST_GaloisField* pGF);
int GaloisField_Max(ST_GaloisField* pGF);
int GaloisField_Deg(ST_GaloisField* pGF);
int GaloisField_Exp(ST_GaloisField* pGF, int i);
int GaloisField_Log(ST_GaloisField* pGF, int c);
int GaloisField_Add(ST_GaloisField* pGF, int x, int y);
int GaloisField_Sub(ST_GaloisField* pGF, int x, int y);
int GaloisField_Mul(ST_GaloisField* pGF, int x, int y);
int GaloisField_Div(ST_GaloisField* pGF, int x, int y);
int GaloisField_Det(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, int n);
int GaloisField_Cof(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, int n, int i, int j);
int GaloisField_Solve(ST_GaloisField* pGF, const uint8_t* A/*[n][n]*/, const uint8_t* b/*[n]*/, uint8_t* x/*[n]*/, int n);
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _ST_Polynomial {
	ST_GaloisField*		pGF;		//KẪ|C^	KÂ̍쐬ƊJ́AĂяȍłȂĂB
	uint8_t			coef[256];	//We[u		coef[0]*(x^0) + coef[1]*(x^1) + ... + coef[255]*(x^255)
} ST_Polynomial;
/*--------------------------------------------------------------------------*/
ST_Polynomial* Polynomial_New(ST_GaloisField* pGF);
void Polynomial_Free(ST_Polynomial* pP);
int Polynomial_Deg(ST_Polynomial* pP);
int Polynomial_GetCoef(ST_Polynomial* pP, int i);
void Polynomial_SetCoef(ST_Polynomial* pP, int i, int c);
void Polynomial_AddCoef(ST_Polynomial* pP, int i, int c);
void Polynomial_SubCoef(ST_Polynomial* pP, int i, int c);
void Polynomial_MulCoef(ST_Polynomial* pP, int i, int c);
void Polynomial_DivCoef(ST_Polynomial* pP, int i, int c);
ST_Polynomial* Polynomial_Add(ST_Polynomial* pP1, ST_Polynomial* pP2);
ST_Polynomial* Polynomial_Sub(ST_Polynomial* pP1, ST_Polynomial* pP2);
ST_Polynomial* Polynomial_Mul(ST_Polynomial* pP1, ST_Polynomial* pP2);
ST_Polynomial* Polynomial_Div(ST_Polynomial* pP1, ST_Polynomial* pP2);
ST_Polynomial* Polynomial_Mod(ST_Polynomial* pP1, ST_Polynomial* pP2);
int Polynomial_Assign(ST_Polynomial* pP, int x);
char* Polynomial_Str(ST_Polynomial* pP);
ST_Polynomial* Polynomial_Parse(ST_GaloisField* pGF, const char* str);
ST_Polynomial* Polynomial_ParseF(ST_GaloisField* pGF, const char* fmt, ...);
ST_Polynomial* Polynomial_ParseV(ST_GaloisField* pGF, const char* fmt, va_list ap);
/****************************************************************************
 *	BCH
 ****************************************************************************/
typedef struct _ST_BCH {
	ST_GaloisField*		pGF;	//KẪ|C^	KÂ̍쐬ƊJ́AĂяȍłȂĂB
	ST_Polynomial*		pGP;	//
	uint8_t			q;	//\ꐔ
	uint8_t			d;	//ԋ=\ꐔ*2+1
	uint8_t			n;	//ꐔ
	uint8_t			k;	//񕄍ꐔ
	uint8_t			m;	//ꐔ=ꐔ-񕄍ꐔ
} ST_BCH;
/*--------------------------------------------------------------------------*/
ST_BCH* BCH_New(ST_GaloisField* pGF, int q);
void BCH_Free(ST_BCH* pBCH);
void BCH_Encode( ST_BCH* pBCH, const void* aInfo/*int[(k+31)/32]*/, void* aSend/*int[(n+31)/32]*/);
void BCH_EncodeN(ST_BCH* pBCH, const void* aInfK/*int[(K+31)/32]*/, void* aSenN/*int[(N+31)/32]*/, int N);	//ZkBCH
int  BCH_Decode( ST_BCH* pBCH, const void* aRecv/*int[(n+31)/32]*/, void* aInfo/*int[(k+31)/32]*/);
int  BCH_DecodeN(ST_BCH* pBCH, const void* aRecN/*int[(N+31)/32]*/, void* aInfK/*int[(K+31)/32]*/, int N);	//ZkBCH
/****************************************************************************
 *	[h\
 ****************************************************************************/
typedef struct _ST_ReedSolomon {
	ST_GaloisField*		pGF;	//KẪ|C^	KÂ̍쐬ƊJ́AĂяȍłȂĂB
	ST_Polynomial*		pGP;	//
	uint8_t			q;	//\ꐔ
	uint8_t			d;	//ԋ=\ꐔ*2+1
	uint8_t			n;	//ꐔ
	uint8_t			k;	//񕄍ꐔ
	uint8_t			m;	//ꐔ=ꐔ-񕄍ꐔ
} ST_ReedSolomon;
/*--------------------------------------------------------------------------*/
ST_ReedSolomon* ReedSolomon_New(ST_GaloisField* pGF, int q);
ST_ReedSolomon* ReedSolomon_NewM(ST_GaloisField* pGF, int m);	//QRR[hp
void ReedSolomon_Free(ST_ReedSolomon* pRS);
void ReedSolomon_Encode( ST_ReedSolomon* pRS, const void* aInfo/*int[(r*k+31)/32]*/, void* aSend/*int[(r*n+31)/32]*/);		//r=pGF->deg
void ReedSolomon_EncodeN(ST_ReedSolomon* pRS, const void* aInfK/*int[(r*K+31)/32]*/, void* aSenN/*int[(r*N+31)/32]*/, int N);	//r=pGF->deg	//ZkRS
int  ReedSolomon_Decode( ST_ReedSolomon* pRS, const void* aRecv/*int[(r*n+31)/32]*/, void* aInfo/*int[(r*k+31)/32]*/);		//r=pGF->deg
int  ReedSolomon_DecodeN(ST_ReedSolomon* pRS, const void* aRecN/*int[(r*N+31)/32]*/, void* aInfK/*int[(r*K+31)/32]*/, int N);	//r=pGF->deg	//ZkRS
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_FFA_H__
