/*	
 *	clipdmv.h
 *
 *	P/ECE DMG-Video Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Feb 18 20:18:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_DMV_H__
#define __CLIP_DMV_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* DMGVIDEO_ASMV{`ǂݍ݂܂B
 * DMGVIDEO_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipdmva.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef DMGVIDEO_ASM
#endif /*PIECE*/

/****************************************************************************
 *
 ****************************************************************************/

/*  */
/* AZu[`璼ڎQƂĂ̂ŁAtH[}bgŒłB */
/* tH[}bgύXƂ́Aframdmva.s̒`Ǐ]ĂB */
/*  */
typedef struct _DMGVIDEO {
	unsigned char* mem;			/* + 0, 4: C̐擪AhX */
	unsigned char* vbuff/*[160*144]*/;	/* + 4, 4: ݃t[̕`^[Qbg (NULL:`斳) */
	unsigned char clut[4 * 3];		/* + 8,12:pbg ([0..3]=BGP,[4..7]=OBP0,[8..11]=OBP1) */
	unsigned char scan_start;		/* +20, 1: Ԃ̊JnC */
	unsigned char scan_end;			/* +21, 1: Ԃ̏IC */
	//					/* +22, 2: (pfBO) */
} DMGVIDEO;					/* =24 */

extern DMGVIDEO dmgvideo;

/****************************************************************************
 *
 ****************************************************************************/

void dmgvideo_partial_update();
void dmgvideo_draw_bg    ();
void dmgvideo_draw_window();
void dmgvideo_draw_sprite     (int priority);
void dmgvideo_draw_sprite_8x8 (int priority);
void dmgvideo_draw_sprite_8x16(int priority);
void dmgvideo_draw_chr       (int xpos, int ypos, int code, int palno);
void dmgvideo_draw_chr_opaque(int xpos, int ypos, int code, int palno);
void dmgvideo_draw_chr_revx  (int xpos, int ypos, int code, int palno);
void dmgvideo_draw_chr_revy  (int xpos, int ypos, int code, int palno);
void dmgvideo_draw_chr_revxy (int xpos, int ypos, int code, int palno);

/****************************************************************************
 *
 ****************************************************************************/

/* DMG-VideoRAZbg܂B
 * [in]
 *	mem		DMG-CPUƁACL܂B
 *			CԂ̐擪AhXw肵ĂB
 */
void dmgvideo_reset(unsigned char* mem);

/* DMG-Video1oCgǂݏo܂B
 * [in]
 *	addr		ǂݏoAhXB($FF40..$FF4B)
 * [out]
 *	߂l		ǂݏof[^B
 * [note]
 *	- WX^̈悩̓ǂݏóAK̊֐oRĂB
 *	- VRAM($8000-$9FFF)AуXvCgRAM($FE00..$FE9F)̓ǂݏóA
 *	  ڃC̓eǂݏoĂB
 */
int dmgvideo_read(int addr);

/* DMG-Video1oCg݂܂B
 * [in]
 *	addr		ރAhXB($FF40..$FF4B)
 *	data		ރf[^B
 * [note]
 *	- WX^̈ւ݂̏́AK̊֐oRĂB
 *	- VRAM($8000-$9FFF)AуXvCgRAM($FE00..$FE9F)ւ݂̏́A
 *	  ڃC̓eĂB
 */
void dmgvideo_write(int addr, int data);

/* Vt[Jn܂B
 * [in]
 *	vbuff		160x144ʃobt@B(NULL:̂݁A`斳)
 * [out]
 *	߂l		CPUւ̊荞ݗvB
 *			  bit0: V-Blank荞݂1B
 *			  bit1: LCDC Status荞݂1B
 * [note]
 *	- AvP[VvÓAdmgvideo_new_frame()ĂяoA
 *	  dmgvideo_next_line()154(=ʓ144+ʊO10C)sĂB
 *	  <>
 *		irq = dmgvideo_new_frame(draw);
 *		if(irq) {
 *			dmgmem[0xff0f] |= irq;
 *			dmgcpu_check_pending();
 *		}
 *		lines = 154;
 *		do {
 *			dmgcpu_run(dmgcpu.cycle + 456); // 1C=456TCNsAO̒[l
 *			irq = dmgvideo_next_line();
 *			if(irq) {
 *				dmgmem[0xff0f] |= irq; // Vertical Blank & LCDC Status Interrupt
 *				dmgcpu_check_pending();
 *			}
 *		} while(--lines);
 */
int dmgvideo_new_frame(unsigned char vbuff[/*160*144]*/]);

/* 1C(4.19MHz~456TCN)i߂܂B
 * [out]
 *	߂l		CPUւ̊荞ݗvB
 *			  bit0: V-Blank荞݂1B
 *			  bit1: LCDC Status荞݂1B
 * [note]
 *	- dmgvideo_new_frame()ɑ΂āAK154dmgvideo_next_line()ĂяoKvłB
 *	  154𒴂ČĂяoƁAAT[g܂B
 *	  154ɖȂƁÃt[̕`͕sȌʂƂȂ܂B
 *	- dmgvideo_new_frame()NULLȊỎʃobt@w肳ĂꍇA
 *	  Kvɉĉʂ̕XVA܂͑S̍XVs܂B
 */
int dmgvideo_next_line();

/* 160x144x4~OCXP[A128x88x4~OCXP[֏kRs[܂B
 * [in]
 *	src		160x144x4~OCXP[ʃobt@B
 *	dst		128x 88x4~OCXP[ʃobt@B
 *
 * [note]
 *	* srcdst͓AhXwĂĂ\܂B
 *	  ŏII128x88̉ʃC[WKvȂ΁A160x144128x88̉ʃobt@ʂɂāA
 *	  ߖł܂B
 */
void dmgvideo_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*144*/]);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_DMV_H__*/
