/*
 *	game.c
 *
 *	ǂ
 *
 *	* Tue Apr 25 21:31:44 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 */
#include "app.h"
/****************************************************************************
 *	
 ****************************************************************************/
extern /*const*/ unsigned char MAIN_BGM[];
/****************************************************************************
 *	
 ****************************************************************************/
#define STAT_READY		0			//Q[JnO
#define STAT_APPEAR		1			//ubNo
#define STAT_MOVE		2			//ubN쒆
#define STAT_GAMEOVER		3			//Q[I[o[
/*--------------------------------------------------------------------------*/
#define FIELD_COLS		6			//
#define FIELD_ROWS		(6+1)			//s					ŏi̓Q[I[o[płB
/*--------------------------------------------------------------------------*/
#define BLOCK_TYPE_MAX		13			//ubN̎ނ̍ől		0=,1`BLOCK_TYPE_MAX
/*--------------------------------------------------------------------------*/
#define FALL_SPEED		(H__CELL/2)		//x
/*--------------------------------------------------------------------------*/
#define MOVE_WAIT		SEC(2)			//JnOEFCg
#define MOVE_SPD_INIT		64			//x
/*--------------------------------------------------------------------------*/
#define EFFECT_ERASE		1			//ŃGtFNg
#define EFFECT_GAMEOVER		2			//Q[I[o[GtFNg
/*--------------------------------------------------------------------------*/
#define LEVUP_CNT		5			//xɑȂ邩B
#define MOVESPD_UPRATE		1.2			//{ɑȂ邩B
/****************************************************************************
 *	
 ****************************************************************************/
typedef struct _ST_Cell {
	uint8_t			type;			//0=,1`BLOCK_TYPE_MAX
	uint8_t			rot;			//](0`3)				ǒڂ̉]łB
	uint8_t			erase;			//}[N
	uint8_t			fall;			//}[N
} ST_Cell;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Effect {
	uint8_t			mode;			//GtFNg̎			0=,1`EFFECT_*
	uint8_t			type;			//1`BLOCK_TYPE_MAX
	uint8_t			anmCnt;			//Aj[VJE^
	short			x, y;			//ʒu
	short			vx, vy;			//x
	short			ax, ay;			//x
} ST_Effect;
/*--------------------------------------------------------------------------*/
typedef struct _ST_Game {
	uint16_t		score;			//XRA
	uint8_t			colors;			//ubN̎ސ
	uint8_t			stat;			//
	uint8_t			levUp;			//xAbvJE^
	//
	 int8_t			nextPosX;		//NEXTubN̈ʒu			-(W__CELL*2)X__NEXTX__CELL
	uint8_t			TBL_Next[2];		//NEXTubN̎			1`BLOCK_TYPE_MAX
	//
	uint8_t			movePosX;		//õubN̈ʒu		X__NEXTX__CELL+W__CELL*2
	uint8_t			movePosY;		//					Y__NEXTY__NEXT+H__CELL
	uint8_t			movePosYi;		//õubN̊KiAj[Vp̃JE^
	//
	uint8_t			moveWait;		//oAJn܂ł̃EFCg	MOVE_WAIT0
	uint8_t			moveCol;		//ubN̗			0`FIELD_COLS
	uint8_t			moveRow;		//ubN̍s			0`FIELD_ROWS
	 int16_t		moveOfs;		//ubN̍sItZbg		(?<<8)(0<<8)
	uint16_t		moveSpd;		//ubN̗x		(?<<8)
	uint8_t			TBL_Move[2];		//ubN̎			0`BLOCK_TYPE_MAX	ẼubNڒn{TBL_Move[1]=0}ƂB̃ubNڒnEubNL{TBL_Move[0]=TBL_Move[1];moveCol++}ƂB(TBL_Move[0]==0)ɂȂ痼̃ubNڒnƔfoB
	//
	 int8_t			fieldRot;		//tB[h]Aj[VJE^		-16=90x`0=0x`+16=E90x
	uint8_t			fieldFall;		//tB[hAj[VJE^		H__CELL0
	ST_Cell			TBL_Field[FIELD_ROWS][FIELD_COLS];	//tB[h
	//
	ST_Effect		TBL_Effect[FIELD_ROWS*FIELD_COLS];	//GtFNg
} ST_Game;
ST_Game stGame;		//B̃CX^X
/****************************************************************************
 *	next_init
 ****************************************************************************/
void next_init() {
	stGame.movePosX = stGame.nextPosX;
	stGame.movePosY = Y__NEXT;
	stGame.movePosYi = 0;
	stGame.TBL_Move[0] = stGame.TBL_Next[0];
	stGame.TBL_Move[1] = stGame.TBL_Next[1];
	//̏tɂȂ悤ɒӂB
	stGame.nextPosX = -(W__CELL*2);
	stGame.TBL_Next[0] = RND32_RANGE(seed, 1, stGame.colors + 1);
	stGame.TBL_Next[1] = RND32_RANGE(seed, 1, stGame.colors + 1);
}
/****************************************************************************
 *	field_rot_r
 ****************************************************************************/
void field_rot_r() {
	ST_Cell TBL_New[FIELD_ROWS][FIELD_COLS], cell;
	int col, row, new_col, new_row;
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			cell = stGame.TBL_Field[row][col];
			if(!row) {
				new_col = col;
				new_row = row;
			} else {
				new_col = FIELD_COLS - row;
				new_row = col + 1;
				if(cell.type) { cell.rot = (cell.rot + 1) & 3; }
				if((new_col < 0) || (new_col > FIELD_COLS - 1)) { DIE(); }
				if((new_row < 1) || (new_row > FIELD_ROWS - 1)) { DIE(); }
			}
			TBL_New[new_row][new_col] = cell;
		}
	}
	memcpy(stGame.TBL_Field, TBL_New, sizeof TBL_New);
}
/****************************************************************************
 *	field_rot_l
 ****************************************************************************/
void field_rot_l() {
	ST_Cell TBL_New[FIELD_ROWS][FIELD_COLS], cell;
	int col, row, new_col, new_row;
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			cell = stGame.TBL_Field[row][col];
			if(!row) {
				new_col = col;
				new_row = row;
			} else {
				new_col = row - 1;
				new_row = FIELD_ROWS - col - 1;
				if(cell.type) { cell.rot = (cell.rot - 1) & 3; }
				if((new_col < 0) || (new_col > FIELD_COLS - 1)) { DIE(); }
				if((new_row < 1) || (new_row > FIELD_ROWS - 1)) { DIE(); }
			}
			TBL_New[new_row][new_col] = cell;
		}
	}
	memcpy(stGame.TBL_Field, TBL_New, sizeof TBL_New);
}
/****************************************************************************
 *	check_fall
 ****************************************************************************/
void check_fall() {
	int col, row;
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			stGame.TBL_Field[row][col].fall = 0;
		}
	}
	for(row = FIELD_ROWS - 1; row > 0; row--) {
		for(col = 0; col < FIELD_COLS; col++) {
			ST_Cell* cell1 = &stGame.TBL_Field[row][col];
			if(!cell1->type) {
				ST_Cell* cell2 = &stGame.TBL_Field[row - 1][col];
				if(cell2->type) {
					memcpy(cell1, cell2, sizeof(ST_Cell));
					memset(cell2,     0, sizeof(ST_Cell));
					cell1->fall = 1;
					stGame.fieldFall = H__CELL;
				}
			}
		}
	}
}
/****************************************************************************
 *	effect_gen
 ****************************************************************************/
void effect_gen(int mode, int type, int col, int row) {
	int i;
	for(i = 0; i < ARRAY_SIZE(stGame.TBL_Effect); i++) {
		ST_Effect* effect = &stGame.TBL_Effect[i];
		if(!effect->mode) {
			memset(effect, 0, sizeof(ST_Effect));
			effect->mode	= mode;
			effect->type	= type;
			effect->x	= (X__CELL + (W__CELL * col)) << 6;
			effect->y	= (Y__CELL + (H__CELL * row)) << 6;
			switch(effect->mode) {
			default:DIE();
			case EFFECT_ERASE:
				{
					double r = RND32_RANGE(seed, 0, 8) * (M_PI * 2 / 8);
					double dSin = sin(r);
					double dCos = cos(r);
					effect->ax = dCos * (3<<2);
					effect->ay = dSin * (3<<2);
				}
				break;
			case EFFECT_GAMEOVER:
				{
					effect->vy = -9.0 * (3<<2);
					effect->ay =  0.9 * (3<<2);
					if(!(col & 1)) {
						effect->vx = 5.0 * (3<<2);
						if((col ^ row) & 1) {
							effect->vx = -effect->vx;
						}
					}
				}
				break;
			}
			return;	//܂ŁB
		}
	}
}
/****************************************************************************
 *	check_erase
 ****************************************************************************/
static int check_erase_subr1(int col, int row, int type, int dir) {
	ST_Cell* cell;
	if((unsigned)col >= FIELD_COLS) { return 0; }
	if((unsigned)row >= FIELD_ROWS) { return 0; }
	cell = &stGame.TBL_Field[row][col];
	if(cell->type != type) { return 0; }
	col += (dir == 0);
	row += (dir == 1);
	return check_erase_subr1(col, row, type, dir) + 1;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static void check_erase_subr2(int col, int row, int type, int dir) {
	ST_Cell* cell;
	if((unsigned)col >= FIELD_COLS) { return; }
	if((unsigned)row >= FIELD_ROWS) { return; }
	cell = &stGame.TBL_Field[row][col];
	if(cell->type != type) { return; }
	if(cell->erase &  (1<<dir)) { DIE(); }	//oO
	   cell->erase |= (1<<dir);
	col += (dir == 0);
	row += (dir == 1);
	check_erase_subr2(col, row, type, dir);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
void check_erase() {
	int col, row;
	//eZɂāc
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			ST_Cell* cell = &stGame.TBL_Field[row][col];
			//ZłȂ΁c
			if(cell->type) {
				int dir, len;
				//Əcɂāc
				for(dir = 0; dir <= 1; dir++) {
					//ɍ(͏㑤)̃Z̏łɊ܂܂ĂȂ΁c
					if(!(cell->erase & (1<<dir))) {
						//ނ̃ubN̕ѐ𐔂B
						len = check_erase_subr1(col, row, cell->type, dir);
						//3ȏłc
						if(len >= 3) {
							sound_play(3, sound_table[SND_SE_ERASE], 1);
							//łZɏŃtOZbgB
							check_erase_subr2(col, row, cell->type, dir);
							//XRA𑝂₷B
							UVAR_ADD(stGame.score, 10 * len);
							//nCXRAXVB
							if(stGame.score > hiscore) { hiscore = stGame.score; }
							//xAbvJE^𑝂₵āA񐔈ȏɂȂc
							if(++stGame.levUp >= LEVUP_CNT) {
								//xAbvJE^NAB
								stGame.levUp = 0;
								//ubN̗x𑁂B
								stGame.moveSpd *= MOVESPD_UPRATE;
							}
							//ł͂܂Ȃ悤ɒ!!
							//̃Z̕тɊ܂܂Ă\邩B
						}
					}
				}
			}
		}
	}
	//ŃtOZbgubNB
	for(row = 0; row < FIELD_ROWS; row++) {
		for(col = 0; col < FIELD_COLS; col++) {
			ST_Cell* cell = &stGame.TBL_Field[row][col];
			//ŃtOZbgĂc
			if(cell->erase) {
				//ŃGtFNg𐶐B
				effect_gen(EFFECT_ERASE, cell->type, col, row);
				//ZNAB
				memset(cell, 0, sizeof(ST_Cell));
			}
		}
	}
}
/****************************************************************************
 *	game_init
 ****************************************************************************/
int check_gameover() {
	//ŏiɃubNcĂQ[I[o[B
	int col;
	for(col = 0; col < FIELD_COLS; col++) {
		ST_Cell* cell = &stGame.TBL_Field[0][col];
		if(cell->type) { return 1; }
	}
	return 0;
}
/****************************************************************************
 *	game_init
 ****************************************************************************/
void game_init() {
	//\̂NAB
	memset(&stGame, 0, sizeof stGame);
	//ubN̎ސݒ肷B
	stGame.colors = clamp(colors_sel, 2, BLOCK_TYPE_MAX + 1);
	//xݒ肷B
	stGame.moveSpd = MOVE_SPD_INIT;
	//ŏNEXTubN𐶐B
	//̎_ł͂܂AubN͖ołB
	next_init();
}
/****************************************************************************
 *	game_exec
 ****************************************************************************/
void game_exec() {
	//NEXTubN
	{
		//NEXTubŃAQ[ԂɊ֌WAʏ㕔ōođҋ@ʒu܂ňړ铮sB
		//AQ[I[o[ɂȂȀuԂ̈ʒuŒ~ĈړȂB(̔fł܂)
		//Q[I[o[NEXTubN㉺]ĕ`̂ŁAړƕsRłB
		if(!stGame.TBL_Next[0] || !stGame.TBL_Next[1]) { DIE(); }	//oOB[0][1]L͂B
		if(stGame.stat != STAT_GAMEOVER) {	//Q[I[o[łȂ΁c
			if(stGame.nextPosX < X__NEXT) {	//ҋ@ʒuɓBĂȂ΁c
				//1/1̑xŉE֐iށB
				stGame.nextPosX++;
			}
		}
	}
	//ubN
	{
		//oȂ΁c
		if(stGame.stat == STAT_APPEAR) {
			if(!stGame.TBL_Move[0] || !stGame.TBL_Move[1]) { DIE(); }	//oOB[0][1]L͂B
			//ҋ@ʒuA2XẄʒu܂ŁA2/1̑xňړB
			if(stGame.movePosX < (X__CELL+W__CELL*2)) {
				stGame.movePosX += 2;
				if(stGame.movePosX > (X__CELL+W__CELL*2)) { stGame.movePosX = (X__CELL+W__CELL*2); }
			//2XWɓBc
			} else {
				//KiAj[VsB
				static const int TBL_y[]={
					-2, 0, 1, 3,
					 1, 3, 4, 6,
					 4, 6, 7, 9,
					 7, 9,10,12};
				if((unsigned)stGame.movePosYi >= ARRAY_SIZE(TBL_y)) { DIE(); }	//oOBstGame.movePosYiARRAY_SIZE(TBL_y)ɓBAnext_init()ɂstGame.movePosYi=0ɖ߂OɁAĂт̏֗鎖͖͂B
				stGame.movePosY = Y__NEXT + TBL_y[stGame.movePosYi];
				//Ki؂c
				if(++stGame.movePosYi >= ARRAY_SIZE(TBL_y)) {
					//쒆ֈڍsB
					stGame.stat = STAT_MOVE;
					stGame.moveWait = MOVE_WAIT;
					stGame.moveCol = 2;
					stGame.moveRow = 0;
					stGame.moveOfs = (Y__CELL - stGame.movePosY) << 8;
					if(stGame.moveOfs <= 0) { DIE(); }	//oOBKi؂ʒu̓tB[h̍ŏił͂B
				}
			}
		//쒆Ȃ΁c
		} else if(stGame.stat == STAT_MOVE) {
			//̉ς݂łȂ΁c
			if(stGame.TBL_Move[0]) {
				//tB[hłȂ΁c
				// - IWił͗߂ătB[h̍Eړ\Ȃ̂ǂ悭킩ȂB
				//   ϓIɂ́AtB[hɍEoĂ܂Ɨ̃ubN̉ɐ荞߂Ă܂ꂪL̂ŗǂȂƎv̂ŁAł̓tB[h͑sƂ鎖ɂB
				//   (Iɂ́AXAɐ荞߂悤ȏ͑g߂ȂƂ͎vc)
				if(!stGame.fieldFall ||
				   !stGame.moveRow) {	//AƂtB[hłAubNŏiȂ΍Eړ͉eȂ̂ŁAEړƂ鎖ɂB
					//{^̉gKȂ΁c
					if(joy & TRG_LF) {
						//ubN̍ɋ󂫂L΁c
						if((stGame.moveCol > 0) &&
						   !stGame.TBL_Field[stGame.moveRow][stGame.moveCol - 1].type) {
							//ֈړB
							stGame.moveCol--;
							sound_play(0, sound_table[SND_SE_IDOU], 1);
						}
					//E{^̉gKȂ΁c
					} else if(joy & TRG_RI) {
						//2ubN쒆Ȃ΁c
						if(stGame.TBL_Move[1]) {
							//EubN̉Eɋ󂫂L΁c
							if((stGame.moveCol < (FIELD_COLS - 2)) &&
							   !stGame.TBL_Field[stGame.moveRow][stGame.moveCol + 2].type) {
								//EֈړB
								stGame.moveCol++;
								sound_play(0, sound_table[SND_SE_IDOU], 1);
							}
						//1ubN쒆Ȃ΁c
						} else {
							//ubN̉Eɋ󂫂L΁c
							if((stGame.moveCol < (FIELD_COLS - 1)) &&
							   !stGame.TBL_Field[stGame.moveRow][stGame.moveCol + 1].type) {
								//EֈړB
								stGame.moveCol++;
								sound_play(0, sound_table[SND_SE_IDOU], 1);
							}
						}
					}
				}
				//Jn܂ł̃EFCgcĂc
				if(stGame.moveWait) {
					//EFCg炷B
					stGame.moveWait--;
				#if 0
					//{^̉gKȂ΁AEFCgNAB
					if(joy & TRG_DN) { stGame.moveWait = 0; }
				#else//~X邽߂ɏ̂悤ɂĂ̂AςȂői߂ɕsւȂ̂ŁÂ悤ɕύX鎖ɂB
					//{^ĂAEFCgNAB
					if(joy & PAD_DN) { stGame.moveWait = 0; }
				#endif
					//EFCgȂuԂɗ炷B
					if(!stGame.moveWait) {
						sound_play(1, sound_table[SND_SE_RAKKA], 1);
					}
				//Jn܂ł̃EFCgcĂȂ΁c
				} else {
					//ubN̍sItZbg炷B
					stGame.moveOfs -= (joy & PAD_DN) ? max((int)stGame.moveSpd, (int)(H__CELL<<8))	//{^Ă獂B
					                                 :     (int)stGame.moveSpd;
					//sItZbgȂc(stGame.moveOfs==0ꍇ}CiXɂȂ̂ł̏Ɋ܂)
					while(stGame.moveOfs <= 0) {	//(stGame.moveSpd>H__CELL)łΉo悤ifł͂ȂwhileɂB
						//],,Ȃ΁A炪̂҂B
						// - ۂɂ́A]҂͍ŏiłNȂ͂łB
						//   ́AЕ̃ubNɐڒnꍇɁAǂ̍słN蓾܂B
						if(stGame.fieldRot || stGame.fieldFall) {
							//݂̍sōsItZbg0ێB
							stGame.moveOfs = 0;
							//[v𔲂B
							break;
						//]łłȂ΁c
						} else {
							int bLeft = 0, bRight = 0;
							//EubN̐ڒnsB
							if(stGame.moveRow < (FIELD_ROWS - 1)) {	//ŉiłȂ΁c
								if(                      stGame.TBL_Field[stGame.moveRow + 1][stGame.moveCol + 0].type) { bLeft  = 1; }	//ubN̐ڒn
								if(stGame.TBL_Move[1] && stGame.TBL_Field[stGame.moveRow + 1][stGame.moveCol + 1].type) { bRight = 1; }	//EubN(L)̐ڒn
							} else {	//ŉiȂ΁c
								                         bLeft  = 1;	//ubN̐ڒn
								if(stGame.TBL_Move[1]) { bRight = 1; }	//EubN(L)̐ڒn
							}
							//EubN̏ȂƂڒnĂc
							if(bLeft || bRight) {
								sound_play(2, sound_table[SND_SE_SETTI], 1);
								//EubNڒnĂc
								if(bRight) {
									//EubN̉B
									ST_Cell* cell = &stGame.TBL_Field[stGame.moveRow][stGame.moveCol + 1];
									memset(cell, 0, sizeof(ST_Cell));
									cell->type = stGame.TBL_Move[1];
									stGame.TBL_Move[1] = 0;
								}
								//̏tɂȂ悤ɒӂB
								//ubNڒnĂc
								if(bLeft) {
									//ubN̉B
									ST_Cell* cell = &stGame.TBL_Field[stGame.moveRow][stGame.moveCol + 0];
									memset(cell, 0, sizeof(ST_Cell));
									cell->type = stGame.TBL_Move[0];
									stGame.TBL_Move[0] = 0;
									//EubNcĂc
									if(stGame.TBL_Move[1]) {
										//EubNubNֈڂB
										stGame.TBL_Move[0] = stGame.TBL_Move[1];
										stGame.TBL_Move[1] = 0;
										if(stGame.moveCol > (FIELD_COLS - 2)) { DIE(); }	//oO
										stGame.moveCol++;
									}
								}
								//̃ubNڒnuԂɗB
								if(!stGame.TBL_Move[0]) {
									sound_stop(1);
								}
								//tB[h̏łB
								check_erase();
								//ł(mȂ)ɂāAēxAtB[h̗JnB(L)
								// - ŁˑƂdlłB(IWiłł)
								check_fall();
								//݂̍sōsItZbg0ێB
								stGame.moveOfs = 0;
								//[v𔲂B
								break;
							//EubN̂ǂڒnĂȂ΁c
							} else {
								//ֈړB
								stGame.moveRow++;
								stGame.moveOfs += (H__CELL<<8);
							}
						}
					}
				}
			}
		}
	}
	//tB[h
	{
		//o,,ړōŏiŃItZbgcĂ΁c
		if((stGame.stat == STAT_APPEAR) ||
		  ((stGame.stat == STAT_MOVE) && !stGame.moveRow && stGame.moveOfs)) {
			//ɉ]łȂAtB[hłȂ΁c
			if(!stGame.fieldRot && !stGame.fieldFall) {
				//A{^̉gKȂ΁c
				if(joy & TRG_A) {
					sound_play(2, sound_table[SND_SE_KAITEN], 1);
					//E]JnB
					stGame.fieldRot = -16;
					field_rot_r();
				//B{^̉gKȂ΁c
				} else if(joy & TRG_B) {
					sound_play(2, sound_table[SND_SE_KAITEN], 1);
					//]JnB
					stGame.fieldRot =  16;
					field_rot_l();
				}
			}
		}
		//]Ȃ΁c
		if(stGame.fieldRot) {
			//c]px炷B
			if(stGame.fieldRot < 0) { stGame.fieldRot++; }
			if(stGame.fieldRot > 0) { stGame.fieldRot--; }
			//݂90x̉]c
			if(!stGame.fieldRot) {
				//o,,ړōŏiŃItZbgcĂ΁c
				if((stGame.stat == STAT_APPEAR) ||
				  ((stGame.stat == STAT_MOVE) && !stGame.moveRow && stGame.moveOfs)) {
					//A{^ꑱĂc
					if(joy & PAD_A) {
						//tB[h̗Jn(dv!!BIWiłłdlłB)AE]JnB
						stGame.fieldRot = -16;
						field_rot_r();
					//B{^ꑱĂc
					} else if(joy & PAD_B) {
						//tB[h̗Jn(dv!!BIWiłłdlłB)A]JnB
						stGame.fieldRot =  16;
						field_rot_l();
					}
				}
				//Vȉ]JnĂȂ΁c
				if(!stGame.fieldRot) {
					//tB[h̗JnB(L)
					check_fall();
					//tB[h̗JnȂ΁c
					if(!stGame.fieldFall) {
						//tB[h̏łB
						check_erase();
						//ł(mȂ)ɂāAēxAtB[h̗JnB(L)
						// - ŁˑƂdlłB(IWiłł)
						check_fall();
					}
				}
			}
		}
		//Ȃ΁c
		if(stGame.fieldFall) {
			stGame.fieldFall -= FALL_SPEED;
			if(!stGame.fieldFall) {
				check_fall();
				if(!stGame.fieldFall) {
					//tB[h̏łB
					check_erase();
					//ł(mȂ)ɂāAēxAtB[h̗JnB(L)
					// - ŁˑƂdlłB(IWiłł)
					check_fall();
				}
			}
		}
	}
	//GtFNg
	{
		int i;
		for(i = 0; i < ARRAY_SIZE(stGame.TBL_Effect); i++) {
			ST_Effect* effect = &stGame.TBL_Effect[i];
			if(effect->mode) {
				switch(effect->mode) {
				default:DIE();
				case EFFECT_ERASE:
					UVAR_INC(effect->anmCnt);
					effect->vx += effect->ax;
					effect->vy += effect->ay;
					effect->x  += effect->vx;
					effect->y  += effect->vy;
					if((effect->x < (0<<6)) || (effect->x >= (DISP_X<<6)) ||
					   (effect->y < (0<<6)) || (effect->y >= (DISP_Y<<6))) {
						memset(effect, 0, sizeof(ST_Effect));
					}
					break;
				case EFFECT_GAMEOVER:
					effect->vx += effect->ax;
					effect->vy += effect->ay;
					effect->x  += effect->vx;
					effect->y  += effect->vy;
					if((effect->x < (0<<6)) ||   (effect->x >= (DISP_X<<6)) ||
					 /*(effect->y < (0<<6)) ||*/ (effect->y >= (DISP_Y<<6))) {
						memset(effect, 0, sizeof(ST_Effect));
					}
					break;
				}
			}
		}
	}
}
/****************************************************************************
 *	score_draw
 ****************************************************************************/
void score_draw() {
	int iPri, x, y;
	//1P
	iPri	= PRI__TEXT;
	x	=   X__TEXT__1P;
	y	=   Y__TEXT__1P;
	CbkQue_render_printf(pCbkQue,
		iPri,
		&render,
		x,
		y,
		2,
		0,
		"%5d", stGame.score);
	//HI
	iPri	= PRI__TEXT;
	x	=   X__TEXT__HI;
	y	=   Y__TEXT__HI;
	CbkQue_render_printf(pCbkQue,
		iPri,
		&render,
		x,
		y,
		2,
		0,
		"%5d", hiscore);
}
/****************************************************************************
 *	game_draw
 ****************************************************************************/
void game_draw() {
	int iPri, x, y, iSprNo, iParam;
	//wi
	{
		iPri	= PRI__BG;
		x	= 0;
		y	= 0;
		iSprNo	= SPR_BG;
		iParam	= DRW_NOMAL;
		CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
	}
	//NEXTubN
	{
		int i;
		for(i = 0; i < 2; i++) {
			iPri	= PRI__NEXT;
			x	= stGame.nextPosX + (W__CELL * i);
			y	= Y__NEXT;
			iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (stGame.TBL_Next[i] - 1));
			iParam	= DRW_NOMAL;
			if(stGame.stat == STAT_GAMEOVER) {
				iParam = DRW_REVY;	//Q[I[o[NEXTubN㉺]ĕ`B180x]ł͂ȂɒӂB
			} else if(stGame.nextPosX != X__NEXT) {
				if(now & 2) { y--; }	//Ă銴o߂ɏ㉺ɗh炷B
			}
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		}
	}
	if(stGame.stat != STAT_GAMEOVER) {	//Q[I[o[͑ubN,tB[hubN,,g͊G`ȂB
		//ubN
		{
			int i;
			if(stGame.stat == STAT_APPEAR) {
				for(i = 0; i < 2; i++) {
					iPri	= PRI__MOVE;
					x	= stGame.movePosX + (W__CELL * i);
					y	= stGame.movePosY;
					iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (stGame.TBL_Move[i] - 1));
					iParam	= DRW_NOMAL;
					if(stGame.movePosX != (X__CELL+W__CELL*2)) {
						if(now & 2) { y--; }	//Ă銴o߂ɏ㉺ɗh炷B
					}
					CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
				}
			} else if(stGame.stat == STAT_MOVE) {
				for(i = 0; i < 2; i++) {
					if(stGame.TBL_Move[i]) {
						iPri	= PRI__MOVE;
						x	= X__CELL + (W__CELL * (stGame.moveCol + i));
						y	= Y__CELL + (H__CELL *  stGame.moveRow     );
						iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (stGame.TBL_Move[i] - 1));
						iParam	= DRW_NOMAL;
						y -= (stGame.moveOfs + 255) >> 8;
						if(stGame.moveOfs) {
							if(now & 2) { iSprNo += (32 * 1); }	//̓W^o^B
						}
						CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
					}
				}
				//Jn܂ł̃EFCgcĂA[^[`ƂɂB(IWiłɂ͖AƎvfłB)
				if(stGame.moveWait) {
					iPri	= PRI__MOVE;
					x	= X__CELL + (W__CELL * stGame.moveCol);
					y	= Y__CELL + (H__CELL * stGame.moveRow);
					y -= (stGame.moveOfs + 255) >> 8;
					x -= (W__CELL / 2);
					y += (H__CELL / 2) + 2;
					CbkQue_render_rectangle(pCbkQue, iPri, &render, x, y,
						W__CELL * 2 + 1,
						4, 3);
					CbkQue_render_rectangle_fill(pCbkQue, iPri, &render, x + 1, y + 1,
						(W__CELL * 2 - 1),
						2, 2);
					CbkQue_render_rectangle_fill(pCbkQue, iPri, &render, x + 1, y + 1,
						(W__CELL * 2 - 1) * stGame.moveWait / MOVE_WAIT,
						2, 0);
				}
			}
		}
		//tB[h
		{
			int col, row;
			int r = stGame.fieldRot & 62/*63*/;	//g̐xɍ킹邽߂63ł͂Ȃ62ƂB
			double dSin = 0.0, dCos = 0.0;	//x}
			if(r) {
				double d = (M_PI / 32) * r;
				dSin = sin(d);
				dCos = cos(d);
			}
			for(row = 0; row < FIELD_ROWS; row++) {
				for(col = 0; col < FIELD_COLS; col++) {
					ST_Cell* cell = &stGame.TBL_Field[row][col];
					if(cell->type) {
						iPri	= PRI__CELL;
						x	= X__CELL + (W__CELL * col);
						y	= Y__CELL + (H__CELL * row);
						iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (cell->type - 1));
						iParam	= DRW_NOMAL;
						if(cell->fall) { y -= stGame.fieldFall; }
						if(r) {
							int dx = x - X__BORDER;
							int dy = y - Y__BORDER;
							x = (int)(dx * dCos - dy * dSin) + X__BORDER;
							y = (int)(dx * dSin + dy * dCos) + Y__BORDER;
						}
						iSprNo += ((cell->rot << 3) + (stGame.fieldRot >> 1)) & 31;
						CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
					}
				}
			}
		}
		//
		{
			//
			iPri	= PRI__GEAR;
			x	= X__GEAR__L;
			y	= Y__GEAR__L;
			iSprNo	= SPR_GEAR_0;
			iParam	= DRW_NOMAL;
			iSprNo += (-stGame.fieldRot & 7);
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
			//E
			iPri	= PRI__GEAR;
			x	= X__GEAR__R;
			y	= Y__GEAR__R;
			iSprNo	= SPR_GEAR_0;
			iParam	= DRW_NOMAL;
			iSprNo += (-stGame.fieldRot & 7);
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		}
		//g
		{
			iPri	= PRI__BORDER;
			x	= X__BORDER;
			y	= Y__BORDER;
			iSprNo	= SPR_BORDER_0;
			iParam	= DRW_NOMAL;
			iSprNo += ((stGame.fieldRot >> 1) & 7);
			CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
		}
	}
	//GtFNg
	{
		int i;
		for(i = 0; i < ARRAY_SIZE(stGame.TBL_Effect); i++) {
			ST_Effect* effect = &stGame.TBL_Effect[i];
			if(effect->mode) {
				switch(effect->mode) {
				default:DIE();
				case EFFECT_ERASE:
					iPri	= PRI__EFFECT;
					x	= effect->x >> 6;
					y	= effect->y >> 6;
					iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (effect->type - 1));
					iParam	= DRW_NOMAL;
					iSprNo += (32 * 2) + min((effect->anmCnt / 4), 7);	//g
					CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
					break;
				case EFFECT_GAMEOVER:
					iPri	= PRI__EFFECT;
					x	= effect->x >> 6;
					y	= effect->y >> 6;
					iSprNo	= SPR_BLOCK_1_0_0 + (((32 * 2) + 8) * (effect->type - 1));
					iParam	= DRW_NOMAL;
					CbkQue_sprite_draw(pCbkQue, iPri, x, y, iSprNo, iParam);
					break;
				}
			}
		}
	}
	//XRA;
	score_draw();
}
/****************************************************************************
 *	game_run
 ****************************************************************************/
void game_run() {
	int i;
	//
	game_init();
	//--- STAT_READY ---
//sv	stGame.stat = STAT_READY;
	i = 0;
	do {
		schedule();
		game_draw();
		game_exec();
		if(i++ < SEC(0.5)) {
			CbkQue_render_printf_framed(pCbkQue,
				PRI__TEXT,
				&render,
				(DISP_X / 2) - 10,
				(DISP_Y / 2) - 26,
				2,
				0x003,
				"READY");
		} else {
			CbkQue_render_printf_framed(pCbkQue,
				PRI__TEXT,
				&render,
				(DISP_X / 2) - 4,
				(DISP_Y / 2) - 26,
				2,
				0x003,
				"GO");
		}
	} while(stGame.nextPosX < X__NEXT);
	//BGMJn
	PlayMusic(MAIN_BGM);
	for(;;) {
		//--- STAT_APPEAR ---
		stGame.stat = STAT_APPEAR;
		next_init();
		do {
			schedule();
			game_draw();
			game_exec();
		} while(stGame.stat != STAT_MOVE);	//쒆ɂȂ甲B
		//--- STAT_MOVE ---
//sv		stGame.stat = STAT_MOVE;
		do {
			schedule();
			game_draw();
			game_exec();
		} while(stGame.TBL_Move[0] || stGame.fieldFall);	//̉ς,,tB[hłȂΔB
		//Q[I[o[
		if(check_gameover()) { break; }
	}
	//--- STAT_GAMEOVER ---
	stGame.stat = STAT_GAMEOVER;
	//Q[I[o[GtFNg𐶐B
	{
		int col, row;
		memset(stGame.TBL_Effect, 0, sizeof stGame.TBL_Effect);	//Q[I[o[̒Oɏł\L邪AĥŏŃGtFNg͏ɂB
		for(row = 0; row < FIELD_ROWS; row++) {
			for(col = 0; col < FIELD_COLS; col++) {
				ST_Cell* cell = &stGame.TBL_Field[row][col];
				if(cell->type) {
					effect_gen(EFFECT_GAMEOVER, cell->type, col, row);
					memset(cell, 0, sizeof(ST_Cell));
				}
			}
		}
		StopMusic();
		sound_stop(0);
		sound_stop(1);
		sound_stop(2);
		sound_play(3, sound_table[SND_SE_GOVER], 1);
	}
	{
		int i;
		for(i = 0; i < SEC(5); i++) {
			schedule();
			game_draw();
			game_exec();
			if(i >= SEC(1)) {
				CbkQue_render_printf_framed(pCbkQue,
					PRI__TEXT,
					&render,
					(DISP_X / 2) - 16,
					(DISP_Y / 2) - 3,
					2,
					0x003,
					"GAMEOVER");
				if(joy & TRG_AB) { break; }	//LZ
			}
		}
	}
}
/****************************************************************************
 *	
 ****************************************************************************/
void demo_run() {
	int iStart = 0;
	StopMusic();	//BGMmɒ~BQ[SELECT{^Ŕꍇ̂߂łB
	sound_stop(0);
	sound_stop(1);
	sound_stop(2);
	sound_stop(3);
	for(;;) {
		schedule();
		//wiEXRA
		{
			CbkQue_sprite_draw(pCbkQue, 0, 0, 0, SPR_BG, DRW_NOMAL);
			CbkQue_render_rectangle_fill(pCbkQue, 0, &render, 0, 10, DISP_X, DISP_Y - 10, 2);
			score_draw();
		}
		//^Cg
		{
			CbkQue_sprite_draw(pCbkQue,
				0,
				(DISP_X-76)/2,
				(DISP_Y-40)/2-18,
				SPR_TITLE,
				DRW_NOMAL);
			CbkQue_render_printf_framed(pCbkQue,
				0,
				&render,
				(DISP_X-76)/2+64,
				(DISP_Y-40)/2-8,
				2,
				0x330,
				"ķ");
			CbkQue_render_printf_framed(pCbkQue,
				0,
				&render,
				(DISP_X-76)/2+64+5,
				(DISP_Y-40)/2-8-2,
				2,
				0x330,
				"");
		}
		//ubN̎ސI
		{
			if(!iStart) {	//A,,B{^OȂ΁c
				if((colors_sel >              2) && (joy & TRG_LF)) {
					colors_sel--;
					sound_play(0, sound_table[SND_SE_IDOU], 1);
				}
				if((colors_sel < BLOCK_TYPE_MAX) && (joy & TRG_RI)) {
					colors_sel++;
					sound_play(0, sound_table[SND_SE_IDOU], 1);
				}
			}
			CbkQue_render_printf_framed(pCbkQue,
				0,
				&render,
				(DISP_X-(4*18))/2,
				DISP_Y-46,
				2,
				0x330,
				"%c BLOCK TYPES %2d %c",
				(colors_sel >              2) ? '<' : ' ',
				colors_sel,
				(colors_sel < BLOCK_TYPE_MAX) ? '>' : ' ');
		}
		//vvg
		if(!iStart) {	//A,,B{^OȂ΁c
			if((now % SEC(1.0)) < SEC(0.5)) {
				CbkQue_render_printf_framed(pCbkQue,
					0,
					&render,
					(DISP_X-(4*14))/2,
					 DISP_Y-23,
					2,
					0x330,
					"PRESS A BUTTON");
			}
			if(joy & TRG_AB) {
				sound_play(0, sound_table[SND_SE_START], 1);
				iStart = 1;
			}
		} else {	//A,,B{^Ȃ΁c
			if((now % SEC(0.2)) < SEC(0.1)) {
				CbkQue_render_printf_framed(pCbkQue,
					0,
					&render,
					(DISP_X-(4*5))/2,
					 DISP_Y-23,
					2,
					0x330,
					"START");
			}
			if(++iStart >= SEC(1.0)) { break; }
		}
	}
}
/****************************************************************************
 *	app_main
 ****************************************************************************/
int app_main(int argc, char* argv[]) {
//{{BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	delay(1);
	if(joy & PAD_B) {
		pceWaveSetMasterAtt(0);
		pcePowerSetReport(PWR_RPTOFF);
	}
//}}BR}hBBȂNƓdr\BfobOɓdr\₷悤ɂ邽߂łB
	colors_sel = 4;
	sound_att(1, 4);	//TEh`l1͗pƂB傫̂ŏB	0=쉹,1=,2=ڒn/],3=ŉ/Q[I[o[
	for(;;) {
		SEH_use_shared;
		SEH_try_shared {
			demo_run();
		} SEH_catch(MAKEFOURCC('T','R','G','D')) {
			break;
		} SEH_end
		SEH_try_shared {
			game_run();
		} SEH_catch(MAKEFOURCC('T','R','G','D')) {
			/** no job **/
		} SEH_end
		//TODO:TEh~
	}
	return 0;
}
