//
//	clipmisc.cs
//
//	エラー処理、その他いろいろです。
//
//	CLiP - Common Library for P/ECE
//	Copyright (C) 2017 Naoyuki Sawa
//
//	* Sun Mar 19 22:19:43 JST 2017 Naoyuki Sawa
//	- 1st リリース。
//	  一先ず「Direct3D互換のD3DCOLOR形式マクロ」だけを実装しました。
//	  clipsprf.csモジュールにおいて必要だからです。
//	* Tue Mar 21 21:23:37 JST 2017 Naoyuki Sawa
//	- D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
//	  詳細は、clipmisc.hの同日のコメントを参照して下さい。
//	* Mon Apr 03 23:36:16 JST 2017 Naoyuki Sawa
//	- 「変数の最大値,又は,最小値へ飽和する飽和加減算マクロ」を追加しました。
//	  C言語版(/clip/clipmisc.h)の、同名のマクロをC#に移植したものです。
//	  尚、C言語版では、「変数の符号無し最大値,符号付き最大値,又は,最小値を求めるマクロ」も定義していましたが、C#版にはそれは定義していません。
//	  C#では変数に対してsizeofが使えないため、C言語版と同じ方法で変数の符号無し最大値,符号付き最大値,又は,最小値を求める事が出来ないからです。
//	* Fri Apr 07 21:20:19 JST 2017 Naoyuki Sawa
//	- 「汎用マクロ・関数」を実装しました。
//	  clipmisc.hで定義されている、既存の同名のマクロと同じ機能です。
//	  ただし、いくつか、C#では実装出来ないものは、未実装としました。
//	* Mon Apr 10 21:37:40 JST 2017 Naoyuki Sawa
//	- UnityEngine.Color32⇔D3DCOLOR相互変換ユーティリティを追加しました。
//
using System;
using System.Threading;
namespace org.piece_me {
	public static partial class libclip {
		//*****************************************************************************
		//	汎用マクロ・関数
		//*****************************************************************************
		private static object __cs__ = new object();
		public static void ENTER_CS() { Monitor.Enter(__cs__); }
		public static void LEAVE_CS() { Monitor.Exit( __cs__); }
		//-----------------------------------------------------------------------------
		public static bool BTST(VoidPtr p, int i) { BytePtr q = p; return (q[i / 8] &         (1 << (i & 7))) != 0; }
		public static void BCLR(VoidPtr p, int i) { BytePtr q = p;         q[i / 8] &= (byte)~(1 << (i & 7))      ; }	//「((BytePtr)p)[i / 8] &= ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		public static void BSET(VoidPtr p, int i) { BytePtr q = p;         q[i / 8] |= (byte) (1 << (i & 7))      ; }	//「((BytePtr)p)[i / 8] |= ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		public static void BNOT(VoidPtr p, int i) { BytePtr q = p;         q[i / 8] ^= (byte) (1 << (i & 7))      ; }	//「((BytePtr)p)[i / 8] ^= ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		//-----------------------------------------------------------------------------
		public static int SWAPH(int x) { return (((byte)(x >>  0)) <<  8) |
		                                        (((byte)(x >>  8)) <<  0); }
		public static int SWAPW(int x) { return (((byte)(x >>  0)) << 24) |
		                                        (((byte)(x >>  8)) << 16) |
		                                        (((byte)(x >> 16)) <<  8) |
		                                        (((byte)(x >> 24)) <<  0); }
		//-----------------------------------------------------------------------------
		public static void XCHG<T>(ref T x, ref T y) { T __x__ = x; x = y; y = __x__; }
		//-----------------------------------------------------------------------------
		public static int LEBYTE(VoidPtr p) { return GET_LEBYTE(p); }
		public static int LEHALF(VoidPtr p) { return GET_LEHALF(p); }
		public static int LEWORD(VoidPtr p) { return GET_LEWORD(p); }
		public static int BEBYTE(VoidPtr p) { return GET_BEBYTE(p); }
		public static int BEHALF(VoidPtr p) { return GET_BEHALF(p); }
		public static int BEWORD(VoidPtr p) { return GET_BEWORD(p); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static int GET_LEBYTE(VoidPtr p) { return      ((BytePtr  )p)[0]; }
		public static int GET_LEHALF(VoidPtr p) { return      ((UInt16Ptr)p)[0]; }
		public static int GET_LEWORD(VoidPtr p) { return (int)((UInt32Ptr)p)[0]; }
		public static int GET_BEBYTE(VoidPtr p) { return            GET_LEBYTE(p) ; }
		public static int GET_BEHALF(VoidPtr p) { return SWAPH(     GET_LEHALF(p)); }
		public static int GET_BEWORD(VoidPtr p) { return SWAPW((int)GET_LEWORD(p)); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void PUT_LEBYTE(VoidPtr p, int x) { BytePtr   q = p; q[0] = (byte  )x; }	//「((BytePtr  )p)[0] = ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		public static void PUT_LEHALF(VoidPtr p, int x) { UInt16Ptr q = p; q[0] = (ushort)x; }	//「((UInt16Ptr)p)[0] = ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		public static void PUT_LEWORD(VoidPtr p, int x) { UInt32Ptr q = p; q[0] = (uint  )x; }	//「((UInt32Ptr)p)[0] = ～」と書くと、「エラー CS0131 代入式の左辺には変数、プロパティ、またはインデクサーを指定してください。」というエラーになりました。C言語では出来ますが、C#ではダメみたいです。
		public static void PUT_BEBYTE(VoidPtr p, int x) { PUT_LEBYTE(p,       x ); }
		public static void PUT_BEHALF(VoidPtr p, int x) { PUT_LEHALF(p, SWAPH(x)); }
		public static void PUT_BEWORD(VoidPtr p, int x) { PUT_LEWORD(p, SWAPW(x)); }
		//-----------------------------------------------------------------------------
		public static int HIBYTE(int x) { return (byte  )(x >>  8); }
		public static int LOBYTE(int x) { return (byte  )(x >>  0); }
		public static int HIHALF(int x) { return (ushort)(x >> 16); }
		public static int LOHALF(int x) { return (ushort)(x >>  0); }
		//-----------------------------------------------------------------------------
		public static int UPDOWN_MOTION(int i, int n) { return Math.Abs(((i + (n - 2)) % ((n - 1) * 2)) - (n - 2)); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static double FastCurv(int x, int y) { return       Math.Sin(((Math.PI / 2) / y) * x); }
		public static double SlowCurv(int x, int y) { return 1.0 - Math.Cos(((Math.PI / 2) / y) * x); }
		//-----------------------------------------------------------------------------
		public static T min<T>(T x, T y) where T : IComparable { return x.CompareTo(y) <= 0 ? x : y; }
		public static T max<T>(T x, T y) where T : IComparable { return x.CompareTo(y) >= 0 ? x : y; }
		public static T clamp<T>(T val, T lo, T hi) where T : IComparable { return min(max(val, lo), hi); }
		//-----------------------------------------------------------------------------
		public static int  BIT1_LOWEST_POSITION(  int x) { return x & -x; }
		public static int  BIT1_SHIFT_TO_LSB(     int x) { return (x != 0) ? (int)((uint)x / (uint)BIT1_LOWEST_POSITION(x)) : x; }
		public static bool BIT1_CONTINUATION_TEST(int x) { return (BIT1_SHIFT_TO_LSB(x) & (BIT1_SHIFT_TO_LSB(x) + 1)) == 0; }
		public static int  BIT0_LOWEST_POSITION(  int x) { return  BIT1_LOWEST_POSITION(  ~x); }
		public static int  BIT0_SHIFT_TO_LSB(     int x) { return ~BIT1_SHIFT_TO_LSB(     ~x); }
		public static bool BIT0_CONTINUATION_TEST(int x) { return  BIT1_CONTINUATION_TEST(~x); }
		//*****************************************************************************
		//	変数の最大値,又は,最小値へ飽和する飽和加減算マクロ
		//*****************************************************************************
		//符号付き飽和加算。x=被加算変数(符号付き),y=加算値(符号無し)
		public static void  VAR_ADD(ref   byte x, uint y) { x = ((uint)( sbyte.MaxValue - x) >= y) ? (  byte)(x + y) : unchecked((  byte) sbyte.MaxValue); }
		public static void  VAR_ADD(ref  sbyte x, uint y) { x = ((uint)( sbyte.MaxValue - x) >= y) ? ( sbyte)(x + y) : unchecked(( sbyte) sbyte.MaxValue); }
		public static void  VAR_ADD(ref  short x, uint y) { x = ((uint)( short.MaxValue - x) >= y) ? ( short)(x + y) : unchecked(( short) short.MaxValue); }
		public static void  VAR_ADD(ref ushort x, uint y) { x = ((uint)( short.MaxValue - x) >= y) ? (ushort)(x + y) : unchecked((ushort) short.MaxValue); }
		public static void  VAR_ADD(ref    int x, uint y) { x = ((uint)(   int.MaxValue - x) >= y) ? (   int)(x + y) : unchecked((   int)   int.MaxValue); }
		public static void  VAR_ADD(ref   uint x, uint y) { x = ((uint)(   int.MaxValue - x) >= y) ? (  uint)(x + y) : unchecked((  uint)   int.MaxValue); }
		public static void  VAR_ADD(ref   byte x,  int y) {  VAR_ADD(ref x, (uint)y); }
		public static void  VAR_ADD(ref  sbyte x,  int y) {  VAR_ADD(ref x, (uint)y); }
		public static void  VAR_ADD(ref  short x,  int y) {  VAR_ADD(ref x, (uint)y); }
		public static void  VAR_ADD(ref ushort x,  int y) {  VAR_ADD(ref x, (uint)y); }
		public static void  VAR_ADD(ref    int x,  int y) {  VAR_ADD(ref x, (uint)y); }
		public static void  VAR_ADD(ref   uint x,  int y) {  VAR_ADD(ref x, (uint)y); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//符号無し飽和減算。x=被減算変数(符号無し),y=減算値(符号無し)
		public static void UVAR_ADD(ref   byte x, uint y) { x = ((uint)(  byte.MaxValue - x) >= y) ? (  byte)(x + y) : unchecked((  byte)  byte.MaxValue); }
		public static void UVAR_ADD(ref  sbyte x, uint y) { x = ((uint)(  byte.MaxValue - x) >= y) ? ( sbyte)(x + y) : unchecked(( sbyte)  byte.MaxValue); }
		public static void UVAR_ADD(ref  short x, uint y) { x = ((uint)(ushort.MaxValue - x) >= y) ? ( short)(x + y) : unchecked(( short)ushort.MaxValue); }
		public static void UVAR_ADD(ref ushort x, uint y) { x = ((uint)(ushort.MaxValue - x) >= y) ? (ushort)(x + y) : unchecked((ushort)ushort.MaxValue); }
		public static void UVAR_ADD(ref    int x, uint y) { x = ((uint)(  uint.MaxValue - x) >= y) ? (   int)(x + y) : unchecked((   int)  uint.MaxValue); }
		public static void UVAR_ADD(ref   uint x, uint y) { x = ((uint)(  uint.MaxValue - x) >= y) ? (  uint)(x + y) : unchecked((  uint)  uint.MaxValue); }
		public static void UVAR_ADD(ref   byte x,  int y) { UVAR_ADD(ref x, (uint)y); }
		public static void UVAR_ADD(ref  sbyte x,  int y) { UVAR_ADD(ref x, (uint)y); }
		public static void UVAR_ADD(ref  short x,  int y) { UVAR_ADD(ref x, (uint)y); }
		public static void UVAR_ADD(ref ushort x,  int y) { UVAR_ADD(ref x, (uint)y); }
		public static void UVAR_ADD(ref    int x,  int y) { UVAR_ADD(ref x, (uint)y); }
		public static void UVAR_ADD(ref   uint x,  int y) { UVAR_ADD(ref x, (uint)y); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//符号付きか符号無しかを自動的に判定するバージョン
		public static void GVAR_ADD(ref   byte x, uint y) { UVAR_ADD(ref x, y); }	//符号無し
		public static void GVAR_ADD(ref  sbyte x, uint y) {  VAR_ADD(ref x, y); }	//符号付き
		public static void GVAR_ADD(ref  short x, uint y) {  VAR_ADD(ref x, y); }	//符号付き
		public static void GVAR_ADD(ref ushort x, uint y) { UVAR_ADD(ref x, y); }	//符号無し
		public static void GVAR_ADD(ref    int x, uint y) {  VAR_ADD(ref x, y); }	//符号付き
		public static void GVAR_ADD(ref   uint x, uint y) { UVAR_ADD(ref x, y); }	//符号無し
		public static void GVAR_ADD(ref   byte x,  int y) { GVAR_ADD(ref x, (uint)y); }
		public static void GVAR_ADD(ref  sbyte x,  int y) { GVAR_ADD(ref x, (uint)y); }
		public static void GVAR_ADD(ref  short x,  int y) { GVAR_ADD(ref x, (uint)y); }
		public static void GVAR_ADD(ref ushort x,  int y) { GVAR_ADD(ref x, (uint)y); }
		public static void GVAR_ADD(ref    int x,  int y) { GVAR_ADD(ref x, (uint)y); }
		public static void GVAR_ADD(ref   uint x,  int y) { GVAR_ADD(ref x, (uint)y); }
		//-----------------------------------------------------------------------------
		//符号付き飽和加算。x=被加算変数(符号付き),y=加算値(符号無し)
		public static void  VAR_SUB(ref   byte x, uint y) { x = ((uint)(x -  sbyte.MinValue) >= y) ? (  byte)(x - y) : unchecked((  byte) sbyte.MinValue); }
		public static void  VAR_SUB(ref  sbyte x, uint y) { x = ((uint)(x -  sbyte.MinValue) >= y) ? ( sbyte)(x - y) : unchecked(( sbyte) sbyte.MinValue); }
		public static void  VAR_SUB(ref  short x, uint y) { x = ((uint)(x -  short.MinValue) >= y) ? ( short)(x - y) : unchecked(( short) short.MinValue); }
		public static void  VAR_SUB(ref ushort x, uint y) { x = ((uint)(x -  short.MinValue) >= y) ? (ushort)(x - y) : unchecked((ushort) short.MinValue); }
		public static void  VAR_SUB(ref    int x, uint y) { x = ((uint)(x -    int.MinValue) >= y) ? (   int)(x - y) : unchecked((   int)   int.MinValue); }
		public static void  VAR_SUB(ref   uint x, uint y) { x = ((uint)(x -    int.MinValue) >= y) ? (  uint)(x - y) : unchecked((  uint)   int.MinValue); }
		public static void  VAR_SUB(ref   byte x,  int y) {  VAR_SUB(ref x, (uint)y); }
		public static void  VAR_SUB(ref  sbyte x,  int y) {  VAR_SUB(ref x, (uint)y); }
		public static void  VAR_SUB(ref  short x,  int y) {  VAR_SUB(ref x, (uint)y); }
		public static void  VAR_SUB(ref ushort x,  int y) {  VAR_SUB(ref x, (uint)y); }
		public static void  VAR_SUB(ref    int x,  int y) {  VAR_SUB(ref x, (uint)y); }
		public static void  VAR_SUB(ref   uint x,  int y) {  VAR_SUB(ref x, (uint)y); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//符号無し飽和減算。x=被減算変数(符号無し),y=減算値(符号無し)
		public static void UVAR_SUB(ref   byte x, uint y) { x = ((uint)(x -   byte.MinValue) >= y) ? (  byte)(x - y) : unchecked((  byte) sbyte.MinValue); }
		public static void UVAR_SUB(ref  sbyte x, uint y) { x = ((uint)(x -   byte.MinValue) >= y) ? ( sbyte)(x - y) : unchecked(( sbyte) sbyte.MinValue); }
		public static void UVAR_SUB(ref  short x, uint y) { x = ((uint)(x - ushort.MinValue) >= y) ? ( short)(x - y) : unchecked(( short) short.MinValue); }
		public static void UVAR_SUB(ref ushort x, uint y) { x = ((uint)(x - ushort.MinValue) >= y) ? (ushort)(x - y) : unchecked((ushort) short.MinValue); }
		public static void UVAR_SUB(ref    int x, uint y) { x = ((uint)(x -   uint.MinValue) >= y) ? (   int)(x - y) : unchecked((   int)   int.MinValue); }
		public static void UVAR_SUB(ref   uint x, uint y) { x = ((uint)(x -   uint.MinValue) >= y) ? (  uint)(x - y) : unchecked((  uint)   int.MinValue); }
		public static void UVAR_SUB(ref   byte x,  int y) { UVAR_SUB(ref x, (uint)y); }
		public static void UVAR_SUB(ref  sbyte x,  int y) { UVAR_SUB(ref x, (uint)y); }
		public static void UVAR_SUB(ref  short x,  int y) { UVAR_SUB(ref x, (uint)y); }
		public static void UVAR_SUB(ref ushort x,  int y) { UVAR_SUB(ref x, (uint)y); }
		public static void UVAR_SUB(ref    int x,  int y) { UVAR_SUB(ref x, (uint)y); }
		public static void UVAR_SUB(ref   uint x,  int y) { UVAR_SUB(ref x, (uint)y); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		//符号付きか符号無しかを自動的に判定するバージョン
		public static void GVAR_SUB(ref   byte x, uint y) { UVAR_SUB(ref x, y); }	//符号無し
		public static void GVAR_SUB(ref  sbyte x, uint y) {  VAR_SUB(ref x, y); }	//符号付き
		public static void GVAR_SUB(ref  short x, uint y) {  VAR_SUB(ref x, y); }	//符号付き
		public static void GVAR_SUB(ref ushort x, uint y) { UVAR_SUB(ref x, y); }	//符号無し
		public static void GVAR_SUB(ref    int x, uint y) {  VAR_SUB(ref x, y); }	//符号付き
		public static void GVAR_SUB(ref   uint x, uint y) { UVAR_SUB(ref x, y); }	//符号無し
		public static void GVAR_SUB(ref   byte x,  int y) { GVAR_SUB(ref x, (uint)y); }
		public static void GVAR_SUB(ref  sbyte x,  int y) { GVAR_SUB(ref x, (uint)y); }
		public static void GVAR_SUB(ref  short x,  int y) { GVAR_SUB(ref x, (uint)y); }
		public static void GVAR_SUB(ref ushort x,  int y) { GVAR_SUB(ref x, (uint)y); }
		public static void GVAR_SUB(ref    int x,  int y) { GVAR_SUB(ref x, (uint)y); }
		public static void GVAR_SUB(ref   uint x,  int y) { GVAR_SUB(ref x, (uint)y); }
		//-----------------------------------------------------------------------------
		//ユーティリティ
		public static void UVAR_INC(ref   byte x) { UVAR_ADD(ref x, 1); }
		public static void UVAR_INC(ref  sbyte x) { UVAR_ADD(ref x, 1); }
		public static void UVAR_INC(ref  short x) { UVAR_ADD(ref x, 1); }
		public static void UVAR_INC(ref ushort x) { UVAR_ADD(ref x, 1); }
		public static void UVAR_INC(ref    int x) { UVAR_ADD(ref x, 1); }
		public static void UVAR_INC(ref   uint x) { UVAR_ADD(ref x, 1); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void  VAR_INC(ref   byte x) {  VAR_ADD(ref x, 1); }
		public static void  VAR_INC(ref  sbyte x) {  VAR_ADD(ref x, 1); }
		public static void  VAR_INC(ref  short x) {  VAR_ADD(ref x, 1); }
		public static void  VAR_INC(ref ushort x) {  VAR_ADD(ref x, 1); }
		public static void  VAR_INC(ref    int x) {  VAR_ADD(ref x, 1); }
		public static void  VAR_INC(ref   uint x) {  VAR_ADD(ref x, 1); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void GVAR_INC(ref   byte x) { GVAR_ADD(ref x, 1); }
		public static void GVAR_INC(ref  sbyte x) { GVAR_ADD(ref x, 1); }
		public static void GVAR_INC(ref  short x) { GVAR_ADD(ref x, 1); }
		public static void GVAR_INC(ref ushort x) { GVAR_ADD(ref x, 1); }
		public static void GVAR_INC(ref    int x) { GVAR_ADD(ref x, 1); }
		public static void GVAR_INC(ref   uint x) { GVAR_ADD(ref x, 1); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void UVAR_DEC(ref   byte x) { UVAR_SUB(ref x, 1); }
		public static void UVAR_DEC(ref  sbyte x) { UVAR_SUB(ref x, 1); }
		public static void UVAR_DEC(ref  short x) { UVAR_SUB(ref x, 1); }
		public static void UVAR_DEC(ref ushort x) { UVAR_SUB(ref x, 1); }
		public static void UVAR_DEC(ref    int x) { UVAR_SUB(ref x, 1); }
		public static void UVAR_DEC(ref   uint x) { UVAR_SUB(ref x, 1); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void  VAR_DEC(ref   byte x) {  VAR_SUB(ref x, 1); }
		public static void  VAR_DEC(ref  sbyte x) {  VAR_SUB(ref x, 1); }
		public static void  VAR_DEC(ref  short x) {  VAR_SUB(ref x, 1); }
		public static void  VAR_DEC(ref ushort x) {  VAR_SUB(ref x, 1); }
		public static void  VAR_DEC(ref    int x) {  VAR_SUB(ref x, 1); }
		public static void  VAR_DEC(ref   uint x) {  VAR_SUB(ref x, 1); }
		//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		public static void GVAR_DEC(ref   byte x) { GVAR_SUB(ref x, 1); }
		public static void GVAR_DEC(ref  sbyte x) { GVAR_SUB(ref x, 1); }
		public static void GVAR_DEC(ref  short x) { GVAR_SUB(ref x, 1); }
		public static void GVAR_DEC(ref ushort x) { GVAR_SUB(ref x, 1); }
		public static void GVAR_DEC(ref    int x) { GVAR_SUB(ref x, 1); }
		public static void GVAR_DEC(ref   uint x) { GVAR_SUB(ref x, 1); }
		//*****************************************************************************
		//	Direct3D互換のD3DCOLOR形式マクロ
		//*****************************************************************************
		//□参照資料:/Program Files/Microsoft Visual Studio/VC98/Include/D3DTYPES.H
		//┌────┬────┬────┬────┐
		//│alpha   │red     │green   │blue    │
		//└────┴────┴────┴────┘
		public static int D3DRGBA(double r, double g, double b, double a)	{ return RGBA_MAKE((int)(r*255),(int)(g*255),(int)(b*255),(int)(a*255)); }	//これだけ[0.0～1.0]。これ以外は[0～255]。
		public static int RGBA_MAKE(int r, int g, int b, int a)			{ return (((byte)a)<<24)|(((byte)r)<<16)|(((byte)g)<<8)|((byte)b); }
		public static int RGBA_GETBLUE(int rgba)				{ return (byte)(rgba    ); }
		public static int RGBA_GETGREEN(int rgba)				{ return (byte)(rgba>> 8); }
		public static int RGBA_GETRED(int rgba)					{ return (byte)(rgba>>16); }
		public static int RGBA_GETALPHA(int rgba)				{ return (byte)(rgba>>24); }
		public static int RGBA_SETALPHA(int rgba, int a)			{ return (a<<24)|(rgba&0xFFFFFF); }
		public static int RGBA_TORGB(int rgba)					{ return RGBA_SETALPHA(rgba,0); }
		//┌────┬────┬────┬────┐
		//│ignored │red     │green   │blue    │
		//└────┴────┴────┴────┘
//{{2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
//		public static int D3DRGB(int r, int g, int b)				{ return D3DRGBA(r,g,b,0); }							//これだけ[0.0～1.0]。これ以外は[0～255]。
//↓2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。
		public static int D3DRGB(int r, int g, int b)				{ return D3DRGBA(r,g,b,1); }							//これだけ[0.0～1.0]。これ以外は[0～255]。	//┐2017/03/21コメント追記:
//}}2017/03/21変更:D3DRGB()マクロでD3DCOLOR値を作成した場合、α成分が1.0になるように修正しました。															//│RGB_MAKE()はα成分を0.0にするが、D3DRGB()はα成分を1.0にするという、Direct3Dの仕様に合わせました。
		public static int RGB_MAKE(int r, int g, int b)				{ return RGBA_MAKE(r,g,b,0); }													//┘なぜそういう判り辛い仕様になっているのか理解出来ないのですが、ともかく、合わせておく事にしました。
		public static int RGB_GETBLUE(int rgb)					{ return RGBA_GETBLUE(rgb); }
		public static int RGB_GETGREEN(int rgb)					{ return RGBA_GETGREEN(rgb); }
		public static int RGB_GETRED(int rgb)					{ return RGBA_GETRED(rgb); }
		public static int RGB_TORGBA(int rgb)					{ return RGBA_SETALPHA(rgb,255); }
//{{2017/04/10追加:UnityEngine.Color32⇔D3DCOLOR相互変換ユーティリティを追加しました。
#if     UNITY_5_3_OR_NEWER
		//□UnityEngine.Color32⇔D3DCOLOR相互変換ユーティリティ
		public static int RGBA_MAKE(UnityEngine.Color32 color) {	//UnityEngine.Color32⇔UnityEngine.Colorは暗黙の変換が行われるので、引数にUnityEngine.Colorを指定する事も出来ます。
			return com.Company.Library.RGBA_MAKE(
				color.r,
				color.g,
				color.b,
				color.a);
		}
		public static UnityEngine.Color32 RGBA_TOCOLOR(int rgba) {	//UnityEngine.Color32⇔UnityEngine.Colorは暗黙の変換が行われるので、戻り値をUnityEngine.Colorと見なす事も出来ます。
			return new UnityEngine.Color32(
				(byte)RGBA_GETRED(  rgba),
				(byte)RGBA_GETGREEN(rgba),
				(byte)RGBA_GETBLUE( rgba),
				(byte)RGBA_GETALPHA(rgba));
		}
#endif//UNITY_5_3_OR_NEWER
//}}2017/04/10追加:UnityEngine.Color32⇔D3DCOLOR相互変換ユーティリティを追加しました。
	}
}
