/*
 *	gtree.c
 *
 *	Balanced Binary Trees - a sorted collection of key/value pairs optimized for searching and traversing in order
 *
 *	* Mon Jul 04 21:02:51 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	- GLibBalanced Binary Trees(https://developer.gnome.org/glib/stable/glib-Balanced-Binary-Trees.html)Qlɂ܂B
 *	  ֐dlGLibłƓłÁAGLibł̃\[Xł͂ȂAL̃TCg̃\[XQlɂč쐬܂B
 *	  Ql
 *	  uOK ̃z[y[Wv(http://www.moon.sannet.ne.jp/okahisa/)́AuAVL Tree by Java -- ŕAVL؁v(http://www.moon.sannet.ne.jp/okahisa/avl-tree/avl-tree.html)̋L
 *	  /clip/keep/AVL؎Ql.7zɕۑĂ܂B
 *	  GLib̃\[Xł͂ȂAL̃TCg̃\[XQlɂŔAGLib̃\[XAL̃TCg̃\[X̕RpNgŔ₷łB
 *	  AL̃TCgɂ́Aʂ̎ƂāuJava ɂċAgȂAVL؂̎v(http://www.moon.sannet.ne.jp/okahisa/avl-tree/iavl-tree.html)ڂĂ̂łÁAʂɍċAgłQlɂĒ܂B
 *	  ċAgȂł́AAVL؂̃m[ȟ^ɐem[hւ̃NǉKvLAX̃m[h̃TCYāAŜƂăq[vgpʂȂ肪L邩łB
 *	  ́AxAȃD悷鎖ɂ܂B(AʂɍċAgł̕AċAĂяo̕AX^bNt[̃ʂ͑łB)
 *	- ̎́AقځAL̃TCg̃\[XƓłA_AӐ}Iɍ폜_L܂B
 *	  ́A⏕̌^́AchangetOp~_łB
 *	  L̃TCg̃\[Xł́AoX񕜂鏈ǂ܂őkČp邩𔻒f邽߂ɁA⏕̌^changetOgpĂ܂B
 *	  A͒Pɍ̂߂łÁA[gm[h܂őkăoX񕜂鏈sĂAʂ͓ɂȂ܂B
 *	  ̗]ȏsƂĂAg_tree_node_balanceL(),,g_tree_node_balanceR()̐擪ŃoCAX𔻒肵_ŁA]svł鎖͔̂ŁAۂɉ]͍s܂B
 *	  ܂AchangetOp~ꍇ̃I[o[wbh́A]g_tree_node_bias()AKwɂ񔭐邾̈ႢłB
 *	  g_tree_node_bias()͏\Ȃ̂ŁAقǑ傫ȃI[o[wbhł͂܂B
 *	  ܂AKw̐͂悻 log2(m[h) łA100m[hLƂĂ\KwxłB
 *	  ܂Ƃ߂܂ƁAchangetOp~ɂI[o[wbh́Am[h̒ǉ폜sxɁAg_tree_node_bias()(Ă)\sx̃I[o[wbhɉ߂A\eł܂B
 *	  ނAchangetOK؂ɃZbgENA鏈̕AIɔh_L܂̂ŁAchangetOp~̂͗ɓKĂƎv܂B
 *	  ȏ̗RɂAł́A⏕̌^́AchangetOp~܂B
 *	  AAvP[V̊ϓ_́A̓_ɂċCɂKv͗L܂B
 *	- ۂ̏AgtreéAght_hash_tableɑ΂āAɃbg͗L܂B
 *	  L̃vOőxvAgtreeght_hash_tableɑ΂Ė4{xłB
 *	  changetOp~ɂċɒ[ɒxȂĂł͂Ȃ̂ŁAXAAVL؂ƃnbVe[uɂ́Aꂮ炢̑xL̂Ǝv܂B
 *	  //xrvO
 *	  void test1();  //OQ
 *	  void test2();  //OQ
 *	  int compar(const void* _x, const void* _y);  //OQ
 *	  int app_main(int argc, char* argv[]) {
 *	    test1();  // 344[ms]
 *	    test2();  //1422[ms]
 *	    return 0;
 *	  }
 *	  void test1() {  //ght_hash_table
 *	    ght_hash_table_t* ht = ght_create(0);
 *	    int t, i, r;
 *	    ght_set_rehash(ht, 1);
 *	    seed = 0;
 *	    t = GetTickCount();
 *	    for(i = 0; i < 1000000; i++) {
 *	      r = RND16(seed) + 1;
 *	      ght_insert(ht, (void*)r, sizeof r, &r);
 *	      r = RND16(seed) + 1;
 *	      ght_remove(ht, sizeof r, &r);
 *	      r = RND16(seed) + 1;
 *	      ght_get(ht, sizeof r, &r);
 *	    }
 *	    t = GetTickCount() - t;
 *	    ght_finalize(ht);
 *	    printf("ght_hash_table: %d\n", t);
 *	  }
 *	  void test2() {  //GTree
 *	    GTree* tree = g_tree_new(compar);
 *	    int t, i, r;
 *	    seed = 0;
 *	    t = GetTickCount();
 *	    for(i = 0; i < 1000000; i++) {
 *	      r = RND16(seed) + 1;
 *	      g_tree_insert(tree, (void*)r, (void*)r);
 *	      r = RND16(seed) + 1;
 *	      g_tree_remove(tree, (void*)r);
 *	      r = RND16(seed) + 1;
 *	      g_tree_lookup(tree, (void*)r);
 *	    }
 *	    t = GetTickCount() - t;
 *	    g_tree_unref(tree);
 *	    printf("GTree: %d\n", t);
 *	  }
 *	  int compar(const void* _x, const void* _y) {
 *	    int x = (int)_x;
 *	    int y = (int)_y;
 *	    if(x < y) { return -1; }
 *	    if(x > y) { return  1; }
 *	    return 0;
 *	  }
 *	  ʂɂĂ͌Ɍ؂Ă܂񂪁AقƂǍ͖̂ł͂ȂƎv܂B
 *	  ]āAPɎƂĎgp邾Ȃ΁AgtreegӖ͖Aght_hash_tablegǂłB
 *	  ght_hash_tablegtreeDĂ_ƂẮAL̓_܂B
 *	  ׂϓIłBght_hash_table͕i͍nbVɏuԓIɑ傫ȕׂBgtree͒ᑬuԓIɋɒ[ɑ傫ȕׂ鎖͖B
 *	  IɃ\[gBght_hash_table̓\[gKvȏꍇCe[V̑OɖIɃ\[gKvLBgtree͒PɃCe[V邾ŏɃ\[gĂB
 *	* Tue Jul 05 22:24:53 JST 2016 Naoyuki Sawa
 *	- g_tree_first_np(),g_tree_next_np()ǉ܂B
 *	  ̊֐́AIWiGLibłɂ͖AƎgłB
 *	  ֐TtBbNX'np'́A'not portable'̗łB
 *	  PthreadsAڐA̖֐ɃTtBbNX'np't^Ă闬Vɕ킢܂B
 *	  ̊֐ǉŔAȉ̒ʂłB
 *	- IWiGLibłł̃Ce[V֐́Ag_tree_foreach()łB
 *	  g_tree_foreach()́AR[obN^̃Ce[V֐łB
 *	  R[obN^̃Ce[V֐́Aۂ̃AvP[Vł͎ghAfirst/next^̃Ce[V֐~Ǝv܂B
 *	  ŁAƎgƂāAfirst/next^̃Ce[V֐g_tree_first_np(),g_tree_next_np()ǉ鎖ɂ܂B
 *	- g_tree_first_np(),g_tree_next_np()̎ǵAght_first(),ght_next()ƂقړłB
 *	  Aght_first(),ght_next()'l'߂lł̂ɑ΂Ag_tree_first_np(),g_tree_next_np()̖߂l̓tOł鎖ɒӂĉB
 *	  ŔAght_hash_tablełNULL'l'Ƃĕsł̂ɑ΂AgtreełNULL̒lL蓾邽߁A'l'߂lƂNULLƏI[ʏoȂȂ邩łB
 *	* Sun Sep 04 21:41:17 JST 2016 Naoyuki Sawa
 *	- g_tree_next_np()ɁA64rbgΉ̂߂̕ύXs܂B
 *	  ڍׂ́Ag_tree_next_np()̃RgQƂĉB
 */
#include "clip.h"
/*****************************************************************************
 *	GTree
 *****************************************************************************/
/*****************************************************************************
 *	\
 *****************************************************************************/
/*typedef*/ struct _GTree {			//c[̌^
	struct _GTreeNode*	root;		//[gm[h
	int			(*key_compare_func)(const void* a, const void* b, void* user_data);	//AvP[V`̃L[r֐
	void*			key_compare_data;							//AvP[V`̃L[r֐ֈnCӂ̃f[^
	void			(*key_destroy_func)(void* data);	//AvP[V`̃L[J֐
	void			(*value_destroy_func)(void* data);	//AvP[V`̒lJ֐
	int			nnodes;		//m[h
	int			ref_count;	//QƃJEg
} /*GTree*/;
/*--------------------------------------------------------------------------*/
typedef struct _GTreeNode {			//m[ȟ^
	int			height;		//̕؂̍
	void*			key;		//̃m[h̃L[
	void*			value;		//̃m[h̒l
	struct _GTreeNode*	lst;		//
	struct _GTreeNode*	rst;		//E
} GTreeNode;
/*--------------------------------------------------------------------------*/
typedef struct _GTreeTrio {			//⏕̌^
	GTree*			tree;		//w肳ꂽc[				[in]
	void*			key;		//w肳ꂽL[,,őL[			g_tree_insert_subr*()gp鎞[in]	g_tree_remove_subr*()gp鎞[in/out]
	void*			value;		//w肳ꂽl,,őL[̒l		g_tree_insert_subr*()gp鎞[in]	g_tree_remove_subr*()gp鎞[out]
	int			mode;		//0=INSERT,1=REPLACE,2=REMOVE,3=STEAL		[in]
	int			found;		//폜m[htO	g_tree_insert_subr*()͎gpȂB		g_tree_remove_subr*()gp鎞[out]
} GTreeTrio;
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//m[h쐬B
static GTreeNode* g_tree_node_new(void* key, void* value) {
	//m[h̃mۂB
	GTreeNode* t = calloc(1, sizeof(GTreeNode));
	if(!t) { DIE(); }	//s
	//tB[hB
	t->height = 1;
	t->key    = key;
	t->value  = value;
	//쐬m[hԂB
	return t;
}
/*--------------------------------------------------------------------------*/
//؂̍ԂB
static int g_tree_node_height(GTreeNode* t/*NULL*/) {
	return t ? t->height : 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//E̕؂̍̍ԂBƐAEƕB
static int g_tree_node_bias(GTreeNode* t) {
	return g_tree_node_height(t->lst/*NULL*/) - g_tree_node_height(t->rst/*NULL*/);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//E̕؂̍A̖؂̍vZĐݒ肷B
static void g_tree_node_setHeight(GTreeNode* t) {
	int lh = g_tree_node_height(t->lst/*NULL*/);
	int rh = g_tree_node_height(t->rst/*NULL*/);
	t->height = 1 + max(lh, rh);
}
/*--------------------------------------------------------------------------*/
//񕪒Tt̍]B]؂ԂB
//	    t       	       u    
//	  ^ _     	     ^ _  
//	(a)    u    	    t    (b)
//	     ^ _  	  ^ _     
//	   (v)   (b)	(a)   (v)   
static GTreeNode* g_tree_node_rotateL(GTree* tree, GTreeNode* t) {
	GTreeNode* u = t->rst;	//NULLs
	GTreeNode* v = u->lst;	//NULL
	u->lst = t;
	t->rst = v;
	g_tree_node_setHeight(t);
	g_tree_node_setHeight(u);
	return u;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//񕪒Tt̉E]B]؂ԂB
//	       t    	    u       
//	     ^ _  	  ^ _     
//	    u    (a)	(b)    t    
//	  ^ _     	     ^ _  
//	(b)   (v)   	   (v)   (a)
static GTreeNode* g_tree_node_rotateR(GTree* tree, GTreeNode* t) {
	GTreeNode* u = t->lst;	//NULLs
	GTreeNode* v = u->rst;	//NULL
	u->rst = t;
	t->lst = v;
	g_tree_node_setHeight(t);
	g_tree_node_setHeight(u);
	return u;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//񕪒Tt̓d](]E])B]؂ԂB
//	       t    	            t      	       v        
//	     ^ _  	          ^ _    	     ^ _      
//	    u    (a)	         v    (a)  	    u     t     
//	  ^ _     	       ^ _       	  ^   _   
//	(b)    v    	      u    (d)     	(b) (c)  (d) (a)
//	     ^ _  	    ^ _          	                
//	   (c)   (d)	  (b)   (c)        	                
static GTreeNode* g_tree_node_rotateLR(GTree* tree, GTreeNode* t) {
	t->lst = g_tree_node_rotateL(tree, t->lst);
	return   g_tree_node_rotateR(tree, t);
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//񕪒Tt̓d](E]])B]؂ԂB
//	    t       	      t            	       v        
//	  ^ _     	    ^ _          	     ^ _      
//	(a)    u    	  (a)    v         	    t     u     
//	     ^ _  	       ^ _       	  ^   _   
//	    v    (b)	     (d)    u      	(a) (d)  (c) (b)
//	  ^ _     	          ^ _    	                
//	(d)   (c)   	        (c)   (b)  	                
static GTreeNode* g_tree_node_rotateRL(GTree* tree, GTreeNode* t) {
	t->rst = g_tree_node_rotateR(tree, t->rst);
	return   g_tree_node_rotateL(tree, t);
}
/*--------------------------------------------------------------------------*/
//t̃oX񕜂Ė߂lŕԂBauxɕ⏕ԂB
//؂ւ̑}ɔAVL؂̏C,,E؂ł̍폜ɔAVL؂̏C
static GTreeNode* g_tree_node_balanceL(GTreeTrio* aux, GTreeNode* t) {
	int bias = g_tree_node_bias(t);
#ifdef  _DEBUG
	if((bias > 2) || (bias < -1)) { DIE(); }		//oXEȏɕĂBŒ~瓖W[̃oOłB
#endif//_DEBUG
	if(bias == 2) {
		bias = g_tree_node_bias(t->lst);
#ifdef  _DEBUG
		if((bias > 1) || (bias < -1)) { DIE(); }	//oXEȏɕĂBŒ~瓖W[̃oOłB
#endif//_DEBUG
		if(bias >= 0) {
			t = g_tree_node_rotateR(aux->tree, t);	//]̒ŁA'g_tree_node_setHeight(t)'s܂B
		} else {
			t = g_tree_node_rotateLR(aux->tree, t);	//]̒ŁA'g_tree_node_setHeight(t)'s܂B
		}
	} else {
		g_tree_node_setHeight(t);			//]sȂꍇ́AI'g_tree_node_setHeight(t)'s܂B
	}
	return t;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//t̃oX񕜂Ė߂lŕԂBauxɕ⏕ԂB
//E؂ւ̑}ɔAVL؂̏C,,؂ł̍폜ɔAVL؂̏C
static GTreeNode* g_tree_node_balanceR(GTreeTrio* aux, GTreeNode* t) {
	int bias = g_tree_node_bias(t);
#ifdef  _DEBUG
	if((bias < -2) || (bias > 1)) { DIE(); }		//oXEȏɕĂBŒ~瓖W[̃oOłB
#endif//_DEBUG
	if(bias == -2) {
		bias = g_tree_node_bias(t->rst);
#ifdef  _DEBUG
		if((bias < -1) || (bias > 1)) { DIE(); }	//oXEȏɕĂBŒ~瓖W[̃oOłB
#endif//_DEBUG
		if(bias <= 0) {
			t = g_tree_node_rotateL(aux->tree, t);	//]̒ŁA'g_tree_node_setHeight(t)'s܂B
		} else {
			t = g_tree_node_rotateRL(aux->tree, t);	//]̒ŁA'g_tree_node_setHeight(t)'s܂B
		}
	} else {
		g_tree_node_setHeight(t);			//]sȂꍇ́AI'g_tree_node_setHeight(t)'s܂B
	}
	return t;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//}̏C(balanceLi:؂ւ̑},balanceRi:E؂ւ̑})
static GTreeNode* g_tree_node_balanceLi(GTreeTrio* aux, GTreeNode* t) { return g_tree_node_balanceL(aux, t); }
static GTreeNode* g_tree_node_balanceRi(GTreeTrio* aux, GTreeNode* t) { return g_tree_node_balanceR(aux, t); }
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//폜̏C(balanceLd:؂ł̍폜,balanceRd:E؂ł̍폜)
static GTreeNode* g_tree_node_balanceLd(GTreeTrio* aux, GTreeNode* t) { return g_tree_node_balanceR(aux, t); }
static GTreeNode* g_tree_node_balanceRd(GTreeTrio* aux, GTreeNode* t) { return g_tree_node_balanceL(aux, t); }
/*--------------------------------------------------------------------------*/
//tɃL[keyŒlvalue}Baux͕⏕B
static GTreeNode* g_tree_insert_subr2(GTreeTrio* aux, GTreeNode* t/*NULL*/) {
	//tw肳Ăc
	if(t) {
		//w肳ꂽL[ƁÃm[h̃L[rB
		int diff = (*aux->tree->key_compare_func)(aux->key, t->key, aux->tree->key_compare_data);
		//w肳ꂽL[Ãm[h̃L[΁c
		if(diff < 0) {
			//؂ɑ΂čċAB
			t->lst = g_tree_insert_subr2(aux, t->lst);
			//}̏CsB
			t = g_tree_node_balanceLi(aux, t);
		//w肳ꂽL[Ãm[h̃L[傫΁c
		} else if(diff > 0) {
			//E؂ɑ΂čċAB
			t->rst = g_tree_insert_subr2(aux, t->rst);
			//}̏CsB
			t = g_tree_node_balanceRi(aux, t);
		//w肳ꂽL[ƁÃm[h̃L[vc
		} else {
			//Ăяo̊֐ɂāc
			switch(aux->mode) {
			default:DIE();
			case 0/*INSERT*/:	//g_tree_insert()Ăяoꂽꍇ
				//w肳ꂽL[JB	v!! g_tree_insert()̏ꍇ́AɓL[̃m[hLÃL[ێAkeywL[JB
				(*aux->tree->key_destroy_func)(aux->key);
				break;
			case 1/*REPLACE*/:	//g_tree_replace()Ăяoꂽꍇ
				//̃L[B	v!! g_tree_replace()̏ꍇ́AɓL[̃m[hLÃL[JAkeywL[i[B
				(*aux->tree->key_destroy_func)(t->key);
				//w肳ꂽL[i[B
				t->key = aux->key;
				break;
			}
			//̒lB
			(*aux->tree->value_destroy_func)(t->value);
			//w肳ꂽli[B
			t->value = aux->value;
		}
	//tw肳ĂȂ΁c
	} else {
		//Vm[h쐬B
		t = g_tree_node_new(aux->key, aux->value);
		//m[h𑝂₷B
		aux->tree->nnodes++;
#ifdef  _DEBUG
		if(aux->tree->nnodes <= 0) { DIE(); }	//Œ~瓖W[̃oOłB
#endif//_DEBUG
	}
	return t;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//tree->rootɃL[keyŒlvalue}B
static void g_tree_insert_subr1(GTree* tree, void* key, void* value, int mode/*0=INSERT,1=REPLACE*/) {
	GTreeTrio aux = { tree, key, value, mode };
	tree->root = g_tree_insert_subr2(&aux, tree->root);
}
/*--------------------------------------------------------------------------*/
//t̍őL[̃m[h폜B
//߂l͍폜ɂCꂽ؁B
//t̃L[̍őlƂ̒lauxɕԂB
static GTreeNode* g_tree_remove_subr3(GTreeTrio* aux, GTreeNode* t) {
	//̃m[hɁAE؂L΁c
	if(t->rst) {
		//E؂ɑ΂čċAB
		t->rst = g_tree_remove_subr3(aux, t->rst);
		//폜̏CsB
		t = g_tree_node_balanceRd(aux, t);
	//̃m[hɁAE؂΁c
	} else {
		//؂擾ĂB
		GTreeNode* u = t->lst;	//NULL
		//̃m[h̃L[ƒli[B
		aux->key   = t->key;
		aux->value = t->value;
		//m[h炷B
		aux->tree->nnodes--;
#ifdef  _DEBUG
		if(aux->tree->nnodes < 0) { DIE(); }	//Œ~瓖W[̃oOłB
#endif//_DEBUG
		//̃m[h̃JB
		free(t);
		//؂iB
		t = u;
	}
	return t;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//tL[keỹm[h폜Baux͕⏕B
static GTreeNode* g_tree_remove_subr2(GTreeTrio* aux, GTreeNode* t/*NULL*/) {
	//tw肳Ăc
	if(t) {
		//w肳ꂽL[ƁÃm[h̃L[rB
		int diff = (*aux->tree->key_compare_func)(aux->key, t->key, aux->tree->key_compare_data);
		//w肳ꂽL[Ãm[h̃L[΁c
		if(diff < 0) {
			//؂ɑ΂čċAB
			t->lst = g_tree_remove_subr2(aux, t->lst);
			//폜̏CsB
			t = g_tree_node_balanceLd(aux, t);
		//w肳ꂽL[Ãm[h̃L[傫΁c
		} else if(diff > 0) {
			//E؂ɑ΂čċAB
			t->rst = g_tree_remove_subr2(aux, t->rst);
			//폜̏CsB
			t = g_tree_node_balanceRd(aux, t);
		//w肳ꂽL[ƁÃm[h̃L[vc
		} else {
			//̃m[hɁA؂L΁c
			if(t->lst) {
				//Ăяo̊֐ɂāc
				switch(aux->mode) {
				default:DIE();
				case 2/*REMOVE*/:	//g_tree_remove()Ăяoꂽꍇ
					//̃L[B
					(*aux->tree->key_destroy_func)(t->key);
					//̒lB
					(*aux->tree->value_destroy_func)(t->value);
					break;
				case 3/*STEAL*/:	//g_tree_steal()Ăяoꂽꍇ
					/** no job **/
					break;
				}
				//t̍őL[̃m[h폜AL[ƒl擾B
				t->lst = g_tree_remove_subr3(aux, t->lst);
				//؂̍őL[ŒuB
				t->key = aux->key;
				//؂̍őL[ɑΉlŒuB
				t->value = aux->value;
				//폜̏CsB
				t = g_tree_node_balanceLd(aux, t);
			//̃m[hɁA؂΁c
			} else {
				//E؂擾ĂB
				GTreeNode* u = t->rst;	//NULL
				//Ăяo̊֐ɂāc
				switch(aux->mode) {
				default:DIE();
				case 2/*REMOVE*/:	//g_tree_remove()Ăяoꂽꍇ
					//̃L[B
					(*aux->tree->key_destroy_func)(t->key);
					//̒lB
					(*aux->tree->value_destroy_func)(t->value);
					break;
				case 3/*STEAL*/:	//g_tree_steal()Ăяoꂽꍇ
					/** no job **/
					break;
				}
				//m[h炷B
				aux->tree->nnodes--;
#ifdef  _DEBUG
				if(aux->tree->nnodes < 0) { DIE(); }	//Œ~瓖W[̃oOłB
#endif//_DEBUG
				//̃m[h̃JB
				free(t);
				//E؂iB
				t = u;
			}
			//폜m[htOZbgB
			aux->found = 1;
		}
	//tw肳ĂȂ΁c
	} else {
		/** no job **/
	}
	return t;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//tree->rootL[keỹm[h폜B
static int g_tree_remove_subr1(GTree* tree, void* key, int mode/*2=REMOVE,3=STEAL*/) {
	GTreeTrio aux = { tree, key, NULL/*value*/, mode };
	tree->root = g_tree_remove_subr2(&aux, tree->root);
	return aux.found;
}
/*--------------------------------------------------------------------------*/
//c[ɂB
static void g_tree_clear(GTree* tree) {
	GTreeNode* t;
	while((t = tree->root)) {
		g_tree_remove(tree, t->key);
	}
#ifdef  _DEBUG
	if(tree->nnodes) { DIE(); }	//Œ~瓖W[̃oOłB
#endif//_DEBUG
}
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//Creates a new GTree.
//Parameters
//		key_compare_func	The function used to order the nodes in the GTree.
//					It should return values similar to the standard strcmp() function - 0 if the two arguments are equal, a negative value if the first argument comes before the second, or a positive value if the first argument comes after the second.
//Returns
//		A newly allocated GTree.
GTree* g_tree_new(int (*key_compare_func)(const void* a, const void* b)) {
	return g_tree_new_with_data((int (*)(const void*, const void*, void*))key_compare_func, NULL);
}
/*--------------------------------------------------------------------------*/
//Increments the reference count of tree by one.
//It is safe to call this function from any thread.				˓ł̓XbhZ[tł͂܂B̃XbhQƂ鎖͖ƎvłBۂ̏g_tree_ref()/g_tree_unref()XbhZ[tɂĂ̊֐XbhZ[tłȂ΂܂Ӗ͖Ǝv܂B
//Parameters
//		tree			A GTree.
//Returns
//		The passed in GTree.
GTree* g_tree_ref(GTree* tree) {
	//QƃJEg𑝂₷B
	tree->ref_count++;
	//treê܂ܕԂB
	return tree;
}
/*--------------------------------------------------------------------------*/
//Decrements the reference count of tree by one.
//If the reference count drops to 0, all keys and values will be destroyed (if destroy functions were specified) and all memory allocated by tree will be released.
//It is safe to call this function from any thread.				˓ł̓XbhZ[tł͂܂B̃XbhQƂ鎖͖ƎvłBۂ̏g_tree_ref()/g_tree_unref()XbhZ[tɂĂ̊֐XbhZ[tłȂ΂܂Ӗ͖Ǝv܂B
//Parameters
//		tree			A GTree.
void g_tree_unref(GTree* tree) {
	//QƃJEg炵āA0ɂȂc
	if(!--tree->ref_count) {
		//c[ɂB
		g_tree_clear(tree);
		//c[̃JB
		free(tree);
	}
}
/*--------------------------------------------------------------------------*/
//Creates a new GTree with a comparison function that accepts user data.
//See g_tree_new() for more details.
//Parameters
//		key_compare_func	qsort()-style comparison function.
//		key_compare_data	Data to pass to comparison function.
//Returns
//		A newly allocated GTree.
GTree* g_tree_new_with_data(int (*key_compare_func)(const void* a, const void* b, void* user_data), void* key_compare_data) {
	return g_tree_new_full(key_compare_func, key_compare_data, NULL, NULL);
}
/*--------------------------------------------------------------------------*/
static void g_tree_dummy_destroy_func(void* data) {
	/** no job **/
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Creates a new GTree like g_tree_new() and allows to specify functions to free the memory allocated for the key and value that get called when removing the entry from the GTree.
//Parameters
//		key_compare_func	qsort()-style comparison function.
//		key_compare_data	Data to pass to comparison function.
//		key_destroy_func	A function to free the memory allocated for the key used when removing the entry from the GTree or NULL if you don't want to supply such a function.
//		value_destroy_func	A function to free the memory allocated for the value used when removing the entry from the GTree or NULL if you don't want to supply such a function.
//Returns
//		A newly allocated GTree.
GTree* g_tree_new_full(int (*key_compare_func)(const void* a, const void* b, void* user_data), void* key_compare_data, void (*key_destroy_func/*NULL*/)(void* data), void (*value_destroy_func/*NULL*/)(void* data)) {
	//c[̃mۂB
	GTree* tree = calloc(1, sizeof(GTree));
	if(!tree) { DIE(); }	//s
	//tB[hB
	tree->key_compare_func   = key_compare_func;
	tree->key_destroy_func   = key_destroy_func   ? key_destroy_func   : g_tree_dummy_destroy_func;
	tree->value_destroy_func = value_destroy_func ? value_destroy_func : g_tree_dummy_destroy_func;
	tree->key_compare_data   = key_compare_data;
	tree->ref_count          = 1;
	//쐬c[ԂB
	return tree;
}
/*--------------------------------------------------------------------------*/
//Inserts a key/value pair into a GTree.
//If the given key already exists in the GTree its corresponding value is set to the new value.			
//If you supplied a value_destroy_func when creating the GTree, the old value is freed using that function.		v!! g_tree_insert()̏ꍇ́AɓL[̃m[hLÃL[ێAkeywL[JB
//If you supplied a key_destroy_func when creating the GTree, the passed key is freed using that function.	
//The tree is automatically 'balanced' as new key/value pairs are added, so that the distance from the root to every leaf is as small as possible.
//Parameters
//		tree			A GTree.
//		key			The key to insert.
//		value			The value corresponding to the key.
void g_tree_insert(GTree* tree, void* key, void* value) {
	g_tree_insert_subr1(tree, key, value, 0/*INSERT*/);
}
/*--------------------------------------------------------------------------*/
//Inserts a new key and value into a GTree similar to g_tree_insert().
//The difference is that if the key already exists in the GTree, it gets replaced by the new key.		
//If you supplied a value_destroy_func when creating the GTree, the old value is freed using that function.		v!! g_tree_replace()̏ꍇ́AɓL[̃m[hLÃL[JAkeywL[i[B
//If you supplied a key_destroy_func when creating the GTree, the old key is freed using that function.		
//The tree is automatically 'balanced' as new key/value pairs are added, so that the distance from the root to every leaf is as small as possible.
//Parameters
//		tree			A GTree
//		key			The key to insert.
//		value			The value corresponding to the key.
void g_tree_replace(GTree* tree, void* key, void* value) {
	g_tree_insert_subr1(tree, key, value, 1/*REPLACE*/);
}
/*--------------------------------------------------------------------------*/
//Gets the number of nodes in a GTree.
//Parameters
//		tree			A GTree.
//Returns
//		The number of nodes in tree.
int g_tree_nnodes(GTree* tree) {
	return tree->nnodes;
}
/*--------------------------------------------------------------------------*/
//Gets the height of a GTree.
//If the GTree contains no nodes, the height is 0.
//If the GTree contains only one root node the height is 1.
//If the root node has children the height is 2, etc.
//Parameters
//		tree			A GTree.
//Returns
//		The height of tree.
int g_tree_height(GTree* tree) {
	return g_tree_node_height(tree->root);
}
/*--------------------------------------------------------------------------*/
//Gets the value corresponding to the given key.
//Since a GTree is automatically balanced as key/value pairs are added, key lookup is O(log n) (where n is the number of key/value pairs in the tree).
//Parameters
//		tree			A GTree.
//		key			The key to look up.
//Returns
//		The value corresponding to the key, or NULL if the key was not found.
void* g_tree_lookup(GTree* tree, const void* key) {
	void* value;
	return g_tree_lookup_extended(tree, key, NULL, &value) ? value : NULL;
}
/*--------------------------------------------------------------------------*/
//Looks up a key in the GTree, returning the original key and the associated value.
//This is useful if you need to free the memory allocated for the original key, for example before calling g_tree_remove().
//Parameters
//		tree			A GTree.
//		lookup_key		The key to look up.
//		orig_key		Returns the original key.			[optional][nullable]
//		value			Returns the value associated with the key.	[optional][nullable]
//Returns
//		TRUE if the key was found in the GTree.
int g_tree_lookup_extended(GTree* tree, const void* lookup_key, void** orig_key/*NULL*/, void** value/*NULL*/) {
	GTreeNode* t = tree->root;
	while(t) {
		//w肳ꂽL[ƁÃm[h̃L[rB
		int diff = (*tree->key_compare_func)(lookup_key, t->key, tree->key_compare_data);
		//w肳ꂽL[Ãm[h̃L[΁c
		if(diff < 0) {
			//؂֐iށB
			t = t->lst;	//NULL
		//w肳ꂽL[Ãm[h̃L[傫΁c
		} else if(diff > 0) {
			//E؂֐iށB
			t = t->rst;	//NULL
		//w肳ꂽL[ƁÃm[h̃L[vc
		} else {
			if(orig_key) { *orig_key = t->key;   }
			if(value   ) { *value    = t->value; }
			return 1;
		}
	}
	return 0;
}
/*--------------------------------------------------------------------------*/
static int g_tree_foreach_subr(GTree* tree, GTreeNode* t/*NULL*/, int (*func)(void* key, void* value, void* data), void* user_data) {
	if(t) {
		//؂ɑ΂čċAB
		if(g_tree_foreach_subr(tree, t->lst/*NULL*/, func, user_data)) { return 1; }
		//̃m[hɑ΂ďsB
		if((*func)(t->key, t->value, user_data)) { return 1; }
		//E؂ɑ΂čċAB
		if(g_tree_foreach_subr(tree, t->rst/*NULL*/, func, user_data)) { return 1; }
	}
	return 0;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
//Calls the given function for each of the key/value pairs in the GTree.
//The function is passed the key and value of each pair, and the given data parameter.
//The tree is traversed in sorted order.
//The tree may not be modified while iterating over it (you can't add/remove items).
//To remove all items matching a predicate, you need to add each item to a list in your GTraverseFunc as you walk over the tree, then walk the list and remove each item.
//Parameters
//		tree			A GTree.
//		func			The function to call for each node visited.
//					If this function returns TRUE, the traversal is stopped.
//		user_data		User data to pass to the function.
void g_tree_foreach(GTree* tree, int (*func)(void* key, void* value, void* data), void* user_data) {
	g_tree_foreach_subr(tree, tree->root, func, user_data);
}
/*--------------------------------------------------------------------------*/
//Searches a GTree using search_func.
//The search_func is called with a pointer to the key of a key/value pair in the tree, and the passed in user_data.
//If search_func returns 0 for a key/value pair, then the corresponding value is returned as the result of g_tree_search().
//If search_func returns -1, searching will proceed among the key/value pairs that have a smaller key; if search_func returns 1, searching will proceed among the key/value pairs that have a larger key.
//Parameters
//		tree			A GTree.
//		search_func		A function used to search the GTree.
//		user_data		The data passed as the second argument to search_func.
//Returns
//		The value corresponding to the found key, or NULL if the key was not found.
//[note]
//		- g_tree_new()Ŏw肵key_compare_func֐g킸ɁAʂ̌֐search_funcgăm[h֐łB
//		  ǂ̂悤ȖړIŁÅ֐`Ă̂Aǂ܂B
//		  ۂ̃AvP[VŁÅ֐ǵAƎv܂B
void* g_tree_search(GTree* tree, int (*search_func)(const void* a, const void* b), const void* user_data) {
	GTreeNode* t = tree->root;
	while(t) {
		//m[h̃L[ƁAuser_dataAw肳ꂽ֐ɈnB
		// - key_compare_func()Ƃ́AςƋtł鎖ɒӂB
		//   ܂A߂lƐiޕςƋtł(悤ȋC)ɒӂB
		int diff = (*search_func)(t->key, user_data);
		//w肳ꂽ֐̖߂l}CiXȂ΁c
		if(diff < 0) {
			//؂֐iށB
			t = t->lst;
		//w肳ꂽ֐̖߂lvXȂ΁c
		} else if(diff > 0) {
			//E؂֐iށB
			t = t->rst;
		//w肳ꂽ֐̖߂l[Ȃ΁c
		} else {
			return t->value;
		}
	}
	return NULL;
}
/*--------------------------------------------------------------------------*/
//Removes a key/value pair from a GTree.
//If the GTree was created using g_tree_new_full(), the key and value are freed using the supplied destroy functions, otherwise you have to make sure that any dynamically allocated values are freed yourself.
//If the key does not exist in the GTree, the function does nothing.
//Parameters
//		tree			A GTree.
//		key			The key to remove.
//Returns
//		TRUE if the key was found.
int g_tree_remove(GTree* tree, const void* key) {
	return g_tree_remove_subr1(tree, (void*)key, 2/*REMOVE*/);	//LXgconstx}̂߁B
}
/*--------------------------------------------------------------------------*/
//Removes a key and its associated value from a GTree without calling the key and value destroy functions.
//If the key does not exist in the GTree, the function does nothing.
//Parameters
//		tree			A GTree.
//		key			The key to remove.
//Returns
//		TRUE if the key was found.
int g_tree_steal(GTree* tree, const void* key) {
	return g_tree_remove_subr1(tree, (void*)key, 3/*STEAL*/);	//LXgconstx}̂߁B
}
/*--------------------------------------------------------------------------*/
//Removes all keys and values from the GTree and decreases its reference count by one.
//If keys and/or values are dynamically allocated, you should either free them first or create the GTree using g_tree_new_full().
//In the latter case the destroy functions you supplied will be called on all keys and values before destroying the GTree.
//Parameters
//		tree			A GTree.
void g_tree_destroy(GTree* tree) {
	//c[ɂB
	g_tree_clear(tree);
	//QƃJEg炷B
	g_tree_unref(tree);
}
/*****************************************************************************
 *	Ǝg
 *****************************************************************************/
static void g_tree_push(GTreeIteratorNP* iter, GTreeNode* t) {
	//NULL|C^vbV鎖͏oȂB
	if(!t) { DIE(); }
	//X^bN̐[͈͓ŗL鎖mFB
	if((unsigned)iter->depth >= (unsigned)ARRAY_SIZE(iter->stack)) { DIE(); }
	//m[hi[B
	iter->stack[iter->depth] = t;
	//X^bN̐[𑝂₷B
	iter->depth++;
}
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static GTreeNode* g_tree_pop(GTreeIteratorNP* iter) {
	GTreeNode* t;
	//X^bNȂ΁ANULL|C^ԂB
	if(!iter->depth) { return NULL; }
	//X^bN̐[炷B
	iter->depth--;
	//X^bN̐[͈͓ŗL鎖mFB
	if((unsigned)iter->depth >= (unsigned)ARRAY_SIZE(iter->stack)) { DIE(); }
	//X^bNm[h|bvB
	t = iter->stack[iter->depth];
	//NULL|C^ł͂Ȃ͂łB
	if(!t) { DIE(); }
	//X^bN|bvm[hԂB
	return t;
}
/*--------------------------------------------------------------------------*/
int g_tree_first_np(GTree* tree, GTreeIteratorNP* iter, void** _key/*NULL*/, void** _value/*NULL*/) {
	//X^bNɂĂB
	iter->depth = 0;
	//ŏ̃m[h擾B
	return g_tree_next_np(tree, iter, _key, _value);
}
/*--------------------------------------------------------------------------*/
//2016/07/05
//̊֐̃ASÝA(掩^ł)AȂ肢Ǝv܂B
//ʂɍƁAX^bN̊evfɁA'ċA','̃m[h̒lԂ','EċA'̏ԂoĂ߂̕ϐKvɂȂ̂łA
//X^bN'݂̃m[h''Õm[h'r邱ƂŏԂ𔻒f悤ɂāAL̏ԂoĂ߂̕ϐsvɂ܂B
//̂߂ɁA◝Â炢R[hɂȂĂ܂A̗ǂēǂ߂΁AoƎv܂B(łYĂ܂ꍇ͂Ďvoc)
//ƁAI[ɓBCe[^ɑ΂āAēxg_tree_next_np()ĂяoꂽꍇɁA0Ԃ悤ɂ邽߂ɁA_~[m[hvbV̂Hv_łB
int g_tree_next_np(GTree* tree, GTreeIteratorNP* iter, void** _key/*NULL*/, void** _value/*NULL*/) {
	GTreeNode *t, *u;
	//X^bNm[h|bvāAÕm[h(t)ƌȂB
	t = g_tree_pop(iter);	//NULL
	//X^bNm[h|bvoȂ(=X^bN󂾂Ȃ)c
	if(!t) {
		//c[̃[gm[h擾āÃ݂m[h(u)ƌȂB
		u = tree->root;	//NULL
		//c[̃[gm[h(u)L΁c
		if(u) {
			//c[̃[gm[h(u)AőL[̃m[h擾āÃ݂m[h(u)ƌȂB
			for(;;) {
				g_tree_push(iter, u);	//m[hHoHi[B
				if(!u->lst) { break; }
				u = u->lst;
			}
		}
	//X^bNm[h|bvo(=X^bNłȂȂ)c
	} else {
		//Õm[h(t)̉E؂擾āÃ݂m[h(u)ƌȂB
		u = t->rst;	//NULL
		//Õm[h̉E(u)L΁c
		if(u) {
			//Õm[h(t)AēxAX^bNɃvbVB
			g_tree_push(iter, t);
			//Õm[h̉E(u)AőL[̃m[h擾āÃ݂m[h(u)ƌȂB
			for(;;) {
				g_tree_push(iter, u);	//m[hHoHi[B
				if(!u->lst) { break; }
				u = u->lst;
			}
		//Õm[h̉E(u)΁c
		} else {
			//ȉ̏JԂB
			for(;;) {
				//X^bNem[h|bvāÃ݂m[h(u)ƌȂB
				u = g_tree_pop(iter);
				//X^bNem[h|bvoȂ΁c
				if(!u) {
					//E؂_~[m[hAX^bNɃvbVB
					// - I[ɓBCe[^ɑ΂āAēxg_tree_next_np()ĂяoꂽꍇɁA0Ԃ悤ɂ邽߂łB
					static const GTreeNode dummy;		//dummy.rst=NULL
					g_tree_push(iter, (void*)&dummy);	//LXgconstx}̂߁B
					//[v𔲂āA0ԂB
					break;
				}
				//Õm[h(t)A݃m[h(u)̍؂Ȃ΁c
				if(t == u->lst) {
					//݂̃m[h(u)AēxAX^bNɃvbVB
					g_tree_push(iter, u);
					//[v𔲂āÃ݂m[h(u)̃L[ƒlԂB
					break;
				}
				//Õm[h(t)A݃m[h(u)̉E؂ł鎖mFB
				if(t != u->rst) { DIE(); }
				//݂̃m[h(u)AÕm[h(t)ƌȂāAJԂB
				t = u;
			}
		}
	}
	//݂̃m[hL΁c
	if(u) {
		//݂̃m[h̃L[ƒli[B
		if(_key  ) { *_key   = u->key;   }
		if(_value) { *_value = u->value; }
	}
	//݂̃m[hL0ȊO̒lÃ݂m[h0ԂB
//{{2016/09/04ύX:g_tree_next_np()ɁA64rbgΉ̂߂̕ύXs܂B
//	return (int)u;
//2016/09/04ύX:g_tree_next_np()ɁA64rbgΉ̂߂̕ύXs܂B
#ifndef _WIN64
	return (int)u;	//32rbgȂ΁A|C^(int)ɃLXg邾ŗǂB32rbgłAL64rbgƓɂĂ\Ȃ̂A|C^(int)ɃLXg邾̕ǂR[h(P/ECȄꍇ)̂ŁAďRpCŕ鎖ɂB
#else //_WIN64
	return !!u;	//64rbgȂ΁AIɃ|C^NULLłȂA肷KvLBȂȂ΁A|C^(int)ɃLXgƁA|C^̏32rbgĂ܂AANULL|C^̉32rbgR0ꍇɁAԈʂɂȂĂ܂łB
#endif//_WIN64
//}}2016/09/04ύX:g_tree_next_np()ɁA64rbgΉ̂߂̕ύXs܂B
}
/*--------------------------------------------------------------------------*/
#if 0
//eXgvO
static int compar(const void* _x, const void* _y);	//OQ
void test() {
	GTree* tree = g_tree_new(compar);
	GTreeIteratorNP iter;
	void *key, *value;
	g_tree_insert(tree, (void*)1, (void*)"One");
	g_tree_insert(tree, (void*)2, (void*)"Two");
	g_tree_insert(tree, (void*)3, (void*)"Three");
	g_tree_insert(tree, (void*)4, (void*)"Four");
	g_tree_insert(tree, (void*)5, (void*)"Five");
	g_tree_insert(tree, (void*)6, (void*)"Six");
	g_tree_insert(tree, (void*)7, (void*)"Seven");
	g_tree_insert(tree, (void*)8, (void*)"Eight");
	g_tree_insert(tree, (void*)9, (void*)"Nine");
	if(g_tree_first_np(tree, &iter, &key, &value)) {
		do {
			printf("%d %s\n", key, value);
			//
			//1 One
			//2 Two
			//3 Three
			//4 Four
			//5 Five
			//6 Six
			//7 Seven
			//8 Eight
			//9 Nine
		} while(g_tree_next_np(tree, &iter, &key, &value));
	}
	if(g_tree_next_np(tree, &iter, NULL, NULL)) { DIE(); }	//
	if(g_tree_next_np(tree, &iter, NULL, NULL)) { DIE(); }	//I[ɓBCe[^ɑ΂āAēxg_tree_next_np()ĂяoĂA0ԂꑱB
	if(g_tree_next_np(tree, &iter, NULL, NULL)) { DIE(); }	//
	g_tree_unref(tree);
}
static int compar(const void* _x, const void* _y) {
	int x = (int)_x;
	int y = (int)_y;
	if(x < y) { return -1; }
	if(x > y) { return  1; }
	return 0;
}
#endif
