/*	
 *	frammp3.c
 *
 *	P/ECE MP3 Driver
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2003 Naoyuki Sawa
 *
 *	* Tue Oct 28 08:11:00 JST 2003 Naoyuki Sawa
 *	- 1st [XB
 *	* Wed Nov 12 05:25:00 JST 2003 Naoyuki Sawa
 *	- CLiPCuֈړB
 *	* Wed Apr 14 12:30:00 JST 2004 Naoyuki Sawa
 *	- mp3_bitstream_get()ŁA24bitȏ̃rbgǂݍޏԈĂ̂CB
 *	  ۂɂ24bitȏ̃rbgǂނƂ͂Ȃ̂ŁA܂ł̃vOł͔܂B
 */
#include "clip.h"

/****************************************************************************
 *	rbgXg[
 ****************************************************************************/

/* rbgXg[rbgǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 *	cnt		ǂݍރrbgB(0`32)
 * [out]
 *	߂l		ǂݍ񂾃rbgB
 */
int
mp3_bitstream_get(MP3BITSTREAM* bs, int cnt)
{
	int bits;

	ASSERT(0 <= cnt && cnt <= 32);

	if(cnt <= 24) {
		bs->read_bits += cnt;
		while(bs->cnt < cnt) {
			bs->buf = bs->buf << 8 | *bs->pos++;
			bs->cnt += 8;
		}
		bs->cnt -= cnt;
		bits = (bs->buf >> bs->cnt) & ((1 << cnt) - 1);
	} else {
		cnt -= 24;
		bits = mp3_bitstream_get(bs,  24) << cnt |
		       mp3_bitstream_get(bs, cnt);
	}

	return bits;
}

/* rbgXg[1rbgǂݍ݂܂B
 * [in]
 *	bs		rbgXg[\́B
 * [out]
 *	߂l		ǂݍ񂾃rbgB
 * [note]
 *	* nt}1rbgǂݍ݂𑽗p̂ŁAʂɍ܂B
 *	  mp3_huffman_decode_bigvalue/count1()̍œ[vł̃WX^ޔEȂ邽߁A
 *	  nt}2.0`2.5{ł܂B
 */
#define mp3_bitstream_get1(bs)									\
		((bs)->read_bits++,								\
		((bs)->cnt ? (((bs)->buf               ) >> ((bs)->cnt = (bs)->cnt - 1) & 1)	\
		           : (((bs)->buf = *(bs)->pos++) >> ((bs)->cnt =         8 - 1) & 1)))

/****************************************************************************
 *	nt}
 ****************************************************************************/

/* BigValuë̒PRegion𕜍Tu[`łB
 * [in]
 *	bs			rbgXg[\́B
 *	i_table			e[uԍB
 *	count			TvB
 *	out			o̓obt@B
 * [note]
 *	* ߖ̂߂ɁATu[`ɕ܂B
 *	  Amp3_huffman_decode()̒3R[hWJƁA300oCgĂ܂܂B
 *	* ̊֐1Oj[3Ăяo邾Ȃ̂ŁA֐Ăяoɂ鑬xቺ͏ȂƎv܂B
 */
void
mp3_huffman_decode_bigvalue(MP3BITSTREAM* bs, int i_table, int count, short* out)
{
	int linbits, i_node, x, y;
	const short (*table)[2];

	/* e[u擾B */
	table   = mp3_huffman_bigvalue_table[i_table].table;
	linbits = mp3_huffman_bigvalue_table[i_table].linbits;

	/* B */
	if(table) {
		while(count) {
			i_node = 0;
			do {
				i_node = table[i_node][mp3_bitstream_get1(bs)];
			} while(i_node > 0);
			i_node = -i_node;
			x = i_node >> 4;
			y = i_node & 15;
			if(x == 15) x += mp3_bitstream_get(bs, linbits);
			if(x && mp3_bitstream_get1(bs)) x = -x;
			if(y == 15) y += mp3_bitstream_get(bs, linbits);
			if(y && mp3_bitstream_get1(bs)) y = -y;
			*out++ = x;
			*out++ = y;
			count -= 2/*{x,y}*/;
		}
	} else {
		/* [Œe[uB(SCMPX͐܂񂪁ALAME͐܂) */
		while(count) {
			*out++ = 0;
			*out++ = 0;
			count -= 2/*{x,y}*/;
		}
	}
}

/* Count1̈𕜍Tu[`łB
 * [in]
 *	bs			rbgXg[\́B
 *	i_table			e[uԍB
 *	count_limit		őo̓TvB
 *	out			o̓obt@B
 *	part2_3_length		GRANULE.part2_3_lengthnĂB
 * [out]
 *	߂l			o̓TvB
 * [note]
 *	* rbgXg[\̂read_bitsAXP[t@N^ǂݍݒÕ^C~OŃZbgĂĂB
 *	* {́ABigValuëCount1̈킹ĂMP3_GRANULE_SIZE(576)TvȓɎ܂͂Ȃ̂łA
 *	  fR[_ɂĂ̓I[o[Ă܂Ƃ悤łB
 *	  ̂߁Aőo̓Tvɂ郊~b^KvłB(MP3fR[_Ă)
 *	  SCMPXŃGR[hMP3t@CłAI[o[܂B炱̃oOm܂񂪁EEE
 */
int
mp3_huffman_decode_count1(MP3BITSTREAM* bs, int i_table, int count_limit, short* out, int part2_3_length)
{
	int i_node, v, w, x, y;
	const short (*table)[2];
	short *out0, *out_limit;

	out0 = out;
	out_limit = out + count_limit - 4/*{v,w,x,y}*/;

	/* e[u擾B */
	table = mp3_huffman_count1_table[i_table].table;

	/* B */
	while((out <= out_limit) && (bs->read_bits < part2_3_length)) {
		i_node = 0;
		do {
			i_node = table[i_node][mp3_bitstream_get1(bs)];
		} while(i_node > 0);
		i_node = -i_node;
		v = i_node >> 3 & 1;
		w = i_node >> 2 & 1;
		x = i_node >> 1 & 1;
		y = i_node >> 0 & 1;
		if(v && mp3_bitstream_get1(bs)) v = -v;
		if(w && mp3_bitstream_get1(bs)) w = -w;
		if(x && mp3_bitstream_get1(bs)) x = -x;
		if(y && mp3_bitstream_get1(bs)) y = -y;
		*out++ = v;
		*out++ = w;
		*out++ = x;
		*out++ = y;
	}

	return out - out0;
}

/****************************************************************************
 *	tʎq
 ****************************************************************************/

/* * MP3dlɒ߂ꂽAtʎq̌vZ͎̒ʂłB
 *
 *	xr  is ~ |is|^(1/3) ~ 2^(Gain-Scale)
 *
 *	is: tʎqւ̓̓f[^
 *	xr: tʎq̏o͌
 *
 *   A
 *
 *	Gain   (GlobalGain-210)/4 - SubblockGain
 *	Scale  ((ScalefactorScale+1)~(Scalefactor+Preemphasis)) / 2
 *
 *   SubblockGainAScalefactorScaleAPreemphais̏ȗ0Ɖ肷ƁA
 *
 *	Gain   (GlobalGain-210) / 4
 *	Scale  Scalefactor / 2
 *
 *   ܂Ƃ߂ƁAZł͎̂悤ɏł܂B
 *
 *	xr  is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4 - Scalefactor/2)
 *	    is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4)  2^(Scalefactor/2)
 *	    is ~ |is|^(1/3) ~ 2^((GlobalGain-210)/4) >> (Scalefactor/2)
 *	            ~~~~~~~~~~    ~~~~~~~~~~~~~~~~~~~~~~
 *	            e[u          e[u      
 */

/* tʎqB(OubN)
 * [in]
 *	frame		t[wb_\́B
 *	granule		Oj[\́B
 *	scale		XP[t@N^\́B
 *	in		̓obt@B
 *	out		o̓obt@B
 *	count		BigValuëCount1̈̃f[^vB
 * [note]
 *	* XP[t@N^XP[(MP3GRANULEINFO.scalefac_scale)͖ΉłB
 *	  ۂMP3t@Cł͂قƂ0ɂȂĂ悤Ȃ̂ŁA܂e͂ȂƎv܂B
 *	* ̂߂ɁABigValuëCount1̈̃f[^̂ݏ܂B
 *	  rzerö̃f[^͏܂B
 */
void
mp3_requantize_long(const MP3FRAMEHEADER* frame, const MP3GRANULEINFO* granule, const MP3SCALEFACTOR* scale, const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, short* out/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int count)
{
	int gain, i, w, index;
	short h;
	const short* sfb_index;
	const short* sfb_scale;

	/* XP[t@N^oh̏B */
	sfb_index = &mp3_scalefactor_band_index_table[frame->sampling_frequency][0/*LongBlock*/][1/*̃oh̊JnCfNX*/];
	sfb_scale = scale->long_block;
	index = 0;

	gain = mp3_gain_table[granule->global_gain];	/* 1.13.18 */
	for(i = 0; i < count; i++) {
		/* g1TvtʎqB */
		h = *in++;				/* 1.15. 0 */
		w = h * mp3_pow1_3_table[abs(h)];	/* 1.21.10 (short~short) */
		w = w * gain;				/* 1. 3.28 (int~int) */
		*out++ = w >> (14 + *sfb_scale / 2);	/* 1. 1.14 (I[o[t[) */

		/* ̃XP[t@N^oh̊JnCfNXɓBAgpXP[֐i߂܂B */
		index++;
		if(index == *sfb_index) {
			sfb_index++;
			sfb_scale++;
		}
	}
}

/****************************************************************************
 *	GAVO팸
 ****************************************************************************/

/* * ͂Ă܂BႦ΁ALӂȃTuoh3̏ꍇA
 *
 *	{͂Ȃ΂Ȃ
 *	+-------------+
 *	|             |
 *	|#31(all zero)|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (all zero)|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(all zero)|
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   {́ATuoh#2#3Ԃ̃o^tCZsȂ΂܂B
 *   A݂̎ł́AŌ̃o^tCZsĂ܂B
 *
 *	͂ȂĂ
 *	+-------------+
 *	|             |
 *	|#31(  S~  )|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (  S~  )|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(  S~  )|
 *	|             |
 *	+-------------+
 *	|             |
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   ȂȂATuoh#3`31ɑ΂Ă͋tʎqł̏o͂sĂ炸AS~Ă邩łB
 *   Tuoh#2#3Ԃ̃o^tCẐ݁A#3all zeroƌȂēʏ邱Ƃł܂B
 *
 *	ǈāi̗pj
 *	+-------------+
 *	|             |
 *	|#31(  S~  )|
 *	|             |
 *	+-------------+
 *	| .           |
 *	| . (  S~  )|
 *	| .           |
 *	+-------------+
 *	|             |
 *	|# 3(  S~  )|
 *	|             |
 *	+-------------+  |#3all zeroƌȂēʏ
 *	|             |<-+
 *	|# 2          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 1          |
 *	|             |<-+
 *	+-------------+  |o^tCZ
 *	|             |<-+
 *	|# 0          |
 *	|             |
 *	+-------------+
 *
 *   A͂͂܂łB
 *   Lӂȃf[^̂΂񍂉̕Ȃ̂ŁAĂĂ܂e͂ȂƔfłB
 */

/* GAVO팸B(OubN̂)
 * [in]
 *	in_out		o̓obt@
 *	subband_count	
 *	subband_count	BigValuë܂Count1̈̃f[^ȂƂꕔ܂ރTuoh̐B
 */
#ifndef PIECE /**************************************************************/

void
mp3_antialias(short* in_out, int subband_count)
{
	int i;
	short a, b, cs, ca;
	short *pa, *pb;
	const short* table;

	table = &mp3_antialias_table[0][0];
	while(--subband_count > 0) {
		in_out += MP3_SUBBAND_SIZE;
		pa = in_out;
		pb = in_out;
		for(i = 0; i < 8; i++) {
			a = *--pa;				/* 1.1.14 */
			b = *  pb;				/* 1.1.14 */
			cs = *table++;				/* 1.1.14 */
			ca = *table++;				/* 1.1.14 */
			*pa   = (a * cs - b * ca) >> 14;	/* short~short 1.3.28 => 1.1.14 */
			*pb++ = (b * cs + a * ca) >> 14;	/* short~short 1.3.28 => 1.1.14 */
			pb++;
		}
		table -= 2 * 8;
	}
}

#else	/********************************************************************/

/* TODO: C^[bNfBCXbgAÖقextߐl͂܂sĂ܂B */
asm("
	.code
	.align 1
	.global mp3_antialias
mp3_antialias:
	pushn %r1
	;
	xld.w %r14, mp3_antialias_table		; table = &mp3_antialias_table[0][0]
mp3_antialias_L10:
	xsub %r13, %r13, 1			; while(--subband_count > 0) {
	xjrle mp3_antialias_L30
	;
	xadd %r12, %r12, 36			; in_out += MP3_SUBBAND_SIZE * sizeof(short)
	ld.w %r10, %r12				; pa = in_out
	ld.w %r11, %r12				; pb = in_out
	;
	xld.w %r15, 8				; i = 8
mp3_antialias_L20:
	xsub %r10, %r10, 2			; a = *--pa (pa -= sizeof(short), a = *pa)
	ld.h %r4, [%r10]
	ld.h %r5, [%r11]			; b = *pb
	ld.h %r6, [%r14]+			; cs = *table++
	ld.h %r7, [%r14]+			; ca = *table++
	mlt.h %r4, %r6				; *pa = (a * cs - b * ca) >> 14
	ld.w %r0, %alr
	mlt.h %r5, %r7
	ld.w %r1, %alr
	sub %r0, %r1
	xsra %r0, 14
	ld.h [%r10], %r0
	mlt.h %r5, %r6				; *pb++ = (b * cs + a * ca) >> 14
	ld.w %r0, %alr
	mlt.h %r4, %r7
	ld.w %r1, %alr
	add %r0, %r1
	xsra %r0, 14
	ld.h [%r11]+, %r0
	;
	xsub %r15, %r15, 1
	xjrne mp3_antialias_L20
	;
	xsub %r14, %r14, 32			; table -= (2 * 8) * sizeof(short)
	xjp mp3_antialias_L10
	;
mp3_antialias_L30:
	popn %r1
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	IMDCT
 ****************************************************************************/

/* IMDCTB(OubN)
 * [in]
 *	in		̓obt@B
 *	out		o̓obt@B
 *	save		t[ԂŕۑKv̂obt@B
 *	subband_count	BigValuë܂Count1̈̃f[^ȂƂꕔ܂ރTuoh̐B
 * [note]
 *	* Tuoḧꕔ肵Ă܂B
 *	* ̂߂ɁABigValuëCount1̈̃f[^̂ݏ܂B
 *	  rzerö̃f[^͏܂B
 */
#ifndef PIECE /**************************************************************/

void
mp3_imdct_long(const short* in/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, short* out/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, short* save/*[MP3_SUBBAND_COUNT][MP3_SUBBAND_SIZE]*/, int subband_count)
{
	int i, j, k, sum;
	const short* m;

	k = 0;

	/* BigValue/Count1̈ */
	while(k < subband_count) {
		m = &mp3_imdct_long_matrix[0][0];

		/* uÕOj[̌㔼vƁũ݂Oj[̑OvďóB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			sum += *save++;	/* 1.1.14 */
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;	/* 1.1.14 */
			out += MP3_SUBBAND_COUNT;
			in  -= MP3_SUBBAND_SIZE;
		}
		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_SIZE; j++) {
				sum += *in++ * *m++;	/* short~short 1.3.28 */
			}
			sum >>= 14;	/* 1.1.14 */
			*save++ = sum;	/* 1.1.14 */
			in -= MP3_SUBBAND_SIZE;
		}
		in += MP3_SUBBAND_SIZE;

		k++;
	}

	/* rzerö */
	while(k < MP3_SUBBAND_COUNT) {
		/* uÕOj[̌㔼vƁũ݂Oj[̑OvďóB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			sum = *save++;	/* 1.1.14 */
			/* TuoḧꕔBs𕄍]ē]uĂB */
			if(k & i & 1) sum = -sum;
			*out = sum;	/* 1.1.14 */
			out += MP3_SUBBAND_COUNT;
		}
		out  -= MP3_GRANULE_SIZE - 1;
		save -= MP3_SUBBAND_SIZE;

		/* ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB */
		for(i = 0; i < MP3_SUBBAND_SIZE; i++) {
			*save++ = 0;	/* 1.1.14 */
		}

		k++;
	}
}

#else	/********************************************************************/

/* TODO: C^[bNfBCXbgAÖقextߐl͂܂sĂ܂B */
asm("
	.code
	.align 1
	.global mp3_imdct_long
mp3_imdct_long:
	;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;	BigValue/Count1̈
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;
	xld.w %r7, 0				; k = 0
mp3_imdct_long_L10:
	cmp %r7, %r15				; while(k < count)
	xjreq mp3_imdct_long_L50
	;
	xld.w %r11, mp3_imdct_long_matrix	; m = mp3_imdct_long_matrix
	;
	; uÕOj[̌㔼vƁũ݂Oj[̑OvďóB
	;
	xld.w %r6, 18				; i = MP3_SUBBAND_SIZE
mp3_imdct_long_L20:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 18				; MP3_SUBBAND_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h %r5, [%r14]+			; sum += *save++
	add %r10, %r5
	;
	xld.w %r5, 1				; if(k & i & 1) sum = -sum
	and %r5, %r7
	and %r5, %r6
	xjreq mp3_imdct_long_L30
	not %r10, %r10
	xadd %r10, %r10, 1
mp3_imdct_long_L30:
	ld.h [%r13], %r10			; *out = sum
	xadd %r13, %r13, 64			; out += MP3_SUBBAND_COUNT * sizeof(short)
	xsub %r12, %r12, 36			; in -= MP3_SUBBAND_SIZE * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_long_L20
	;
	xsub %r13, %r13, 1150			; out -= (MP3_GRANULE_SIZE - 1) * sizeof(short)
	xsub %r14, %r14, 36			; save -= MP3_SUBBAND_SIZE * sizeof(short)
	;
	; ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB
	;
	xld.w %r6, 18				; i = MP3_SUBBAND_SIZE
mp3_imdct_long_L40:
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 18				; MP3_SUBBAND_SIZE
	mac %r10	
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h [%r14]+, %r10			; *save++ = sum
	xsub %r12, %r12, 36			; in -= MP3_SUBBAND_SIZE * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_long_L40
	;
	xadd %r12, %r12, 36			; in += MP3_SUBBAND_SIZE * sizeof(short)
	;
	xjp.d mp3_imdct_long_L10		; k++
	add %r7, 1				; (delay)
mp3_imdct_long_L50:
	;
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;	rzerö
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	;
	xld.w %r15, 32				; MP3_SUBBAND_COUNT
mp3_imdct_long_L60:
	cmp %r7, %r15				; while(k < MP3_SUBBAND_COUNT)
	xjreq mp3_imdct_long_L100
	;
	xld.w %r11, mp3_imdct_long_matrix	; m = mp3_imdct_long_matrix
	;
	; uÕOj[̌㔼vƁũ݂Oj[̑OvďóB
	;
	xld.w %r6, 18				; i = MP3_SUBBAND_SIZE
mp3_imdct_long_L70:
	ld.h %r10, [%r14]+			; sum = *save++
	;
	xld.w %r5, 1				; if(k & i & 1) sum = -sum
	and %r5, %r7
	and %r5, %r6
	xjreq mp3_imdct_long_L80
	not %r10, %r10
	xadd %r10, %r10, 1
mp3_imdct_long_L80:
	ld.h [%r13], %r10			; *out = sum
	xadd %r13, %r13, 64			; out += MP3_SUBBAND_COUNT * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_long_L70
	;
	xsub %r13, %r13, 1150			; out -= (MP3_GRANULE_SIZE - 1) * sizeof(short)
	xsub %r14, %r14, 36			; save -= MP3_SUBBAND_SIZE * sizeof(short)
	;
	; ũOj[̑Ovɍ邽߂Ɂũ݂Oj[̌㔼vۑB
	;
	xld.w %r6, 18				; i = MP3_SUBBAND_SIZE
mp3_imdct_long_L90:
	ld.h [%r14]+, %r8			; *save++ = 0
	;
	xsub %r6, %r6, 1
	xjrne mp3_imdct_long_L90
	;
	xjp.d mp3_imdct_long_L60		; k++
	add %r7, 1				; (delay)
	;
mp3_imdct_long_L100:
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	Tuoh
 ****************************************************************************/

/* TuohB
 * [in]
 *	in		̓obt@B
 *	out		o̓obt@B
 *	save		t[ԂŕۑKv̂obt@B
 *	offset		saveItZbgB
 *			Omp3_subband_synthesys()̖߂lnĂB
 *	convert		TvOgϊe[uB
 * [out]
 *	߂l		saveItZbgB
 * [note]
 *	* Tuoḧꕔmp3_imdct()ŐɍsĂ܂B
 */
#ifndef PIECE /**************************************************************/

int
mp3_subband_synthesys(const short* in/*[MP3_SUBBAND_SIZE][MP3_SUBBAND_COUNT]*/, short* out/*[upto MP3_GRANULE_SIZE]*/, short* save/*[16][MP3_SUBBAND_COUNT_2]*/, int offset, const MP3SAMPLINGFREQUENCYCONVERTTABLE* convert)
{
	int i, j, k, sum, count;
	const short* m;
	const unsigned char* table;

#define OFFSET_MASK	(MP3_SUBBAND_COUNT_2 * 16 - 1)

	table = convert->table;
	count = convert->count;

	for(k = 0; k < MP3_SUBBAND_SIZE; k++) {
		/* ݍ݉ZB(32f[^ԗ̈ɕϊ)
		 * ͍s̊s𕄍]ē]u鏈́AIMDCT̒ōsĂ܂B
		 */
		for(i = 0; i < count; i++) {
			/* O */
			m = mp3_subband_matrix[*table++];
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;	/* 1.3.28 */
			}
			save[offset] = sum >> 14;	/* 1.1.14 */
			offset += MP3_SUBBAND_COUNT;
			in -= MP3_SUBBAND_COUNT;
			/* 㔼 */
			m += MP3_SUBBAND_COUNT * MP3_SUBBAND_COUNT - MP3_SUBBAND_COUNT;
			sum = 0;
			for(j = 0; j < MP3_SUBBAND_COUNT; j++) {
				sum += *in++ * *m++;	/* 1.3.28 */
			}
			save[offset] = sum >> 14;	/* 1.1.14 */
			offset -= MP3_SUBBAND_COUNT - 1;
			in -= MP3_SUBBAND_COUNT;
		}
		table -= count;
		offset -= count;
		in += MP3_SUBBAND_COUNT;

		/* 16g̃f[^̏dˍ킹B
		 * |tF[YtB^[oNW\́A炩ߓ]uĂ܂B
		 */
		for(i = 0; i < count; i++) {
			m = mp3_polyphase_filter[*table++];
			sum = 0;
			for(j = 0; j < 16 / 2/*2TvÂ*/; j++) {
				/* O */
				sum += save[offset] * *m++;	/* 1.3.28 */
				offset += MP3_SUBBAND_COUNT_2 + MP3_SUBBAND_COUNT;
				offset &= OFFSET_MASK;
				/* 㔼 */
				sum += save[offset] * *m++;	/* 1.3.28 */
				offset += MP3_SUBBAND_COUNT_2 - MP3_SUBBAND_COUNT;
				offset &= OFFSET_MASK;
			}
			offset++;
			/* -0x7fff`0x7fffɃXP[OB */
			sum >>= 13;	/* 1.(16).15 */
			if(sum < -0x7fff) sum = -0x7fff;
			if(sum >  0x7fff) sum =  0x7fff;
			*out++ = sum;	/* 1.15 */
		}
		table -= count;
		offset -= MP3_SUBBAND_COUNT_2 + count;
		offset &= OFFSET_MASK;
	}

#undef OFFSET_MASK

	return offset;
}

#else	/********************************************************************/

/* TODO: C^[bNfBCXbgAÖقextߐl͂܂sĂ܂B */
asm("
	.code
	.align 1
	.global mp3_subband_synthesys
mp3_subband_synthesys:
	pushn %r3
	;
	xld.w %r4, [%sp + 20]			; convert
	ld.w %r0, [%r4]+			; +0,4: table
	ld.h %r1, [%r4]				; +4,2: count
	xld.w %r2, mp3_subband_matrix
	xld.w %r3, mp3_polyphase_filter
	;
	xld.w %r7, 18				; k = MP3_SUBBAND_SIZE
mp3_subband_synthesys_L10:
	;
	; ݍ݉ZB(32f[^ԗ̈ɕϊ)
	; ͍s̊s𕄍]ē]u鏈́AIMDCT̒ōsĂ܂B
	;
	ld.w %r6, %r1				; i = count
	ld.w %r5, %r14				; save_ptr = &save[offset]
	add %r5, %r15
mp3_subband_synthesys_L20:
	; O
	ld.ub %r11, [%r0]+			; m = mp3_subband_matrix[*table++]
	xsla %r11, 6				;   = mp3_subband_matrix + (*table++ * MP3_SUBBAND_COUNT) * sizeof(short)
	add %r11, %r2
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 32				; MP3_SUBBAND_COUNT
	mac %r10
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h [%r5], %r10			; *save_ptr = sum
	xadd %r5, %r5, 64			; save_ptr += MP3_SUBBAND_COUNT * sizeof(short)
	xsub %r12, %r12, 64			; in -= MP3_SUBBAND_COUNT * sizeof(short)
	; 㔼
	xadd %r11, %r11, 1984			; m += (MP3_SUBBAND_COUNT * MP3_SUBBAND_COUNT - MP3_SUBBAND_COUNT) * sizeof(short)
	ld.w %alr, %r8				; ݍ
	xld.w %r10, 32				; MP3_SUBBAND_COUNT
	mac %r10
	ld.w %r10, %alr				; sum >>= 14
	xsra %r10, 14
	ld.h [%r5], %r10			; *save_ptr = sum
	xsub %r5, %r5, 62			; save_ptr -= (MP3_SUBBAND_COUNT - 1) * sizeof(short)
	xsub %r12, %r12, 64			; in -= MP3_SUBBAND_COUNT * sizeof(short)
	;
	xsub %r6, %r6, 1
	xjrne mp3_subband_synthesys_L20
	;
	sub %r0, %r1				; table -= count
	xadd %r12, %r12, 64			; in += MP3_SUBBAND_COUNT * sizeof(short)
	;
	; 16g̃f[^̏dˍ킹B
	; |tF[YtB^[oNW\́A炩ߓ]uĂ܂B
	;
	ld.w %r11, %r1				; i = count
mp3_subband_synthesys_L30:
	ld.ub %r6, [%r0]+			; m = mp3_polyphase_filter[*table++]
	xsla %r6, 5				;   = mp3_polyphase_filter + (*table++ * 16) * sizeof(short)
	add %r6, %r3
	ld.w %alr, %r8				; sum = 0
	xld.w %r10, 8				; j = 16 / 2/*2TvÂ*/
mp3_subband_synthesys_L40:
	ld.w %r5, %r14				; sum += save[offset] * *m++
	add %r5, %r15
	xld.w %r4, 1
	mac %r4
	xadd %r15, %r15, 192			; offset += (MP3_SUBBAND_COUNT_2 + MP3_SUBBAND_COUNT) * sizeof(short)
	xand %r15, %r15, 2047			; offset &= OFFSET_MASK (= MP3_SUBBAND_COUNT_2 * 16 * sizeof(short) - 1)
	ld.w %r5, %r14				; sum += save[offset] * *m++
	add %r5, %r15
	xld.w %r4, 1
	mac %r4
	xadd %r15, %r15, 64			; offset += (MP3_SUBBAND_COUNT_2 - MP3_SUBBAND_COUNT) * sizeof(short)
	xand %r15, %r15, 2047			; offset &= OFFSET_MASK (= MP3_SUBBAND_COUNT_2 * 16 * sizeof(short) - 1)
	;
	xsub %r10, %r10, 1
	xjrne mp3_subband_synthesys_L40
	;
	xadd %r15, %r15, 2			; offset += 1 * sizeof(short)
	ld.w %r4, %alr				; sum >>= 13
	xsra %r4, 13
	xcmp %r4, -32767			; if(sum < -0x7fff) sum = -0x7fff
	xjrge mp3_subband_synthesys_L50
	xld.w %r4, -32767
mp3_subband_synthesys_L50:
	xcmp %r4, 32767				; if(sum >  0x7fff) sum =  0x7fff
	xjrle mp3_subband_synthesys_L60
	xld.w %r4, 32767
mp3_subband_synthesys_L60:
	ld.h [%r13]+, %r4			; *out++ = sum
	;
	xsub %r11, %r11, 1
	xjrne mp3_subband_synthesys_L30
	;
	sub %r0, %r1				; table -= count
	xsub %r15, %r15, 128			; offset -= (MP3_SUBBAND_COUNT_2 + count) * sizeof(short)
	sub %r15, %r1
	sub %r15, %r1
	xand %r15, %r15, 2047			; offset &= OFFSET_MASK (= MP3_SUBBAND_COUNT_2 * 16 * sizeof(short) - 1)
	;
	xsub %r7, %r7, 1
	xjrne mp3_subband_synthesys_L10
	;
	ld.w %r10, %r15
	popn %r3
	ret
");

#endif	/********************************************************************/
