/*	
 *	framm68.c
 *
 *	P/ECE M6800 Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2004 Naoyuki Sawa
 *
 *	* Sun Feb 01 06:23:00 JST 2004 Naoyuki Sawa
 *	- 쐬JnB
 */
#include "clip.h"
#include "clipm68i.h"	/*M6800G~[^p}N*/

/****************************************************************************
 *	M6800RÃCREAD/WRITEO֐
 ****************************************************************************/

/* M6800\(24oCg)̒ɃCzuĂ邱Ƃ肵܂B
 * oCiCAEgقȂꍇAoNؑւȂǂ̓ᏈKvȏꍇ́A
 * AvP[V`̊O֐pӂĂB
 */

#ifndef M6800_ASM	/****************************************************/

unsigned char
m6800_internal_read(M6800* m6800, unsigned short addr)
{
	return ((unsigned char*)(m6800 + 1))[addr];
}
void
m6800_internal_write(M6800* m6800, unsigned short addr, unsigned char data)
{
	((unsigned char*)(m6800 + 1))[addr] = data;
}

#else	/********************************************************************/

asm("
	.code
	.align 1
	.global m6800_internal_read
m6800_internal_read:
	add %r12, %r13
	xld.ub %r10, [%r12+24]
	ret
");
asm("
	.code
	.align 1
	.global m6800_internal_write
m6800_internal_write:
	add %r12, %r13
	xld.b [%r12+24], %r14
	ret
");

#endif	/********************************************************************/

/****************************************************************************
 *	
 ****************************************************************************/

#ifndef M6800_ASM

void
m6800_run(M6800* m6800, int cycle)
{
	const M6800OP* op;
	int code;
	int arg = 0; /* x} */

	CYCLE = cycle;
	while(!WAIT && CYCLE > 0) {
#ifdef M6800_TRACE
		m6800_dump(m6800);
#endif /*M6800_TRACE*/
		M6800TRACE("%04x: ", PC);
		FETCH(code);
		op = &m6800_op_table[code];
		switch(op->addr) {
		/*==== operand bytes=0 ====*/
		case M6800_INHERENT:
			break;
		/*==== operand bytes=1 ====*/
		case M6800_IMMEDIATE1:
		case M6800_DIRECT:
			FETCH(arg);
			break;
		case M6800_INDEXED:
			FETCH(arg);
			arg = (X  +       arg) & 0xffff;
			break;
		case M6800_RELATIVE:
			FETCH(arg);
			arg = (PC + (char)arg) & 0xffff;
			break;
		/*==== operand bytes=2 ====*/
		case M6800_IMMEDIATE2:
		case M6800_EXTENDED:
			FETCHW(arg);
			break;
#ifndef PIECE /* P/ECEł͍RAMŝ߃Jbg */
		default:
			DIE();
#endif /*PIECE*/
		}
		EXEC();
		M6800TRACE("\n");
	}
}

#endif /*M6800_ASM*/

/****************************************************************************
 *	
 ****************************************************************************/

