/*
 *	clipyaml.h
 *
 *	LibYAMLwp[֐
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2016 Naoyuki Sawa
 *
 *	* Sun Apr 24 21:05:43 JST 2016 Naoyuki Sawa
 *	- 1st [XB
 *	  LibYAMLɂ́ASAX`API(yaml_parser_scan(),yaml_parser_parse())ƁADOM`̂API(yaml_parser_load())L܂B
 *	  AvP[V̓śADOM`ŏyȂ̂łAۂ̏ALibYAMLDOMΉ͂܂gՂȂłB
 *	  yaml_document_t\̂ɃhLgŜǂݍނŁAf[^go[X֐͈ؗpӂĂȂłB
 *	  ŁALibYAMLɕsĂAf[^go[X邽߂̊֐AW[Ŏ鎖ɂ܂B
 *	  ֐dĺAgՂJSONp[T['parson'̊֐dlQlɂ܂B
 *	* Mon Apr 25 22:45:55 JST 2016 Naoyuki Sawa
 *	- clipyaml.cɁugpvǋL܂B
 *	* Fri Apr 29 21:34:57 JST 2016 Naoyuki Sawa
 *	- yaml_document_parse()ǉ܂B
 *	- upXɂǂݏov̊֐ǉ܂B
 *	  pX̏́Aclipprp.cW[PrpTbl_get_p()ƂقړłB
 *	- ugpvAupXɂǂݏov̊֐g悤ɕύX܂B
 *	* Sun May 01 23:11:51 JST 2016 Naoyuki Sawa
 *	- VtgJISɑΉ܂B
 *	  'USE_SJIS'V{`ēW[rhƁA̓t@C,͕,֐,֐߂lSăVtgJISň܂B
 *	  AvP[VUTF-8ӎKvؖȂ܂B
 *	  ڍׂ́Aclipyaml.c'#define USE_SJIS'`Ăӏ̃RgQƂĉB
 *	* Mon May 02 21:51:14 JST 2016 Naoyuki Sawa
 *	- clipunic.cɁuϊ(VtgJISUTF-8)vǉɔA܂łyaml_sjis_read_handler()̒ŁA
 *	  ShiftJisToUnicodeStr()Ucs2ToUtf8Str()gݍ킹čsĂϊAShiftJisToUtf8Str()ňxɕϊ悤ɕύX܂B
 *	* Sat May 07 21:48:49 JST 2016 Naoyuki Sawa
 *	- yaml_document_new(),yaml_document_dump()ǉ܂B
 *	  upXɂ鏑݁v̊֐ǉ܂B
 *	- yaml_sjis_read_handler()ɁA'\'̓Ꮘǉ܂B
 *	  ڍׂ́Ayaml_sjis_read_handler()̃RgQƂĉB
 *	- u݊֐̎gpvǋL܂B
 *	* Sun May 08 23:30:59 JST 2016 Naoyuki Sawa
 *	- obNXbV̕ϊAclipunic.cW[ŋzɂAʂ̏svɂȂ܂B
 *	  ̕ύXɔAyaml_sjis_read_handler()̓Ꮘ폜܂B
 *	- upXɂǂݏov̊֐́AnodeNULLwo悤ɂ܂B
 *	  nodeNULLw肳ꂽA[gm[h̑΃pX(=hLg̐΃pX)ƌȂ܂B
 *	  ܂nodeNULLw肷΁AupXɂ鏑݁vƓl̎go܂B
 *	- yaml_document_dump()̃VtgJISΉǂ܂B
 *	  ܂ł́A{ꕶ'\uXXXX'`ŏo͂Ă܂ĂAVtgJISł͂̂YAMLt@Cǂݐh肪L܂B
 *	  ̉ǂɂA{ꕶ̂܂܃VtgJISR[hŏo͂悤ɂȂ܂B
 *	* Tue May 10 22:06:16 JST 2016 Naoyuki Sawa
 *	- USE_YAML_SEHV{`ƁAclipyaml.cDIE()SāASEH_throw(YamlException)ɒu悤ɂ܂B
 *	  W[̊֐́AĂяõoO(sȂ)Ŏs鎖̂ŁAG[~łȂAĂяoŕߑo֗ƎvłB
 *	  Ⴆ΁Aȉ̂悤ɏĉB
 *	  double number;
 *	  SEH_try {
 *	    number = yaml_path_get_number_f(document, node, "foo.bar[%d]", index);
 *	  } SEH_catch(YamlException) {
 *	    number = 0.0; //ftHgl0.0ƂB
 *	  } SEH_end
 *	- USE_YAML_SEHV{`Ȃ΁A܂Œʂclipyaml.cDIE()͂̂܂܂ŁAG[~܂B
 *	  ɁAR[hTCYጸ鎖vs̏ꍇ́AUSE_YAML_SEHV{`ȂŉB
 *	* Fri May 13 21:43:38 JST 2016 Naoyuki Sawa
 *	- ܂strndupa()gĂӏAstrndupa()gȂ悤ɕύX܂B
 *	  ʂ͕ς܂B
 *	- strndupa()gȂ悤ɕύXŔAP/ECEłallocagp֐OŊ֐𔲂ƁAallocã`FCj댯L邩łB
 *	  (ڍׂclipalca.c̎QƂĉB)
 *	  L͓W[Ɍł͂Ȃ̂łAW[͓ɒʏ̎gpŗO𓊓鎖̂ŁAstrndupa()gȂ悤ɂ鎖ɂ܂B
 *	  'ʏ̎gpŗO𓊓鎖'Ƃ́A݂ȂL[ǂ݂ƂAɑ݂L[悤ƂG[AOŒʒm邩łB
 *	  ̗́A'Tue May 10 22:06:16 JST 2016'̃RgQƂĉB
 *	  ܂ł́Â悤ȗO⑫đsƁAP/ECEłallocã`FCjĂ܂Ă܂B
 *	  ́Al̏sĂAallocã`FCj鎖͗L܂B
 *	* Sat May 14 21:51:15 JST 2016 Naoyuki Sawa
 *	- yaml_document_dump()yaml_document_save()ɕύXAVKyaml_document_dump()쐬܂B
 *	  yaml_document_save()t@Co͗pAyaml_document_dump()o͗pƂȂ܂B
 *	- L̕ύXɔAu݊֐̎gpvύX܂B
 *	* Wed May 25 10:22:02 JST 2016 Naoyuki Sawa
 *	- yaml_path_get_node(),yaml_path_set_string()́AL['.','[',']'܂߂悤ɂȂ܂B
 *	  L['.','[',']'܂߂ɂ́AO'\'uăGXP[vĉB
 *	  <1> "foo.bar"   ufoovL[́ubarvL[Ɖ߂܂B
 *	        "foo\\.bar" ufoo.barvL[Ɖ߂܂B
 *	  <2> "foo[0]"    ufoovL[0Ԗڂ̗vfƉ߂܂B
 *	        "foo\\[0\\] ufoo[0]vL[Ɖ߂܂B
 *	        "foo\\[0]   ufoo[0]vL[Ɖ߂܂Bɂ́A']'̓GXP[vĂȂĂłBA']'IɃGXP[vՂƎv܂B
 *	  <3> "\.\.\"     u\vL[́u\vL[́u\vL[Ɖ߂܂B 2oCgڂ'\'܂ޑSp鎖mF邽߂̗łB
 *	        "\\\.\\\.\" u\.\.\vL[Ɖ߂܂B                   
 *	- ͕ύXʂȂ葽̂ŁAύXÕR[h̓RgAEgĎcĂ܂B
 *	  ύXÕR[hQƂꍇ́AÕA[JCuQƂĉB
 *	* Thu May 26 23:31:18 JST 2016 Naoyuki Sawa
 *	- clipyaml.cɁupX̃L[ɓꕶ܂܂ĂꍇɃGXP[vvǋL܂B
 *	* Tue Jun 21 21:15:30 JST 2016 Naoyuki Sawa
 *	- yaml_parser_load()G[ԂꍇAG[~,,O𓊓OɁAG[e\悤ɂ܂B
 *	  ܂ł́AW[ŃG[~,,O𓊓s炸AǂݍƂYAMLeLXĝǂɃG[L̂AtÂ炩łB
 *	  ́A\ꂽG[eɁAǂݍƂYAML̂ǂɃG[L̂AtՂȂ܂B
 *	- yaml_emitter_dump()G[ԂꍇAG[~,,O𓊓OɁAG[e\悤ɂ܂B
 *	  ۑ鎞ɃG[o鎖͂܂̂ŁA͂܂ł̂܂܂łɕsւ͖̂łAL̕ύXɍ킹ĈꉞύXĂɂ܂B
 *	* Wed Jun 22 22:49:18 JST 2016 Naoyuki Sawa
 *	- ^uWJ̓Ǝgǉ܂B
 *	  ڍׂ́AUSE_TAB`Ăӏ̃RgQƂĉB
 *	* Sun Aug 14 21:50:35 JST 2016 Naoyuki Sawa
 *	- yaml_path_get_node()O𓊓ɁAꎞIȕ񂪉ꂸɁA[NĂC܂B
 *	- yaml_path_set_string()O𓊓ɁAꎞIȕ񂪉ꂸɁA[NĂC܂B
 *	- yaml_path_set_number()O𓊓ɁAꎞIȕ񂪉ꂸɁA[NĂC܂B
 *	* Sun Sep 04 21:41:17 JST 2016 Naoyuki Sawa
 *	- 64rbgłł́AOR[hAhXłȂAӂFourCCʎqŕ\悤ɂ܂B
 *	  setjmp()/longjmp()̃p[^(int)łA(void*)(intptr_t)gȂłB
 *	  A32rbgł64rbgłƋʂɕύXĂǂ̂łÃR[hɉe鎖h߂ɁA32rbgł͂܂ŒʂƂ܂B
 */
#ifndef __CLIP_YAML_H__
#define __CLIP_YAML_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
#define USE_YAML_SEH	//̃V{`ƁAclipyaml.cDIE()SāASEH_throw(YamlException)ɒu܂B
#ifdef  USE_YAML_SEH
//{{2016/09/04ύX:64rbgłł́AOR[hAhXłȂAӂFourCCʎqŕ\悤ɂ܂B
//extern const char YamlException[1/*dummy*/];
//2016/09/04ύX:64rbgłł́AOR[hAhXłȂAӂFourCCʎqŕ\悤ɂ܂B
#ifndef _WIN64
extern const char YamlException[1/*dummy*/];		//32rbg
#else //_WIN64
#define YamlException MAKEFOURCC('Y','a','m','l')	//64rbg
#endif//_WIN64
//}}2016/09/04ύX:64rbgłł́AOR[hAhXłȂAӂFourCCʎqŕ\悤ɂ܂B
#endif//USE_YAML_SEH
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct yaml_sequence_s yaml_sequence_t;	//opaque datatype
typedef struct yaml_mapping_s yaml_mapping_t;	//opaque datatype
/****************************************************************************
 *	document
 ****************************************************************************/
yaml_document_t* yaml_document_new();						//
yaml_document_t* yaml_document_load(const char* filename);			//(yaml_document_t*)쐬֐
yaml_document_t* yaml_document_parse(const char* string);			//
void yaml_document_free(yaml_document_t* document);				//
void yaml_document_save(yaml_document_t* document, const char* filename);	//(yaml_document_t*)J֐
char* yaml_document_dump(yaml_document_t* document);				//
/*--------------------------------------------------------------------------*/
//yaml_node_t* yaml_document_get_root_node(yaml_document_t* document);	yaml.hŒ`Ă܂B
yaml_node_type_t yaml_document_get_root_type(yaml_document_t* document);
yaml_mapping_t* yaml_document_get_root_mapping(yaml_document_t* document);
yaml_sequence_t* yaml_document_get_root_sequence(yaml_document_t* document);
const char* yaml_document_get_root_string(yaml_document_t* document);
double yaml_document_get_root_number(yaml_document_t* document);
int yaml_document_get_root_boolean(yaml_document_t* document);
/****************************************************************************
 *	node
 ****************************************************************************/
yaml_node_type_t yaml_node_get_type(yaml_node_t* node);
yaml_mapping_t* yaml_node_get_mapping(yaml_node_t* node);
yaml_sequence_t* yaml_node_get_sequence(yaml_node_t* node);
const char* yaml_node_get_string(yaml_node_t* node);
double yaml_node_get_number(yaml_node_t* node);
int yaml_node_get_boolean(yaml_node_t* node);
/****************************************************************************
 *	mapping
 ****************************************************************************/
int yaml_mapping_get_count(yaml_document_t* document, yaml_mapping_t* mapping);	//֐͈'document'QƂ܂񂪁Å֐ƈ𑵂Ղ̂Ŏw肷鎖ɂ܂B
const char* yaml_mapping_get_key(yaml_document_t* document, yaml_mapping_t* mapping, int index);
/*--------------------------------------------------------------------------*/
yaml_node_t* yaml_mapping_get_node(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
yaml_node_type_t yaml_mapping_get_type(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
yaml_mapping_t* yaml_mapping_get_mapping(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
yaml_sequence_t* yaml_mapping_get_sequence(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
const char* yaml_mapping_get_string(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
double yaml_mapping_get_number(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
int yaml_mapping_get_boolean(yaml_document_t* document, yaml_mapping_t* mapping, const char* key);
/****************************************************************************
 *	sequence
 ****************************************************************************/
int yaml_sequence_get_count(yaml_document_t* document, yaml_sequence_t* sequence);	//֐͈'document'QƂ܂񂪁Å֐ƈ𑵂Ղ̂Ŏw肷鎖ɂ܂B
/*--------------------------------------------------------------------------*/
yaml_node_t* yaml_sequence_get_node(yaml_document_t* document, yaml_sequence_t* sequence, int index);
yaml_node_type_t yaml_sequence_get_type(yaml_document_t* document, yaml_sequence_t* sequence, int index);
yaml_mapping_t* yaml_sequence_get_mapping(yaml_document_t* document, yaml_sequence_t* sequence, int index);
yaml_sequence_t* yaml_sequence_get_sequence(yaml_document_t* document, yaml_sequence_t* sequence, int index);
const char* yaml_sequence_get_string(yaml_document_t* document, yaml_sequence_t* sequence, int index);
double yaml_sequence_get_number(yaml_document_t* document, yaml_sequence_t* sequence, int index);
int yaml_sequence_get_boolean(yaml_document_t* document, yaml_sequence_t* sequence, int index);
/****************************************************************************
 *	pXɂǂݏo	pathnodȇ΃pXłB		nodeNULLw肳ꂽA[gm[h̑΃pX(=hLg̐΃pX)ƌȂ܂B܂nodeNULLw肷΁AupXɂ鏑݁vƓl̎go܂B
 ****************************************************************************/
yaml_node_t* yaml_path_get_node_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
yaml_node_t* yaml_path_get_node_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
yaml_node_t* yaml_path_get_node(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
yaml_node_type_t yaml_path_get_type_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
yaml_node_type_t yaml_path_get_type_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
yaml_node_type_t yaml_path_get_type(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
yaml_mapping_t* yaml_path_get_mapping_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
yaml_mapping_t* yaml_path_get_mapping_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
yaml_mapping_t* yaml_path_get_mapping(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
yaml_sequence_t* yaml_path_get_sequence_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
yaml_sequence_t* yaml_path_get_sequence_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
yaml_sequence_t* yaml_path_get_sequence(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
const char* yaml_path_get_string_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
const char* yaml_path_get_string_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
const char* yaml_path_get_string(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
double yaml_path_get_number_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
double yaml_path_get_number_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
double yaml_path_get_number(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/*--------------------------------------------------------------------------*/
int yaml_path_get_boolean_f(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, ...);
int yaml_path_get_boolean_g(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* fmt, va_list ap);
int yaml_path_get_boolean(yaml_document_t* document, yaml_node_t* node/*NULL*/, const char* path);
/****************************************************************************
 *	pXɂ鏑	pathdocument̐΃pXłB	upXɂ鏑݁v̊֐ĂяoLibYAMLŃ̍Ċ蓖Ăs\L̂ŁA܂łɎ擾m[h̃|C^͖ɂȂ鎖ɒӂBupXɂ鏑݁v̊֐̌Ăяoׂł́AdocumentȊÕ|C^ێȂ]܂B]āupXɂ鏑݁v͏ɃhLg̐΃pXŎw肷dlƂBupXɂǂݏov̂悤Ƀm[h΃pXw͏oȂdlƂB
 ****************************************************************************/
void yaml_path_set_string_f(yaml_document_t* document, const char* value, const char* fmt, ...);
void yaml_path_set_string_g(yaml_document_t* document, const char* value, const char* fmt, va_list ap);
void yaml_path_set_string(yaml_document_t* document, const char* value, const char* path);
/*--------------------------------------------------------------------------*/
void yaml_path_set_number_f(yaml_document_t* document, double value, const char* fmt, ...);
void yaml_path_set_number_g(yaml_document_t* document, double value, const char* fmt, va_list ap);
void yaml_path_set_number(yaml_document_t* document, double value, const char* path);
/*--------------------------------------------------------------------------*/
void yaml_path_set_boolean_f(yaml_document_t* document, int value, const char* fmt, ...);
void yaml_path_set_boolean_g(yaml_document_t* document, int value, const char* fmt, va_list ap);
void yaml_path_set_boolean(yaml_document_t* document, int value, const char* path);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_YAML_H__
