
;  GNU C 2.7.2 [AL 1.1, MM 40] RISC NEWS-OS compiled by CC

;  Cc1 defaults:
;  -mmemcpy

;  Cc1 arguments (-G value = 0, Cpu = 3000, ISA = 1):
;  -quiet -dumpbase -O2 -Wall -o

gcc2_compiled.:
__gnu_compiled_c:
; APP

	.code
	.align	1
	.global	TinyLZ_init
TinyLZ_init:
	;// %r12 := tlz
	;// %r13 := p
	ld.w	[%r12]+, %r13		; tlz->p = p
	ld.w	%r13, 0			; memset(&tlz->len_pos, 0, sizeof(TinyLZ) - sizeof tlz->p)
	ext	memset@rm	; 	xjp.d	memset
	jp.d	memset@rl
	ld.w	%r14, 16		;						*delay*


	.code
	.align	1
	.global	TinyLZ_get
TinyLZ_get:
	pushn	%r0
	ld.w	%r4, [%r12]+		; %r4  := p = tlz->p
	ld.ub	%r5, [%r12]+		; %r5  := len_pos = tlz->len_pos
	;// %r4  := p
	;// %r5  := len_pos
	;// %r12 := &tlz->dic[0]
	sub	%r5, 16			; if((len_pos -= 16) < 0)
	jrge.d	3
	 ld.w	%r13, 1			; %r13 := 1					*delay*
	 ld.ub	%r5, [%r4]+		;   %r5  := len_pos = *p++
	;// %r4  := p
	;// %r5  := len_pos
	;// %r12 := &tlz->dic[0]
	;// %r13 := 1
	ext	0xf		; 	xand	%r9, %r5, 15		; %r9  := len_pos & 15
	and	%r9,%r5
	jreq.d	6			; if(len_pos & 15) ---------------------------+
	 ld.w	%r14, 14		; %r14 := 14                                  |	*delay*
	 xor	%r9, 15			;   %r9  := 15 - (len_pos & 15)               |
	 add	%r9, %r12		;   %r9  := &tlz->dic[15 - (len_pos & 15)]    |
	 ld.ub	%r0, [%r9]		;   %r0  := c = tlz->dic[15 - (len_pos & 15)] |
	 jp.d	3			; else                                        |
	  sub	%r12, 5			; %r12 := tlz <-------------------------------+	*delay*
	  ld.ub	%r0, [%r4]+		;   %r0  := c = *p++
	;// %r0  := c
	;// %r4  := p
	;// %r5  := len_pos
	;// %r12 := tlz
	;// %r13 := 1
	;// %r14 := 14
	ld.w	[%r12]+, %r4		; tlz->p = p
	ld.b	[%r12]+, %r5		; tlz->len = len_pos
	;// %r0  := c
	;// %r12 := &tlz->dic[0]
	;// %r13 := 1
	;// %r14 := 14
	ext	memcpy@rm	; 	xcall.d	memcpy			; memcpy(&tlz->dic[0], &tlz->dic[1], 14)
	call.d	memcpy@rl
	add	%r13, %r12		; %r13 := &tlz->dic[1]				*delay*
	;// %r0  := c
	;// %r10 := &tlz->dic[0]
	ext	0xe		; 	xld.b	[%r10+0xe], %r0		; tlz->dic[14] = c
	ld.b	[%r10],%r0
	ld.w	%r10, %r0		; return c
	popn	%r0
	ret


		.code
		.align		1
		.global		TinyLZ_uncompress
TinyLZ_uncompress:
		;// %r12 = dst
		;// %r13 = dst_max
		;// %r14 = src
		;// %r15 = src_len
		pushn		%r3
		ld.w		%r0, %r12			;// %r0  := dst
		ld.w		%r1, %r13			;// %r1  := dst_max
		ld.w		%r2, %r14			;// %r2  :=           src
		add		%r2, %r15			;// %r2  := src_end = src + src_len
	sub	%sp,0x5		; 		xsub		%sp, %sp, 20			;// %sp  := tlz
		;//
		ld.w		%r12, %sp			;// %r12 :=     tlz
	call.d	TinyLZ_init	; 		xcall.d		TinyLZ_init			;// TinyLZ_init(tlz, src)
		ld.w		%r13, %r14			;// %r13 :=          src		*delay*
		;//
		jp.d		TinyLZ_uncompress_NEXT
		ld.w		%r3, 0				;// %r3  := dst_len = 0			*delay*
		;//---------------------------------------------;//
		;// %r0  := dst
		;// %r1  := dst_max
		;// %r2  := src_end
		;// %r3  := dst_len
		;// %sp  := tlz
TinyLZ_uncompress_LOOP:
		ld.w		%r12, %sp			;// %r12 :=                tlz
	call.d	TinyLZ_get	; 		xcall.d		TinyLZ_get			;// %r10 := c = TinyLZ_get(tlz)
		add		%r3, 1				;// %r13 := dst_len++			*delay*
		;//
		cmp		%r3, %r1			;// if(dst_len++ < dst_max)
	;//{{2013/09/15C:ČuZqƈāAdst_len͊+1ĂB]āA(dst_len==dst_max)̏ꍇA܂obt@łB
	;//	jrge		TinyLZ_uncompress_NEXT
	;//2013/09/15C:ČuZqƈāAdst_len͊+1ĂB]āA(dst_len==dst_max)̏ꍇA܂obt@łB
		jrgt		TinyLZ_uncompress_NEXT
	;//}}2013/09/15C:ČuZqƈāAdst_len͊+1ĂB]āA(dst_len==dst_max)̏ꍇA܂obt@łB
		ld.b		[%r0]+, %r10			;//   *dst++ = c
TinyLZ_uncompress_NEXT:
	ld.w	%r4,[%sp+0x0]	; 		xld.w		%r4, [%sp+0x0]			;// %r4  := tlz->p
		cmp		%r4, %r2			;// if(tlz->p < src)			!INTERLOCK!
		jrult		TinyLZ_uncompress_LOOP		;//   goto LOOP
		;//
	ld.ub	%r4,[%sp+0x4]	; 		xld.ub		%r4, [%sp+0x4]			;// %r4  := tlz->len_pos
		cmp		%r4, 15				;// if(tlz->len_pos > 15)		!INTERLOCK!
		jrugt		TinyLZ_uncompress_LOOP		;//   goto LOOP
		;//---------------------------------------------;//
		ld.w		%r10, %r3			;// %r10 := dst_len
	add	%sp,0x5		; 		xadd		%sp, %sp, 20
		popn		%r3
		ret

; NO_APP
	.code
	.align	1
	.global	TinyLZc_init
TinyLZc_init:
;	.frame	%sp,16,$31		# vars= 0, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	ld.w	%r0,%r12
	ld.w	%r1,%r13
	ld.w	%r2,%r14
	ld.w	%r13,0x0
	ext	0x0		; 	xld.w	%r14,0x00000028		; 40
	ld.w	%r14,0x28
	ext	memset@rm	; 	xcall	memset
	call	memset@rl
	ld.w	[%r0],%r1	; 	xld.w	[%r0],%r1
	add	%r1,%r2
	ext	0x4		; 	xld.w	[%r0+0x4],%r1
	ld.w	[%r0],%r1
	popn	%r2
	ret
	.align	1
	.global	TinyLZc_put
TinyLZc_put:
;	.frame	%sp,64,$31		# vars= 44, regs= 5/0, args= 0, extra= 0
;	.mask	0x800f0000,-4
;	.fmask	0x00000000,0
	pushn	%r3
	sub	%sp,0xb		; 	xsub	%sp,%sp,44
	ld.w	%r5,%r12
	ld.w	%r6,%r13
	ld.w	%r0,%sp		; 	xadd	%r0,%sp,15
	add	%r0,0xf
	ld.w	%r1,[%r5]	; 	xld.w	%r1,[%r5]
	ext	0x4		; 	xld.w	%r15,[%r5+0x4]
	ld.w	%r15,[%r5]
	ext	0x8		; 	xld.ub	%r3,[%r5+0x8]
	ld.ub	%r3,[%r5]
	ext	0x9		; 	xld.ub	%r2,[%r5+0x9]
	ld.ub	%r2,[%r5]
	ld.w	%r12,%sp
	ext	0xa		; 	xadd	%r13,%r5,10
	add	%r13,%r5
	ext	0xf		; 	xadd	%r14,%r3,15
	add	%r14,%r3
	ld.w	[%sp+0x8],%r15	; 	xld.w	[%sp+0x20],%r15
	ld.w	[%sp+0x9],%r5	; 	xld.w	[%sp+0x24],%r5
	ld.w	[%sp+0xa],%r6	; 	xld.w	[%sp+0x28],%r6
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	ld.w	%r6,[%sp+0xa]	; 	xld.w	%r6,[%sp+0x28]
	ld.w	%r15,[%sp+0x8]	; 	xld.w	%r15,[%sp+0x20]
	ld.w	%r5,[%sp+0x9]	; 	xld.w	%r5,[%sp+0x24]
	cmp	%r6,0x3f	; 	xcmp	%r6,-1
	jreq	__LX73		; 	xjreq	__L73
	ld.w	%r10,%r0
	add	%r10,%r3
	ld.b	[%r10],%r6	; 	xld.b	[%r10],%r6
	add	%r3,0x1		; 	xadd	%r3,%r3,1
__LX73:				; __L73:
	cmp	%r6,0x3f	; 	xcmp	%r6,-1
	jreq	__LX116		; 	xjreq	__L116
	cmp	%r3,0x10	; 	xcmp	%r3,16
	jreq	__LX75		; 	xjreq	__L75
	jp	__LX109		; 	xjp	__L109
__LX116:				; __L116:
	cmp	%r3,0x0
	jreq	__LX74		; 	xjreq	__L74
__LX75:				; __L75:
	ld.w	%r14,0x0
	ld.w	%r4,%r14
	ld.w	%r13,0x1	; 	xld.w	%r13,0x00000001		; 1
__LX81:				; __L81:
	ld.w	%r12,0x0
	cmp	%r12,%r3
	jrge	__LX83		; 	xjrge	__L83
__LX85:				; __L85:
	ld.w	%r10,%r0
	sub	%r10,%r13
	ld.ub	%r11,[%r0]	; 	xld.ub	%r11,[%r0]
	ld.ub	%r10,[%r10]	; 	xld.ub	%r10,[%r10]
	cmp	%r11,%r10
	jrne	__LX83		; 	xjrne	__L83
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	add	%r12,0x1	; 	xadd	%r12,%r12,1
	cmp	%r12,%r3
	jrlt	__LX85		; 	xjrlt	__L85
__LX83:				; __L83:
	sub	%r0,%r12
	cmp	%r12,%r14
	jrle	__LX80		; 	xjrle	__L80
	ld.w	%r14,%r12
	ld.w	%r4,%r13
__LX80:				; __L80:
	add	%r13,0x1	; 	xadd	%r13,%r13,1
	cmp	%r13,0xf	; 	xcmp	%r13,15
	jrle	__LX81		; 	xjrle	__L81
	cmp	%r2,0x0
	jrne	__LX117		; 	xjrne	__L117
	cmp	%r14,0x0
	jrgt	__LX91		; 	xjrgt	__L91
	jp	__LX90		; 	xjp	__L90
__LX117:				; __L117:
	cmp	%r14,0x1	; 	xcmp	%r14,1
	jrle	__LX90		; 	xjrle	__L90
__LX91:				; __L91:
	cmp	%r2,0x0
	jreq	__LX93		; 	xjreq	__L93
	cmp	%r1,%r15
	jruge	__LX94		; 	xjruge	__L94
	ext	0x1		; 	xsub	%r10,%r2,1
	sub	%r10,%r2
	sll	%r10,0x4	; 	xsll	%r10,4
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX94:				; __L94:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	sub	%r0,%r2
__LX95:				; __L95:
	cmp	%r1,%r15
	jruge	__LX98		; 	xjruge	__L98
	ld.ub	%r10,[%r0]	; 	xld.ub	%r10,[%r0]
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX98:				; __L98:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	sub	%r2,0x1		; 	xsub	%r2,%r2,1
	jrne	__LX95		; 	xjrne	__L95
__LX93:				; __L93:
	cmp	%r1,%r15
	jruge	__LX100		; 	xjruge	__L100
	ext	0x1		; 	xsub	%r10,%r14,1
	sub	%r10,%r14
	sll	%r10,0x4	; 	xsll	%r10,4
	or	%r10,%r4
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX100:				; __L100:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	add	%r0,%r14
	sub	%r3,%r14
	jp	__LX73		; 	xjp	__L73
__LX90:				; __L90:
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	sub	%r3,0x1		; 	xsub	%r3,%r3,1
	add	%r2,0x1		; 	xadd	%r2,%r2,1
	cmp	%r2,0x10	; 	xcmp	%r2,16
	jrne	__LX73		; 	xjrne	__L73
	cmp	%r1,%r15
	jruge	__LX103		; 	xjruge	__L103
	ext	0x3		; 	xld.w	%r10,0x000000f0		; 240
	ld.w	%r10,0x30
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX103:				; __L103:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	sub	%r0,0x10	; 	xsub	%r0,%r0,16
__LX104:				; __L104:
	cmp	%r1,%r15
	jruge	__LX107		; 	xjruge	__L107
	ld.ub	%r10,[%r0]	; 	xld.ub	%r10,[%r0]
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX107:				; __L107:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	sub	%r2,0x1		; 	xsub	%r2,%r2,1
	jrne	__LX104		; 	xjrne	__L104
	jp	__LX73		; 	xjp	__L73
__LX74:				; __L74:
	cmp	%r6,0x3f	; 	xcmp	%r6,-1
	jrne	__LX109		; 	xjrne	__L109
	cmp	%r2,0x0
	jreq	__LX109		; 	xjreq	__L109
	cmp	%r1,%r15
	jruge	__LX110		; 	xjruge	__L110
	ext	0x1		; 	xsub	%r10,%r2,1
	sub	%r10,%r2
	sll	%r10,0x4	; 	xsll	%r10,4
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX110:				; __L110:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	sub	%r0,%r2
__LX111:				; __L111:
	cmp	%r1,%r15
	jruge	__LX114		; 	xjruge	__L114
	ld.ub	%r10,[%r0]	; 	xld.ub	%r10,[%r0]
	ld.b	[%r1],%r10	; 	xld.b	[%r1],%r10
__LX114:				; __L114:
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	add	%r0,0x1		; 	xadd	%r0,%r0,1
	sub	%r2,0x1		; 	xsub	%r2,%r2,1
	jrne	__LX111		; 	xjrne	__L111
__LX109:				; __L109:
	ld.w	[%r5],%r1	; 	xld.w	[%r5],%r1
	ext	0x8		; 	xld.b	[%r5+0x8],%r3
	ld.b	[%r5],%r3
	ext	0x9		; 	xld.b	[%r5+0x9],%r2
	ld.b	[%r5],%r2
	ext	0xa		; 	xadd	%r12,%r5,10
	add	%r12,%r5
	ext	0xf		; 	xsub	%r13,%r0,15
	sub	%r13,%r0
	ext	0xf		; 	xadd	%r14,%r3,15
	add	%r14,%r3
	ext	memcpy@rm	; 	xcall	memcpy
	call	memcpy@rl
	add	%sp,0xb		; 	xadd	%sp,%sp,44
	popn	%r3
	ret
	.align	1
	.global	TinyLZ_compress
TinyLZ_compress:
;	.frame	%sp,56,$31		# vars= 40, regs= 4/0, args= 0, extra= 0
;	.mask	0x80070000,-4
;	.fmask	0x00000000,0
	pushn	%r2
	sub	%sp,0xa		; 	xsub	%sp,%sp,40
	ld.w	%r10,%r13
	ld.w	%r0,%r15
	ld.w	%r1,%r14
	ld.w	%r2,%r12
	ld.w	%r12,%sp
	ld.w	%r13,%r2
	ld.w	%r14,%r10
	ext	TinyLZc_init@rm	; 	xcall	TinyLZc_init
	call	TinyLZc_init@rl
	jp	__LX123		; 	xjp	__L123
__LX121:				; __L121:
	ld.ub	%r13,[%r1]	; 	xld.ub	%r13,[%r1]
	add	%r1,0x1		; 	xadd	%r1,%r1,1
	ld.w	%r12,%sp
	ext	TinyLZc_put@rm	; 	xcall	TinyLZc_put
	call	TinyLZc_put@rl
__LX123:				; __L123:
	sub	%r0,0x1		; 	xsub	%r0,%r0,1
	cmp	%r0,0x3f	; 	xcmp	%r0,-1
	jrne	__LX121		; 	xjrne	__L121
	ld.w	%r12,%sp
	ld.w	%r13,0x3f	; 	xld.w	%r13,-1			; 0xffffffff
	ext	TinyLZc_put@rm	; 	xcall	TinyLZc_put
	call	TinyLZc_put@rl
	ld.w	%r10,[%sp+0x0]	; 	xld.w	%r10,[%sp]
	sub	%r10,%r2
	add	%sp,0xa		; 	xadd	%sp,%sp,40
	popn	%r2
	ret
