/*	
 *	cliptia.h
 *
 *	P/ECE TIA (Television Interface Adapter) Emulator
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Fri Mar 11 03:00:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_TIA_H__
#define __CLIP_TIA_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/****************************************************************************
 *
 ****************************************************************************/

/* TIA_ASMV{`ǂݍ݂܂B
 * TIA_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "cliptiaa.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef TIA_ASM
#endif /*PIECE*/

/****************************************************************************
 *	TIA (Television Interface Adapter)
 ****************************************************************************/

//			  ++-------------------------- horizontalblank
//			  || +++---------------------- actual TV picture width
//			  || |||   +------------------ vertical sync
//			  || |||   | ++--------------- vertical blank
//			  || |||   | || +++----------- actual TV picture height
//			  || |||   | || ||| ++-------- overscan
//			  || |||   | || ||| ||
#define TIA_CLOCK	((68+160)*(3+37+192+30)*60) /* 60 frames per second */
#define VCS_CLOCK	(TIA_CLOCK/3)	/* 3 clock counts per machine cycle */

#define TIABUFLEN 320 /* =16000/50 c 1[tick](=1/50[sec])̃Tv */

#ifdef PIECE
#define TIA_GRAYSCALE
#endif /*PIECE*/

/*  */
/* AZu[`璼ڎQƂĂ̂ŁAtH[}bgŒłB */
/* tH[}bgύXƂ́Aframtiaa.s̒`Ǐ]ĂB */
/*  */

typedef struct _TIAPLAYER {
	unsigned char position;			/* +0,1: 0..159 */
	unsigned char size;			/* +1,1: 0=x, 1=x_x, 2=x___x, 3=x_x_x, 4=x_______x, 5=XX, 6=x___x___x, 7=XXXX */
	unsigned char reflect;			/* +2,1: 0=no reflect, 1=reflect */
	unsigned char delay;			/* +3,1: 0=no delay, 1=delay */
	unsigned char graphics[2];		/* +4,2: 8bit graphics ([0]=no delay, [1]=delay) */
	unsigned char _resv[2];			/* +6,2: (\) */
} TIAPLAYER;					/* =8 */

typedef struct _TIAMISSILE {
	unsigned char position;			/* +0,1: 0..159 */
	unsigned char size;			/* +1,1: 0=1clock, 1=2clock, 2=4clock, 3=8clock */
	unsigned char reset;			/* +2,1: 0=no missile-player reset, 1=missile-player reset */
	unsigned char graphics;			/* +3,1: 0=disable, 1=enable */
} TIAMISSILE;					/* =4 */

typedef struct _TIABALL {
	unsigned char position;			/* +0,1: 0..159 */
	unsigned char size;			/* +1,1: 0=1clock, 1=2clock, 2=4clock, 3=8clock */
	unsigned char delay;			/* +2,1: 0=no delay, 1=delay */
	unsigned char graphics[2];		/* +3,2: 0=disable, 1=enable ([0]=no delay, [1]=delay) */
	unsigned char _resv[3];			/* +5,3: (\) */
} TIABALL;					/* =8 */

typedef struct _TIAPLAYFIELD {
	unsigned char reflect;			/* +0,1: 0=no relfect, 1=reflect */
	unsigned char _resv[3];			/* +1,3: (\) */
	unsigned int graphics;			/* +4,4: 20bit graphics */
} TIAPLAYFIELD;					/* =8 */

typedef struct _TIAAUDIO {
	unsigned char volume;			/* + 0,1: lowest:0..15:highest */
	unsigned char frequency;		/* + 1,1: frequency divider 1..32 */
	//
	unsigned char  polar;			/* + 2,1: 0:minus or 1:plus */
	unsigned char  div31;			/* + 3,1: 30..0, 0or13->pluse */
	         int   count;			/* + 4,4: frequency counter */
	unsigned short lfsr9;			/* + 8,2: 9-bit LFSR (tap=0,5) */
	unsigned char  lfsr5;			/* +10,1: 5-bit LFSR (tap=0,3) */
	unsigned char  lfsr4;			/* +11,1: 4-bit LFSR (tap=0,1) */
	//
	unsigned char _resv[4];			/* +12,4: (\) */
} TIAAUDIO;					/* =16 */

typedef struct _TIA {
	int now;				/* +  0, 4: TIANbNJE^ (N̒ʎZ) */
	int last_x;				/* +  4, 4: XVJnXW (0..(  68+160   -1)) */
	int last_y;				/* +  8, 4:             Y     (0..(3+37+192+30-1)) */
	int scan_x;				/* + 12, 4: ݂̑XW (0..(  68+160   -1)) */
	int scan_y;				/* + 16, 4:             Y     (0..(3+37+192+30-1)) */
	unsigned char clut[4];			/* + 20, 4: [0]=COLUP0, [1]=COLUP1, [2]=COLUPF, [3]=COLUBK */
	unsigned short collision;		/* + 24, 2: D01=M0-P1  (CXM0P [7]), D00=M0-P0  (CXM0P [6]) */
						/*          D03=M1-P0  (CXM1P [7]), D02=M1-P1  (CXM1P [6]) */
						/*          D05=P0-PF  (CXP0FB[7]), D04=P0-BL  (CXP0FB[6]) */
						/*          D07=P1-PF  (CXP1FB[7]), D06=P1-BL  (CXP1FB[6]) */
						/*          D09=M0-PF  (CXM0FB[7]), D08=M0-BL  (CXM0FB[6]) */
						/*          D11=M1-PF  (CXM1FB[7]), D10=M1-BL  (CXM1FB[6]) */
						/*          D13=BL-PF  (CXBLPF[7]), D12=unused (CXBLPF[6]) */
						/*          D15=P0-P1  (CXPPMM[7]), D14=M0-M1  (CXPPMM[6]) */
	unsigned char i4;			/* + 26, 1: INPT4̓̓|[g (1=Hi=Off,0=Lo=On) */
	unsigned char i5;			/* + 27, 1: INPT5̓̓|[g (1=Hi=Off,0=Lo=On) */
	unsigned char* vbuff/*[160*192]*/;	/* + 28, 4: zʃobt@ (O`Atia_reset()Ŏw) */

	unsigned char _resv[24];		/* + 32,24: (\) */

	/*{{movable objects*/
	TIAPLAYER player[2];			/* + 56,16: Player0, Player1 */
	TIAMISSILE missile[2];			/* + 72, 8: Missile0, Missile1 */
	TIABALL ball;				/* + 80, 8: Ball */
	TIAPLAYFIELD playfield;			/* + 88, 8: Playfield */
	/*}}movable objects*/

	/*{{AUDIO==========*/
	TIAAUDIO audio[2];			/* + 96,32: Audio circuits */
	/*}}AUDIO==========*/

	/*{{݃WX^*/
	unsigned char VSYNC;			// +128, 1: $00  VSYNC   0000 00x0  vertical sync set-clear
	unsigned char VBLANK;			// +129, 1: $01  VBLANK  xx00 00x0  vertical blank set-clear
	//unsigned char WSYNC;			//          $02  WSYNC   ---- ----  wait for leading edge of horizontal blank
	//unsigned char RSYNC;			//          $03  RSYNC   ---- ----  reset horizontal sync counter
	unsigned char NUSIZ0;			// +130, 1: $04  NUSIZ0  00xx 0xxx  number-size player-missile 0
	unsigned char NUSIZ1;			// +131, 1: $05  NUSIZ1  00xx 0xxx  number-size player-missile 1
	unsigned char COLUP0;			// +132, 1: $06  COLUP0  xxxx xxx0  color-lum player 0
	unsigned char COLUP1;			// +133, 1: $07  COLUP1  xxxx xxx0  color-lum player 1
	unsigned char COLUPF;			// +134, 1: $08  COLUPF  xxxx xxx0  color-lum playfield
	unsigned char COLUBK;			// +135, 1: $09  COLUBK  xxxx xxx0  color-lum background
	unsigned char CTRLPF;			// +136, 1: $0A  CTRLPF  00xx 0xxx  control playfield ball size & collisions
	unsigned char REFP0;			// +137, 1: $0B  REFP0   0000 x000  reflect player 0
	unsigned char REFP1;			// +138, 1: $0C  REFP1   0000 x000  reflect player 1
	unsigned char PF0;			// +139, 1: $0D  PF0     xxxx 0000  playfield register byte 0
	unsigned char PF1;			// +140, 1: $0E  PF1     xxxx xxxx  playfield register byte 1
	unsigned char PF2;			// +141, 1: $0F  PF2     xxxx xxxx  playfield register byte 2
	//unsigned char RESP0;			//          $10  RESP0   ---- ----  reset player 0
	//unsigned char RESP1;			//          $11  RESP1   ---- ----  reset player 1
	//unsigned char RESM0;			//          $12  RESM0   ---- ----  reset missile 0
	//unsigned char RESM1;			//          $13  RESM1   ---- ----  reset missile 1
	//unsigned char RESBL;			//          $14  RESBL   ---- ----  reset ball
	unsigned char AUDC0;			// +142, 1: $15  AUDC0   0000 xxxx  audio control 0
	unsigned char AUDC1;			// +143, 1: $16  AUDC1   0000 xxxx  audio control 1
	unsigned char AUDF0;			// +144, 1: $17  AUDF0   000x xxxx  audio frequency 0
	unsigned char AUDF1;			// +145, 1: $18  AUDF1   000x xxxx  audio frequency 1
	unsigned char AUDV0;			// +146, 1: $19  AUDV0   0000 xxxx  audio volume 0
	unsigned char AUDV1;			// +147, 1: $1A  AUDV1   0000 xxxx  audio volume 1
	//unsigned char GRP0;			//          $1B  GRP0    xxxx xxxx  graphics player 0
	//unsigned char GRP1;			//          $1C  GRP1    xxxx xxxx  graphics player 1
	unsigned char ENAM0;			// +148, 1: $1D  ENAM0   0000 00x0  graphics (enable) missile 0
	unsigned char ENAM1;			// +149, 1: $1E  ENAM1   0000 00x0  graphics (enable) missile 1
	unsigned char ENABL;			// +150, 1: $1F  ENABL   0000 00x0  graphics (enable) ball
	unsigned char HMP0;			// +151, 1: $20  HMP0    xxxx 0000  horizontal motion player 0
	unsigned char HMP1;			// +152, 1: $21  HMP1    xxxx 0000  horizontal motion player 1
	unsigned char HMM0;			// +153, 1: $22  HMM0    xxxx 0000  horizontal motion missile 0
	unsigned char HMM1;			// +154, 1: $23  HMM1    xxxx 0000  horizontal motion missile 1
	unsigned char HMBL;			// +155, 1: $24  HMBL    xxxx 0000  horizontal motion ball
	//unsigned char VDELP0;			//          $25  VDELP0  0000 000x  vertical delay player 0
	//unsigned char VDELP1;			//          $26  VDELP1  0000 000x  vertical delay player 1
	//unsigned char VDELBL;			//          $27  VDELBL  0000 000x  vertical delay ball
	unsigned char RESMP0;			// +156, 1: $28  RESMP0  0000 00x0  reset missile 0 to player 0
	unsigned char RESMP1;			// +157, 1: $29  RESMP1  0000 00x0  reset missile 1 to player 1
	//unsigned char HMOVE;			//          $2A  HMOVE   ---- ----  apply horizontal motion
	//unsigned char HMCLR;			//          $2B  HMCLR   ---- ----  clear horizontal motion registers
	//unsigned char CXCLR;			//          $2C  CXCLR   ---- ----  clear collision latches
	/*}}݃WX^*/

	/*{{ǂݏoWX^*/
	//unsigned char CXM0P;			//          $0   CXM0P   xx00 0000  read collision M0-P1 M0-P0
	//unsigned char CXM1P;			//          $1   CXM1P   xx00 0000  read collision M1-P0 M1-P1
	//unsigned char CXP0FB;			//          $2   CXP0FB  xx00 0000  read collision P0-PF P0-BL
	//unsigned char CXP1FB;			//          $3   CXP1FB  xx00 0000  read collision P1-PF P1-BL
	//unsigned char CXM0FB;			//          $4   CXM0FB  xx00 0000  read collision M0-PF M0-BL
	//unsigned char CXM1FB;			//          $5   CXM1FB  xx00 0000  read collision M1-PF M1-BL
	//unsigned char CXBLPF;			//          $6   CXBLPF  x000 0000  read collision BL-PF unused
	//unsigned char CXPPMM;			//          $7   CXPPMM  xx00 0000  read collision P0-P1 M0-M1
	unsigned char INPT0;			// +158, 1: $8   INPT0   x000 0000  read pot port
	unsigned char INPT1;			// +159, 1: $9   INPT1   x000 0000  read pot port
	unsigned char INPT2;			// +160, 1: $A   INPT2   x000 0000  read pot port
	unsigned char INPT3;			// +161, 1: $B   INPT3   x000 0000  read pot port
	unsigned char INPT4;			// +162, 1: $C   INPT4   x000 0000  read input
	unsigned char INPT5;			// +163, 1: $D   INPT5   x000 0000  read input
	/*}}ǂݏoWX^*/
} TIA;						// =164
#define SIZEOF_TIA				    164 /* tia_reset()ɃTCY܂ */

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

extern TIA tia; /* TIA core */

#ifdef TIA_GRAYSCALE
extern const unsigned char tia_grayscale_table[16/*Color*/ * 8/*Luminosity*/];
#else /*TIA_GRAYSCALE*/
extern const unsigned char tia_color_table[16/*Color*/ * 8/*Luminosity*/][3/*R,G,B*/];
#endif /*TIA_GRAYSCALE*/

extern const unsigned char tia_div3_table[256];
extern const unsigned char tia_priority_table[2][1 << 6];
extern const unsigned short tia_collision_table[1 << 6];

extern int (*tia_write_table[0x2c+1])(int data);
extern int (*tia_read_table[0xf+1])();

/****************************************************************************
 *	֐
 ****************************************************************************/

void tia_scan_progress(int now);
void tia_partial_update();
void tia_line_update(unsigned y, unsigned x1, unsigned x2);

void tia_volume_shift(short wbuff[/*TIABUFLEN*/]);			/* 30KHz=3.58MHz/114, 10KHz=3.58MHz/3/114=1.19MHz/114 */
void tia_audio_mix0(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/*                                               1 -> */
void tia_audio_mix1(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse ----------------> Poly4 output -> */
void tia_audio_mix2(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Div31 pulse -> Poly4 output -> */
void tia_audio_mix3(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Poly5 pulse -> Poly4 output -> */
void tia_audio_mix4(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse ----------------> Polar toggle -> */
//void tia_audio_mix5(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse ----------------> Polar toggle -> */ /* 4Ɠ */
void tia_audio_mix6(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Div31 pulse -> Polar toggle -> */ /* 6ËႢ́A30KHz/10KHẑ */
void tia_audio_mix7(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Poly5 pulse -> Polar toggle -> */ /* 7F̈Ⴂ́A30KHz/10KHẑ */
void tia_audio_mix8(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse ----------------> Poly9 output -> */
void tia_audio_mix9(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse ----------------> Poly5 output -> */
void tia_audio_mixA(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Div31 pulse -> Poly5 output -> */
//void tia_audio_mixB(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 30KHz/Freq pulse -> Poly5 pulse -> Poly5 output -> */ /* 0Ɠ (Poly5[0]=1Poly5[0]ŏo͒lXV̂ŁAʓI1Œ) */
void tia_audio_mixC(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 10KHz/Freq pulse ----------------> Polar toggle -> */ /* 4C̈Ⴂ́A30KHz/10KHẑ */
//void tia_audio_mixD(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 10KHz/Freq pulse ----------------> Polar toggle -> */ /* CƓ */
void tia_audio_mixE(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 10KHz/Freq pulse -> Div31 pulse -> Polar toggle -> */ /* 6ËႢ́A30KHz/10KHẑ */
void tia_audio_mixF(TIAAUDIO* audio, short wbuff[/*TIABUFLEN*/]);	/* 10KHz/Freq pulse -> Poly5 pulse -> Polar toggle -> */ /* 7F̈Ⴂ́A30KHz/10KHẑ */

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* TIARAZbg܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 *	vbuff		zʃobt@B(160x192sNZ)
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́ATIAZbgsꍇɁAKvɉČĂяoĂB
 */
void tia_reset(int now, unsigned char vbuff[/*160*192*/]);

/* TIA1oCg݂܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 *	addr		ރAhXB
 *	data		ރf[^B
 * [out]
 *	߂l		WSYNCւ̏ݎɁA~TCNԂ܂B(VCS_CLOCKP)
 *			ȊÕWX^ւ̏ݎ́A0Ԃ܂B
 */
int tia_write(int now, int addr, int data);

/* PPU1oCgǂݏo܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 *	addr		ǂݏoAhXB
 * [out]
 *	߂l		ǂݏof[^B
 */
int tia_read(int now, int addr);

/* Latched Input Ports̓͏Ԃݒ肵܂B
 * [in]
 *	i4		I4|[g̓͏ԁB(Ă0AĂ1)
 *	i5		I5|[g̓͏ԁB(Ă0AĂ1)
 * [note]
 *	* Latched Input Ports̓͏Ԃ́A_ł邱ƂɒӂĂB
 */
void tia_set_i4_i5(int i4, int i5);

/* o̓TvO[g=SPEAKER_OUTPUT[Hz]ŁA320Tṽ~LVOs܂B
 * [in]
 *	wbuff		o̓Tvobt@B
 */
void tia_mix(short wbuff[/*TIABUFLEN*/]);

#ifdef TIA_GRAYSCALE
/* 160x192x16~OCXP[A128x88x16~OCXP[֏kRs[܂B
 * [in]
 *	src		160x192x16~OCXP[ʃobt@B
 *	dst		128x 88x16~OCXP[ʃobt@B
 *
 * [note]
 *	* srcdst͓AhXwĂĂ\܂B
 *	  ŏII128x88̉ʃC[WKvȂ΁A160x192128x88̉ʃobt@ʉāA
 *	  ߖł܂B
 */
void tia_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*160*192*/]);
#endif TIA_GRAYSCALE

/****************************************************************************
 *	PIA (Peripheral Interface Adaptor) (MOS6532, RIOTƂĂ΂܂)
 ****************************************************************************/

#define PIA_CLOCK	VCS_CLOCK

/* {́ATIAPIA͊Sɕʂ́AꂼƗLSIłB
 * ATARI VCSɂẮATIAPIAAƂdvȍ\iłB
 * PIA͋K͂̂ŁATIAƓW[Ɋ܂߂邱Ƃɂ܂B
 */
typedef struct _PIA {
	/*{{WX^*/
	unsigned char SWCHA;			// $280  SWCHA   Port A; input or output (read or write)
	unsigned char SWACNT;			// $281  SWACNT  Port A DDR; 0 = input, 1 = output
	unsigned char SWCHB;			// $282  SWCHB   Port B; console switches (read only)
	unsigned char SWBCNT;			// $283  SWBCNT  Port B DDR; hardwired as input
	//unsigned char INTIM;			// $284  INTIM   Timer output (read only)
	//unsigned char TIM1T;			// $294  TIM1T   set    1 clock interval (838   nsec/interval)
	//unsigned char TIM8T;			// $295  TIM8T   set    8 clock interval (  6.7 usec/interval)
	//unsigned char TIM64T;			// $296  TIM64T  set   64 clock interval ( 53.6 usec/interval)
	//unsigned char T1024T;			// $297  T1024T  set 1024 clock interval (858.2 usec/interval)
	/*}}WX^*/

	int now;		/* OANZX̃TCNJE^L */
	int shift;		/* INTIMǂݏõ^C}JE^EVtg */
	unsigned timer;		/* ^C}JE^ (VCS_CLOCKPʃ_EJE^) */
} PIA;

extern PIA pia;

/* PIARAZbg܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 * [note]
 *	* AvP[VvÓAȂƂŏɈxÅ֐ĂяoĂB
 *	  ̌́APIAZbgsꍇɁAKvɉČĂяoĂB
 */
void pia_reset(int now);

/* PIA1oCg݂܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 *	addr		ރAhXB
 *	data		ރf[^B
 */
void pia_write(int now, int addr, int data);

/* PPU1oCgǂݏo܂B
 * [in]
 *	now		TCNJE^B(VCS_CLOCKP)
 *	addr		ǂݏoAhXB
 * [out]
 *	߂l		ǂݏof[^B
 */
int pia_read(int now, int addr);

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_TIA_H__*/
