/*
 *	cliptapx.c
 *
 *	TAP~LT[
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2017 Naoyuki Sawa
 *
 *	* Fri Sep 18 22:38:30 JST 2015 Naoyuki Sawa
 *	- 1st [XB
 *	* Sun Feb 14 21:59:00 JST 2016 Naoyuki Sawa
 *	- ~LT[`l̏A܂ł32łAUINT8_MAX(=255)ɑ₵܂B
 *	  ܂Ń~LT[`l̏32ŔATapMxr_GetAtt()̈̃~LT[`l}XNint1Ŏw肵ĂłB
 *	  ̕ύXɔAint1Ń~LT[`l}XNw肷鎖͏oȂȂA~LT[`l}XNrbgzŎw肷悤ɕύX܂B
 *	- ύXÕR[h̓RgAEgĎcĂ܂B
 *	  ύXÕR[hQƂKvꍇ́AÕA[JCuQƂĉB
 *	* Mon Mar 27 22:39:32 JST 2017 Naoyuki Sawa
 *	- TapMxr_GetAtt()ɂāApMask̍Ō̗̎vf܂œǂƂĂ܂\LoOC܂B
 *	  C(/clip/cliptapx.c)ł͔z̈vf܂œǂłʕیO鎖͂܂̂ŁA܂ŋCt܂łB
 *	  AASYC#(/clip/libclip.net/cliptapx.cs)쐬āAIndexOutOfRangeException̂ŋCt܂B
 */
#include "clip.h"
/*****************************************************************************
 *	[J֐錾
 *****************************************************************************/
static void TapMxrCh_Exec(ST_TapMxr* pTapMxr, int iMxrCh, int iElapTime);
/*****************************************************************************
 *	O[o֐
 *****************************************************************************/
//~LT[𓮓Iɍ쐬B
ST_TapMxr* TapMxr_New(int nMxrCh) {
	ST_TapMxr* pTapMxr;
	if(((nMxrCh < 1) || (nMxrCh > UINT8_MAX))) { DIE(); }	//~LT[`l͈͊OȂ΃G[
	//mۂB
	pTapMxr = malloc(sizeof(ST_TapMxr) +		//~LT[
		(sizeof(ST_TapMxrCh) * nMxrCh));	//~LT[`l
	if(!pTapMxr) { DIE(); }
	//~LT[ÓIɏB
	TapMxr_Init(pTapMxr, nMxrCh);
	return pTapMxr;
}
/*---------------------------------------------------------------------------*/
//~LT[ÓIɏB
void TapMxr_Init(ST_TapMxr* pTapMxr, int nMxrCh) {
	int iMxrCh;
	if(((nMxrCh < 1) || (nMxrCh > UINT8_MAX))) { DIE(); }	//~LT[`l͈͊OȂ΃G[
	//~LT[`li[B
	pTapMxr->nMxrCh = nMxrCh;
	//~LT[`lNAB
	for(iMxrCh = 0; iMxrCh < pTapMxr->nMxrCh; iMxrCh++) {
		ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
		memset(pMxrCh, 0, sizeof(ST_TapMxrCh));
	}
}
/*---------------------------------------------------------------------------*/
//Iɍ쐬~LT[JB
void TapMxr_Free(ST_TapMxr* pTapMxr) {
	free(pTapMxr);
}
/*---------------------------------------------------------------------------*/
//~LT[sB
// - AvP[VCӂ̃ReLXgŌĂяo\L̂ŁAr䂪KvłB
//   荞ݏĂяoꍇ͔r䂪svłA^C}Ǘ̎(TimMgr_Exec())ĂяogL蓾邩łB
void TapMxr_Exec(ST_TapMxr* pTapMxr, int iElapTime) {
	int iMxrCh;
	if(iElapTime <    0) { iElapTime =    0; }	//oߎԂ0bȂ΁A0bɕ␳B
	if(iElapTime > 1000) { iElapTime = 1000; }	//oߎԂ1b߂Ȃ΁A1bɕ␳B
ENTER_CS;
	//~LT[`lsB
	for(iMxrCh = 0; iMxrCh < pTapMxr->nMxrCh; iMxrCh++) {
		TapMxrCh_Exec(pTapMxr, iMxrCh, iElapTime);
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//~LT[`ľʕωJn܂B
// - p[^̎dlCntMgr_SetVal()ƓlłBCntMgr_SetVal()̐QƂĉB
// - AvP[VCӂ̃ReLXgŌĂяo\L̂ŁAr䂪KvłB
void TapMxrCh_SetAtt(ST_TapMxr* pTapMxr, int iMxrCh, int iAttTo, int iRate, int iScale) {
	//~LT[`l擾B
	ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
ENTER_CS;
	//p[^łAVωJnBp[^Ȃ΁A݂̕ωpB
	if((pMxrCh->iAttTo != iAttTo) || (pMxrCh->iRate != iRate) || (pMxrCh->iScale != iScale)) {
		//p[^i[B
		pMxrCh->iAttTo   = iAttTo;	//ڕW
		pMxrCh->iRate    = iRate;	//ʕωx(q)
		pMxrCh->iScale   = iScale;	//ʕωx()
		pMxrCh->iErrTerm = 0;		//덷
		//ʕωx̃p[^Еł0(=f)Ȃ΁AڕWʂ݌ʂ֑fB
		if(!iRate || !iScale) { pMxrCh->iAttNow = iAttTo; }
	}
LEAVE_CS;
}
/*---------------------------------------------------------------------------*/
//iMxrChMaskŎw肵~LT[`l(0`)́A݌ʂ̍v߂B
// - AvP[VCӂ̃ReLXgŌĂяo\L܂A֐ł̔r͕svłB
//   ֐̎sɊ荞݂|āAr猸ʂωĂAĔ̈Ⴂ͐ȂłB
//   AAȌqKvɂȂꍇ́ArǉĉB
int TapMxr_GetAtt(ST_TapMxr* pTapMxr, const void* aMxrChMask/*int[(nMxrCh+31)/32]*/) {
	//vʂ0ƂĂB
	int iAttSum = 0;
#if 0
	//VvȎBe͔ՂłA~LT[`l}XNS`lɑ΂1rbg̂ŒxłB
	//e~LT[`lɂāc
	int iMxrCh;
	for(iMxrCh = 0; iMxrCh < pTapMxr->nMxrCh; iMxrCh++) {
		//~LT[`l}XÑrbgźÃ~LT[`lɑΉrbgZbgĂc
		if(bitarray_lsb1st_get(aMxrChMask, iMxrCh, 1)) {
			//vʂɁÃ~LT[`ľ݌ʂZB
			ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
			iAttSum += pMxrCh->iAttNow;	//iAttNow8bittB[hȂ̂ŁAv32bit𒴂鋰͖B
		}
	}
#else	//VvȎłłʂ͓ɂȂ܂B
	//Be┻hłA0AĂrbgɑΉ`l܂Ƃ߂Ĕ΂̂őłB
	const unsigned* pMask = aMxrChMask;
	unsigned uMask = 0;	//~LT[`l}XÑrbgzA32rbgoϐ
	int      nBits = 0;	//32rbgPʂŎo~LT[`l}XŃAcrbg
	//e~LT[`lɂāc
	int iMxrCh = 0;
    //{{2017/03/27C:TapMxr_GetAtt()ɂāApMask̍Ō̗̎vf܂œǂƂĂ܂\LoOC܂B
    //	while(iMxrCh < pTapMxr->nMxrCh) {
    //		//o~LT[`l}XNɁAZbgĂrbg܂cĂ΁c
    //		if(uMask) {
    //			//~LT[`l}XÑrbgźÃ~LT[`lɑΉrbgZbgĂc
    //			if(uMask & 1) {
    //				//vʂɁÃ~LT[`ľ݌ʂZB
    //				ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
    //				iAttSum += pMxrCh->iAttNow;	//iAttNow8bittB[hȂ̂ŁAv32bit𒴂鋰͖B
    //			}
    //			iMxrCh++;	//~LT[`lԍ֐i߂B
    //			uMask >>= 1;	//32rbgPʂŎo~LT[`l}XNA1rbgVtgAEgB
    //			nBits--;	//1rbgVtgAEgAcrbg炷B
    //		//o~LT[`l}XNɁAZbgĂrbgcĂȂ΁c
    //		} else {
    //			iMxrCh += nBits;	//c(NAĂ)rbgA~LT[`lԍi߂B
    //			uMask = *pMask++;	//~LT[`l}XÑrbgźA32rbgoB
    //			nBits = 32;		//o~LT[`l}XŃAcrbg32rbgɂB
    //		}
    //	}
    //2017/03/27C:TapMxr_GetAtt()ɂāApMask̍Ō̗̎vf܂œǂƂĂ܂\LoOC܂B
	for(;;) {
		//o~LT[`l}XNɁAZbgĂrbg܂cĂ΁c
		if(uMask) {
			//~LT[`l}XÑrbgźÃ~LT[`lɑΉrbgZbgĂc
			if(uMask & 1) {
				//vʂɁÃ~LT[`ľ݌ʂZB
				ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
				iAttSum += pMxrCh->iAttNow;		//iAttNow8bittB[hȂ̂ŁAv32bit𒴂鋰͖B
			}
			iMxrCh++;					//~LT[`lԍ֐i߂B
			if(iMxrCh >= pTapMxr->nMxrCh) { break; }	//SẴ~LT[`lA[v𔲂B
			uMask >>= 1;					//32rbgPʂŎo~LT[`l}XNA1rbgVtgAEgB
			nBits--;					//1rbgVtgAEgAcrbg炷B
		//o~LT[`l}XNɁAZbgĂrbgcĂȂ΁c
		} else {
			iMxrCh += nBits;				//c(NAĂ)rbgA~LT[`lԍi߂B
			if(iMxrCh >= pTapMxr->nMxrCh) { break; }	//SẴ~LT[`lA[v𔲂B
			uMask = *pMask++;				//~LT[`l}XÑrbgźA32rbgoB
			nBits = 32;					//o~LT[`l}XŃAcrbg32rbgɂB
		}
	}
    //}}2017/03/27C:TapMxr_GetAtt()ɂāApMask̍Ō̗̎vf܂œǂƂĂ܂\LoOC܂B
#endif
	//vʂԂB
	return iAttSum;
}
/*---------------------------------------------------------------------------*/
//~LT[`l擾B
ST_TapMxrCh* TapMxr_GetMxrCh(ST_TapMxr* pTapMxr, int iMxrCh) {
	if((unsigned)iMxrCh >= (unsigned)pTapMxr->nMxrCh) { DIE(); }	//~LT[`lԍ͈͊OȂ΃G[
	return (ST_TapMxrCh*)(pTapMxr + 1) + iMxrCh;
}
/*****************************************************************************
 *	[J֐
 *****************************************************************************/
//~LT[`lsB
// - TapMxr_Exec()ĂяôŁA֐ł͔r䂪svłB
static void TapMxrCh_Exec(ST_TapMxr* pTapMxr, int iMxrCh, int iElapTime) {
	//~LT[`l擾B
	ST_TapMxrCh* pMxrCh = TapMxr_GetMxrCh(pTapMxr, iMxrCh);
	//݌ʂƖڕWʂ擾B
	int iAttNow = pMxrCh->iAttNow;	//݌
	int iAttTo  = pMxrCh->iAttTo;	//ڕW
	//݌ʂƖڕWʂقȂȂ(=ωȂ)c
	if(iAttNow != iAttTo) {
		//덷(iRate~oߎ)ZAiScaleŏčωʂ߂B
		div_t d = div(
			pMxrCh->iErrTerm + (pMxrCh->iRate * iElapTime),
			pMxrCh->iScale);
		//ωʂcA덷ɏ߂B
		pMxrCh->iErrTerm = d.rem;
		//ωʂA݌ʂɔfB
		if(iAttNow < iAttTo) { if((iAttNow += d.quot) > iAttTo) { iAttNow = iAttTo; } }	//ω̏ꍇ
		else                 { if((iAttNow -= d.quot) < iAttTo) { iAttNow = iAttTo; } }	//ω̏ꍇ
		//݌ʂ߂B
		pMxrCh->iAttNow = iAttNow;
	}
}
