/*
 *	clippsrl.h
 *
 *	p`XQ[p[V~[^
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2017 Naoyuki Sawa
 *
 *	* Mon Jan 30 21:41:16 JST 2017 Naoyuki Sawa
 *	- 1st [XB
 *	* Tue Jan 31 22:45:54 JST 2017 Naoyuki Sawa
 *	- PslRelCh_Intr()́u(ZTo)ṽZToɁAZToJE^̍ŏLlłAĉֈڍsȂ悤ɏC܂B
 *	  CŔAȂƁA[]Jn̏̓(ZTo)ɃZToɁAԈčĉֈڍs肪邩łB
 *	  ȂȂ΁A[]Jn̏ɓ(ZTo)ֈڍs_ł̓ZT܂ł͕̋słAɃZToĂ킾łB
 *	* Wed Feb 01 21:56:57 JST 2017 Naoyuki Sawa
 *	- PslRelCh_Intr()ɂđS㎥̏o̓p^[ԈႦĂ̂C܂B
 *	  CÓufOut = -1vƂĂāAPslRel_Intr()ɂđ̃[̏o̓p^[ƃ}[WۂɁÃ[̏o̓p^[j󂵂Ă܂Ă܂B
 *	  ĆufOut = (1<<0)|(1<<1)|(1<<2)|(1<<3)vƂāÃ[̏o̓p^[j󂵂ĂȂ悤ɂȂ܂B
 */
#ifndef __CLIP_PSRL_H__
#define __CLIP_PSRL_H__
#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus
#ifndef __RENESAS__
#define PslRel_UseVirtualReel	//̃V{`ƁA(ZToς)ƒ~ȊȌԂłAItZbgƊGʒuǐՂ܂Bz[Ƃĕ`悷ꍇɁÃV{`ĉB
#endif//__RENESAS__
/****************************************************************************
 *	萔
 ****************************************************************************/
//ST_PslRelCh.iStat							//Ӗ			l			ڍs1		ڍs2				ZTo
#define PslRelCh_Stat_Off		0				//㎥					]JnAccel						ZTosȂ
#define PslRelCh_Stat_Accel		1				//		ĉ܂		Nd							ZTosȂ
#define PslRelCh_Stat_Nd		2				//		ZTo		ZToCruise	莞ԃZToAccel		ZTos		N.D.not detected̗łB
#define PslRelCh_Stat_Cruise		3				//		ZToς		~JnBrake	莞ԃZToAccel		ZTos
#define PslRelCh_Stat_Brake		4				//~					ڕWʒuBStop	1XebvxꍇBrake2		ZTosȂ
#define PslRelCh_Stat_Brake2		5				//1Xebvx				KStop							ZTosȂ
#define PslRelCh_Stat_Stop		6				//S㎥					莞Ԍo߂Off						ZTosȂ
/*--------------------------------------------------------------------------*/
#define PslRel_Ofs_Max			23/*ύX*/								//G̃pX-1	(23+1)*(20+1)=504c̃pX	[jbgɈˑl
#define PslRel_Pos_Max			20/*ύX*/								//̊G-1						
/*--------------------------------------------------------------------------*/
#define PslRel_Sns_Ofs			8/*ύX*/								//ZTõItZbg				[jbgɈˑl
#define PslRel_Sns_Pos			3/*ύX*/								//ZTo̊Gʒu					
/*--------------------------------------------------------------------------*/
#define PslRel_NdCnt_Min		(((PslRel_Ofs_Max+1)*(PslRel_Pos_Max+1))-(PslRel_Ofs_Max+1)/*ύX*/)	//ZToJE^̍ŏLl	oG߂Ăe鎖ɂB(ύX)
#define PslRel_NdCnt_Max		(((PslRel_Ofs_Max+1)*(PslRel_Pos_Max+1))+(PslRel_Ofs_Max+1)/*ύX*/)	//ZToJE^̍őLl	oGx߂Ăe鎖ɂB(ύX)
/*--------------------------------------------------------------------------*/
#define PslRel_StpCnt_Max		((200000/PslRel_IntrNs)-1)						//S㎥-1	200[ms]ƂB(ύX)		((200000/1488)-1)=133[荞]
/*--------------------------------------------------------------------------*/
#define PslRel_OutPat_Add		0									//S㎥ɏo̓p^[CfNXɉZl	[jbg̊ɈˑlB~ɊŐił܂ꍇ͂̒l𑝂₹B
/*--------------------------------------------------------------------------*/
#define PslRel_IntrNs			((1000000*60)/(((PslRel_Ofs_Max+1)*(PslRel_Pos_Max+1))*80))		//^C}荞݊Ԋu[ns]	((1000000*60)/(((23+1)*(20+1))*80))=1488[ns]
//					 ~~~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ ~~
//					   ꕪ[ns]                ̃pX              ʕ\ 񓷎VZ@ɌWZp̋Ki(Z֌W)  (1)\ɊւKi  C 񓷂̉]ɌWVZ@̐\ɊւKi  (j) ` ̉]̉񐔂́AꕪԂɔ\]𒴂̂łȂƁB `v
/****************************************************************************
 *	\
 ****************************************************************************/
typedef struct _ST_PslRelCh {
	uint8_t		iStat;		//+ 0, 1 				PslRelCh_Stat_*
	uint8_t		fSns;		//+ 1, 1 ZT			bit0=݂̏,bit1=1Ȍ,bit2=2Ȍ,...,bit7=7Ȍ
	uint8_t		iOfs;		//+ 2, 1 ItZbg			0`PslRelCh_Ofs_Max
	uint8_t		iPos;		//+ 3, 1 Gʒu			0`PslRelCh_Pos_Max		i
	uint8_t		iStpPos;	//+ 4, 1 ~ʒu			0`PslRelCh_Pos_Max		i
	uint8_t		iOutPat;	//+ 5, 1 o̓p^[CfNX		[2:0]=0`7,[7:3]=sl		TBL_PslRel_OutPat[]ւ̃CfNX	㎥,y,S㎥͎QƂȂB
	uint8_t		iAccPat;	//+ 6, 1 p^[CfNX						TBL_PslRel_AccPat[]ւ̃CfNX
	uint8_t		nAccCnt1;	//+ 7, 1 p^[JE^1
	uint8_t		nAccCnt2;	//+ 8, 1 p^[JE^2
	uint8_t		nStpCnt;	//+ 9, 1 S㎥JE^
	uint16_t	nNdCnt;		//+10, 2 ZToJE^
} ST_PslRelCh;				//=12
/*--------------------------------------------------------------------------*/
typedef struct _ST_PslRel {
	ST_PslRelCh	TBL_PslRelCh[3];	//[0]=[,[1]=[,[2]=E[
#ifndef PslRel_UseVirtualReel
	uint8_t		iIntr;			//荞݃JE^	PslRel_Sync()Ŋ荞ݏ^C~Oɓ邽߂ɎgpB
#endif//PslRel_UseVirtualReel
} ST_PslRel;
/****************************************************************************
 *	O[o֐
 ****************************************************************************/
void PslRel_Init(ST_PslRel* pPslRel);
int PslRel_Intr(ST_PslRel* pPslRel, int fSns);
void PslRel_Sync(ST_PslRel* pPslRel);
void PslRel_Accel(ST_PslRel* pPslRel);
void PslRel_Brake(ST_PslRel* pPslRel, int iPslRelCh, int iStpPos);
ST_PslRelCh* PslRel_GetPslRelCh(ST_PslRel* pPslRel, int iPslRelCh);
#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus
#endif//__CLIP_PSRL_H__
