/*	
 *	clippp4.h
 *
 *	P/ECE PPU (RICOH RP2C02) Emulator (1/4𑜓x)
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2005 Naoyuki Sawa
 *
 *	* Wed Feb 09 04:34:00 JST 2005 Naoyuki Sawa
 *	- 쐬JnB
 *	* Wed Nov 18 21:37:53 JST 2015 Naoyuki Sawa
 *	- 'extern "C" {'`'}'ň݂͂܂B.cpp܂Win32vWFNgCN[ho悤ɂ邽߂łB
 */
#ifndef __CLIP_PP4_H__
#define __CLIP_PP4_H__

#ifdef  __cplusplus
extern "C" {
#endif//__cplusplus

/* {W[́AʏłPPU EmulatorW[ɁA1/4𑜓x̕`@\ǉ܂B
 * 1/4𑜓x̕`@\͎IȂ̂łAA菜\̂ŁA
 * ʏłPPU EmulatorW[Ɋ܂߂܂łB
 *
 * ʏłPPU EmulatorW[ɑt@ĆA̒ʂłB
 *	clipppu.h
 *	clipppu.c
 *	clipppua.h
 *	clipppui.h
 *	framppu.c
 *	framppua.s
 *
 * 1/4𑜓xłPPU EmulatorW[ɑt@ĆA̒ʂłB
 *	clippp4.h
 *	clippp4.c
 *	clippp4i.h
 *	frampp4.c
 *	frampp4a.s
 *
 * ʏł̃t@ĆA1/4𑜓xł̃t@CɈ؈ˑĂ܂B
 * łA1/4𑜓xł̃t@CvWFNg폜邱Ƃł܂B
 *
 *
 * 1/4𑜓xł̃t@ĆAʏł̃t@CɈˑĂ܂B
 * ʏł̍\̂ȂǂύXꍇ́A1/4𑜓xł̏Ǐ]ĂB
 *
 * ʏł𗘗pAvP[V́ARAMɎ̃t@CzuĂB
 *	framppu.o
 *	framppua.o
 * AvP[V1/4𑜓xł̕`֐(ppu4_update())gȂ΁A
 * 1/4𑜓xł̃t@C͈؃N܂B
 *
 * 1/4𑜓xł𗘗pAvP[V́ARAMɎ̃t@CzuĂB
 *	framppu.o
 *	framppua.o
 * AvP[Vʏł̕`֐(ppu_update())gȂĂA
 * ʏł̃t@Cׂ͂ăN܂B
 * ʏł̍RAMpt@CN܂ARAMɔzuȂ΁A
 * SRAM̈𐔃LoCgʂɏ邾ōς݂܂B
 */

/****************************************************************************
 *
 ****************************************************************************/

/* PPU_ASMV{`ǂݍ݂܂B
 * PPU_ASMV{̖`/`ɂC/AZuR[h̐؂ւ́A
 * C\[Xt@C(*.c)ƃAZu\[Xt@C(*.s)QƂ̂ŁA
 * ʂ̃CN[ht@CɕĂ܂B
 * (CL̒`܂ރCN[ht@Ĉ܂܃AZu\[X
 *  CN[hƁAAZuG[ɂȂĂ܂߁B)
 */
#include "clipppua.h"

/********** ȍ~͏Ȃł **********/

/* P/ECEȊOł̓AZuR[h͎gpł܂B
 */
#ifndef PIECE
#undef PPU_ASM
#endif /*PIECE*/

/****************************************************************************
 *	O[oϐ
 ****************************************************************************/

#ifdef PPU_GRAYSCALE
extern const unsigned char ppu4_grayscale_table[64];
#endif /*PPU_GRAYSCALE*/

/****************************************************************************
 *	֐
 ****************************************************************************/

void ppu4_draw_bg();
void ppu4_draw_sprite     (int priority);
void ppu4_draw_sprite_8x8 (int priority);
void ppu4_draw_sprite_8x16(int priority);
void ppu4_draw_chr      (int xpos, int ypos, int code, int palno);
void ppu4_draw_chr_revx (int xpos, int ypos, int code, int palno);
void ppu4_draw_chr_revy (int xpos, int ypos, int code, int palno);
void ppu4_draw_chr_revxy(int xpos, int ypos, int code, int palno);

/****************************************************************************
 *	AvP[Vp֐
 ****************************************************************************/

/* ʂ`悵܂B
 * [in]
 *	vbuff		128x120ʃobt@B(NULL:̂݁A`斳)
 * [out]
 *	߂l		o߃TCNB(NTSCJ[TuLANbNP)
 * [note]
 *	* o͉𑜓xقȂȊÓAppu_update()ƓłB
 *	  ppu_update()̐QƂĂB
 */
int ppu4_update(unsigned char vbuff[/*128*120*/]);

#ifdef PPU_GRAYSCALE
/* 128x120x16~OCXP[A128x88x16~OCXP[֏kRs[܂B
 * [in]
 *	src		128x120x16~OCXP[ʃobt@B
 *	dst		128x 88x16~OCXP[ʃobt@B
 *
 * [note]
 *	* o͉𑜓xقȂȊÓAppu_reduce()ƓłB
 *	  ppu_reduce()̐QƂĂB
 */
void ppu4_reduce(unsigned char dst[/*128*88*/], const unsigned char src[/*128*120*/]);
#endif PPU_GRAYSCALE

#ifdef  __cplusplus
}//extern "C"
#endif//__cplusplus

#endif /*__CLIP_PP4_H__*/
