/*
 *	clipdrh.c
 *
 *	k˘Ak˃nt}k
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2001-2016 Naoyuki Sawa
 *
 *	* Mon Nov 24 10:36:38 JST 2014 Naoyuki Sawa
 *	- 1st [XB
 *	- nt}k̉pƂāA쐬܂B
 *	  Aĕω悤ȃf[^kۂɁAnt}kPƂŎgpkǂȂ܂B
 *	  ALEDfR[_[ŗp邱Ƃz肵Ă܂B
 *	- W[ōHv_́AAƍ̕}[WłB
 *	  Aƍ́AʁX̕\ňk܂B(Aƍ̏ol͕΂̌XႤ̂ŁAʁX̕\ňkkǂƎv)
 *	  AAƍ̕т͕ȂAɓǂݏõrbgʒuŊǗłAsǂłB
 *	  ]āAAƍ݂̕Ɏ擾ł悤A}[W܂B
 *	  mAʓIȈk`(ziplzh)AȂĂƎv܂B
 *	- AkȂf[^ƁAnt}kP2{̏Ԃ܂B(Aƍ̕sKv邽)
 *	  f[^̓ɂāAk̕TdɑIKv܂B
 *	* Thu Nov 27 21:49:37 JST 2014 Naoyuki Sawa
 *	- DeltaRunHuffmanDecoder_Decode(),DeltaRunHuffmanDecoder_Init(),DeltaRunHuffmanDecoder_Getc()AZu܂B
 *	  DeltaRunHuffmanDecoder_Decode()ŁA50KB˖64KB̓WJs̑xA2.237b˖1.487bɍ܂B(Clock=48MHz,Code=SRAM,Stack=FRAM)
 *	- ܂AAZuDeltaRunHuffmanDecoder_Decode(),DeltaRunHuffmanDecoder_Init(),DeltaRunHuffmanDecoder_Getc()̓mFA[ɍsĂ܂B	//
 *	  AAZuDeltaRunHuffmanDecoder_Decode(),DeltaRunHuffmanDecoder_Init(),DeltaRunHuffmanDecoder_Getc()̓mFs\łB		//TODO:2014/11/27_B[ɓmF炱̃Rg͏B
 *	  ɁAAZuDeltaRunHuffmanDecoder_Getc()̓mFAd_IɍsKv܂B								//
 *	* Tue Sep 06 21:06:46 JST 2016 Naoyuki Sawa
 *	- DeltaRunHuffmanEncoder_GetHdrSize()A(int)ŃAhXZsĂ̂A(char*)ōs悤ɏC܂B
 *	  64rbgΉ̂߂̏łA32rbgł(char*)ōs{͐łB
 *	  Ƃ͌A32rbgł͂ǂłʂɂȂ̂ŁA32rbgR[hɂ͉eL܂B
 *	* Thu Sep 29 21:37:05 JST 2016 Naoyuki Sawa
 *	- Hewł̓GR[_[܂߂Ȃ悤ɂ܂B
 */
#include "clip.h"

//[note]
//ڍׂȃRg͏ȗB
//ASY̐cliphfm.c,framhfm.cQƂB

#ifndef __RENESAS__	//{{2016/09/29ǉ:Hewł̓GR[_[܂߂Ȃ悤ɂ܂B}}
/****************************************************************************
 *	k˘Ak˃nt}kGR[_[
 ****************************************************************************/
//\̃oCg擾B
static int DeltaRunHuffmanEncoder_GetHdrSize(const void* _src) {
	const unsigned char* hdr = _src;
	int codeLenMask, codeLenCount;
	codeLenMask = *(*(int**)&hdr)++;
	do {
		if(codeLenMask < 0) {
			codeLenCount = *hdr++ + 1;
			hdr += codeLenCount;
		}
	} while(codeLenMask <<= 1);
//{{2016/09/06ύX:DeltaRunHuffmanEncoder_GetHdrSize()A(int)ŃAhXZsĂ̂A(char*)ōs悤ɏC܂B
//	return (((int)hdr - (int)_src) + 3) & ~3;	//32bitE܂Ői߂B
//2016/09/06ύX:DeltaRunHuffmanEncoder_GetHdrSize()A(int)ŃAhXZsĂ̂A(char*)ōs悤ɏC܂B
	return (((char*)hdr - (char*)_src) + 3) & ~3;	//32bitE܂Ői߂B
//}}2016/09/06ύX:DeltaRunHuffmanEncoder_GetHdrSize()A(int)ŃAhXZsĂ̂A(char*)ōs悤ɏC܂B
}
/*--------------------------------------------------------------------------*/
//̃nt}擾B
//kf[^̏I[Ȃ΁A(-1)ԂB
static int DeltaRunHuffmanEncoder_GetCode(ST_HuffmanDecoder* pHuffmanDecoder, int* pCodeLen) {
	const unsigned char* hdr = pHuffmanDecoder->src;
	int code, codeLenMask, codeLen, codeTmp1, codeTmp2, codeLenCount;
	code = bitarray_msb1st_get(pHuffmanDecoder->src, pHuffmanDecoder->srcPos, 32);
	codeLenMask = *(*(int**)&hdr)++;
	codeLen = codeTmp1 = codeTmp2 = 0;
	do {
		codeTmp1 <<= 1;
		codeTmp2 = (codeTmp2 << 1) | (code < 0);
		code <<= 1;
		codeLen++;
		if(codeLenMask < 0) {
			codeLenCount = *hdr++ + 1;
			hdr      += codeLenCount;
			codeTmp1 += codeLenCount;
			if(codeTmp2 < codeTmp1) {
				pHuffmanDecoder->srcPos += codeLen;
				*pCodeLen = codeLen;
				return codeTmp2;
			}
		}
	} while(codeLenMask <<= 1);
	return -1;
}
/*--------------------------------------------------------------------------*/
//k˘Ak˃nt}kGR[hsB
//kf[^dstBytes𒴂ꍇ́Az͊i[ȂB
// - l̎oCg8bitłꍇ́AĂяoŏl߂ɃVtgĂB
//   l߂ɃVtgĂƂɂāÁ}bvAEhɂȂlAkシB
// - f[^\͉}̂Ƃ:
//
//	32bitE
//	@@@@@@
//	A̕\
//	@@@@@@
//	
//	(pfBO)
//	32bitE
//	@@@@@@
//	̕\
//	@@@@@@
//	
//	(pfBO)
//	32bitE
//	 A̕ 
//	 ̕ 
//	 A̕ 
//	 ̕ 
//	 @@E@@ 
//	 @@E@@ 
//	 @@E@@ 
//	 A̕ 
//	 ̕ 
//	@I[@
//	
//	(pfBO)
//	32bitE
//
int DeltaRunHuffmanEncoder_Encode(const void* _src, int srcBytes, void* _dst, int dstBytes) {
	const unsigned char* src = _src;
	      unsigned char* dst = _dst;
	unsigned char *pDelta, *pRun1, *pRun2, *pHuffman1, *pHuffman2;
	int i, nRun, nHuffman1, nHuffman2, nHdr1, nHdr2, dstBits, dstPos;
	ST_HuffmanDecoder stHuffmanDecoder1, stHuffmanDecoder2;
	//--- k ---
	if(!(pDelta = calloc(srcBytes, 1))) { DIE(); }
	for(i = 0; i < srcBytes; i++) {
		pDelta[i] = src[i];
		if(i) { pDelta[i] -= src[i - 1]; }
	}
	//--- Ak ---
	if(!(pRun1 = calloc(srcBytes, 1))) { DIE(); }	//A
	if(!(pRun2 = calloc(srcBytes, 1))) { DIE(); }	//
	nRun = 0;
	for(i = 0; i < srcBytes; i++) {
		if(nRun && (pRun1[nRun - 1] != 255) && (pRun2[nRun - 1] == pDelta[i])) {
			pRun1[nRun - 1]++;
		} else {
			pRun2[nRun++] = pDelta[i];
		}
	}
	//--- nt}k ---
	nHuffman1 = HuffmanEncoder_Encode(pRun1, nRun, NULL, 0);	//A
	if(!(pHuffman1 = calloc(nHuffman1, 1))) { DIE(); }
	HuffmanEncoder_Encode(pRun1, nRun, pHuffman1, nHuffman1);
	nHuffman2 = HuffmanEncoder_Encode(pRun2, nRun, NULL, 0);	//
	if(!(pHuffman2 = calloc(nHuffman2, 1))) { DIE(); }
	HuffmanEncoder_Encode(pRun2, nRun, pHuffman2, nHuffman2);
	//\̃oCg擾B
	nHdr1 = DeltaRunHuffmanEncoder_GetHdrSize(pHuffman1);	//A
	nHdr2 = DeltaRunHuffmanEncoder_GetHdrSize(pHuffman2);	//
	//\}[WB
	if((nHdr1 + nHdr2) <= dstBytes) {
		memcpy(dst +     0, pHuffman1, nHdr1);	//A
		memcpy(dst + nHdr1, pHuffman2, nHdr2);	//
	}
	dstBits = dstBytes << 3;
	dstPos  = (nHdr1 + nHdr2) << 3;
	//f[^}[WB
	HuffmanDecoder_Init(&stHuffmanDecoder1, pHuffman1);	//A
	HuffmanDecoder_Init(&stHuffmanDecoder2, pHuffman2);	//
	for(;;) {
		int codeLen1, codeLen2;
		int code1 = DeltaRunHuffmanEncoder_GetCode(&stHuffmanDecoder1, &codeLen1);	//A
		int code2 = DeltaRunHuffmanEncoder_GetCode(&stHuffmanDecoder2, &codeLen2);	//
		if((code1 ^ code2) < 0) { DIE(); }	//ɏIȂ΃oOB
		if(code1 == -1) { break; }
		if((dstPos + codeLen1) <= dstBits) {
			bitarray_msb1st_set(dst, dstPos, codeLen1, code1);	//A
		}
		dstPos += codeLen1;
		if((dstPos + codeLen2) <= dstBits) {
			bitarray_msb1st_set(dst, dstPos, codeLen2, code2);	//
		}
		dstPos += codeLen2;
	}
	if((dstPos + 32) <= dstBits) {
		bitarray_msb1st_set(dst, dstPos, 32, -1);	//{͘A̕\̏I[gpׂA(-1)łmɏI[ƌȂ̂Ŗ薳BɂAI[32bito͂ĂKv̂ŁAʂ͐ȂB
	}
	dstPos += 32;
	//kf[^́̕Abitarray_msb1st_getŃANZX̂ŁA32bitPʂɐ؏グĂKvLB
	if(dstPos & 31) {
		int codeLen = 32 - (dstPos & 31);
		if((dstPos + codeLen) <= dstBits) {
			bitarray_msb1st_set(dst, dstPos, codeLen, 0);	//kf[^̗]̃rbǵAslł\ȂAՂ̂߂ɁA0Ŗ߂ĂƂɂB
		}
		dstPos += codeLen;
	}
	//JB
	free(pDelta);
	free(pRun1);
	free(pRun2);
	free(pHuffman1);
	free(pHuffman2);
	//o̓oCgԂB
	return dstPos >> 3;
}
#endif//__RENESAS__	//{{2016/09/29ǉ:Hewł̓GR[_[܂߂Ȃ悤ɂ܂B}}
