/*
 *	clipalca.c
 *
 *	alloca()AGNU C̑gݍ݊֐݊@\
 *
 *	CLiP - Common Library for P/ECE
 *	Copyright (C) 2012-2014 Naoyuki Sawa
 *
 *	* Tue Oct 16 11:50:08 JST 2012 Naoyuki Sawa
 *	- 1st [XB
 *	- 錾́Ainclude/alloca.h ɂ܂B
 *	* Sat May 31 14:34:06 JST 2014 Naoyuki Sawa
 *	- alloca_hook_proc̃oOC܂B
 *	  allocaĂяo֐߂lԂƂAtbN֐łalloca_hook_proc߂lj󂵂Ă܂B
 *	  ̏CŁAallocaĂяo֐Ԃ߂lallocaj󂹂Ap悤ɂȂ܂B
 */
#include "clip.h"

/****************************************************************************
 *	alloca
 ****************************************************************************/

/* alloca()ŊmۂA`FCĕێ邽߂̍\ */
typedef struct _ALLOCA_INFO {
	LIST_ENTRY list_entry;	/* `FCp */
	void* return_address;	/* tbN߂AhX */
	/* ̌ɁAmۂ܂ */
} ALLOCA_INFO;

/* f[^ŏĂƂɂāAInitializeListHead()ŏKvȂB */
static LIST_ENTRY alloca_info_head = { /*Flink*/&alloca_info_head, /*Blink*/&alloca_info_head };

/*--------------------------------------------------------------------------*/

/*static*/ void alloca_hook_proc();
asm("
		.code
		.align		1
alloca_hook_proc:
		pushn		%r0
		call.d		alloca_hook_proc_sub	;// Ǘ\̃`FC̐擪́AJ܂B
		ld.w		%r0, %r10		;// %r0  := allocaĂяo֐̖߂l		*delay*
		ld.w		%r9, %r10		;// %r9  := ߂AhX
		ld.w		%r10, %r0		;// %r10 := allocaĂяo֐̖߂l
		popn		%r0
		jp		%r9			;// Ǘ\̃`FC̐擪́A߂AhX֖߂܂B
");

/*--------------------------------------------------------------------------*/

static void* __attribute__((unused)) alloca_hook_proc_sub() { /* asmubNQ */
	ALLOCA_INFO* p_alloca_info;
	void* return_address;
ENTER_CS;
	/* Ǘ\̃`FC̎OAAg~bNɍs߁A荞݋֎~ */
	/* `FC̐擪̊Ǘ\̂O܂B */
	p_alloca_info = CONTAINING_RECORD(
		RemoveTailList(&alloca_info_head),
		ALLOCA_INFO, list_entry);
	/* alloca()Ăяo֐́A߂AhX̃tbN鏈sĂ͂܂B
	 * pseudo_alloca()̒ŃtbN(=߂AhX)̂́AX^bN̖߂AhXłB
	 * ֗ƂƂ́AX^bN̖߂AhXǂݏoꂽƂƂłA
	 * X^bN̖߂AhẌʒúAX^bNt[OɂȂĂ邩łB
	 */
LEAVE_CS;
	/* Ǘ\̂A߂AhX擾܂B */
	return_address = p_alloca_info->return_address;
	/* Ǘ\̂ƃA܂Ƃ߂ĊJ܂B */
	free(p_alloca_info);
	/* alloca_hook_procɁA߂AhXԂ܂B */
	return return_address;
}

/*--------------------------------------------------------------------------*/

void* pseudo_alloca(size_t size) {
	ALLOCA_INFO* p_alloca_info;
	void** return_address_p;
	/* Ǘ\̂ƃA܂Ƃ߂Ċmۂ܂B */
	p_alloca_info = malloc(sizeof(ALLOCA_INFO) + size);
	if(p_alloca_info == NULL) DIE(); /* s */
	/* alloca()Ăяo֐́A߂AhXi[ĂAhX擾܂B */
	return_address_p = get_return_address_p(1);
	/* Ǘ\̂ɁAalloca()Ăяo֐̖߂AhXi[܂B */
	p_alloca_info->return_address = *return_address_p;
ENTER_CS;
	/* Ǘ\̃`FC̒ǉƁA߂AhX̃tbNAAg~bNɍs߁A荞݋֎~ */
	/* alloca()Ăяo֐́A߂AhXtbN܂B */
	*return_address_p = alloca_hook_proc;
	/* Ǘ\̂A`FC̖ɒǉ܂B */
	InsertTailList(&alloca_info_head, &p_alloca_info->list_entry);
LEAVE_CS;
	/* Ǘ\̂̌ɊmۂAԂ܂B */
	return p_alloca_info + 1;
}

/****************************************************************************
 *	GNU C̑gݍ݊֐݊@\
 ****************************************************************************/

//	* Tue Oct 16 12:42:11 JST 2012 Naoyuki Sawa
//	- gcc33AZuR[h́AGs[OR[h́Aȉ̂ꂩłB
//	  @ add %sp,imm10; popn %rd; ret[.d]
//	  A add %sp,imm10;           ret[.d]
//	  B                popn %rd; ret[.d]
//	  C                          ret[.d]
//	  ۂɂgcc33́Aret.d𐶐܂񂪁Aꉞret.dł삷悤ɑΉ܂B
//	- {֐́Agcc̏L̓𗘗pāAĂяo֐̃^[AhXT܂B
//	  L̃p^[ɈvȂAAZu֐AĂяoƂ͂ł܂B
//	  R[X^bN̓rɁAAZu֐܂܂ĂĂ܂B
//
//	:OK
//		void c_func_1() { c_func_2(); }
//		void c_func_2() { c_func_3(); }
//		void c_func_3() { __builtin_return_address(1); } // c_func_2()̖߂AhX擾
//	:OK
//		asm("asm_func_1: call c_func_2; ret;"); //ΏۂɂȂȂ̂őv
//		void c_func_2() { c_func_3(); }
//		void c_func_3() { __builtin_return_address(1); } // c_func_2()̖߂AhX擾
//	:NG
//		void c_func_1() { asm_func_2(); }
//		asm("asm_func_2: call c_func_3; ret;"); //ΏۂɂȂ
//		void c_func_3() { __builtin_return_address(1); } // asm_func_2()̖߂AhX擾邱Ƃ͂łȂ!!
//	:NG
//		void c_func_1() { c_func_2(); }
//		void c_func_2() { asm_func3(); } //ΏۂAȑO̖ŁA܂ŌBȂ낤
//		asm("asm_func_3: ld.w %r12, 1; call get_return_address; ret;"); // c_func_2()̖߂AhX擾邱Ƃ͂łȂ!!
//
//	L͐̂߂__builtin_return_address(1)gp܂Aۂɂ͈0ŌĂяoƂقƂǂł傤B
//	  ʏ́AAZu֐璼ڌĂяoƂłȂƈӊÓA肪P[XCɂKv͂܂B

void*  get_frame_address   (unsigned int level);
void*  get_return_address  (unsigned int level);
void** get_return_address_p(unsigned int level);
asm("
		.code
		.align		1
		.global		get_frame_address
		.global		get_return_address
		.global		get_return_address_p
;//void*  get_frame_address   (unsigned int level)
get_frame_address:
		call	get_return_address_p			;// %r10 := get_return_address_p(level)
		ret.d
		add	%r10, 4					;// %r10 := return_address_p + 4		*delay*
;//void*  get_return_address  (unsigned int level)
get_return_address:
		call.d	get_return_address_p			;// %r10 := get_return_address_p(level + 1)
		 add	%r12, 1					;// %r12 :=                      level + 1	*delay*
		ld.w	%r10, [%r10]				;// %r10 := return_address
		ret
;//void** get_return_address_p(unsigned int level)
get_return_address_p:
		ld.w		%r10, %sp			;// %r10 := get_return_address_p()̃X^bNt[
		;//--- __builtin_return_address()̈levelŎw肳ꂽ񐔁AɌĂяo֐ǂ郋[v ---
get_return_address_p_LOOP_1:
		ld.w		%r13, [%r10]+			;// %r13 := get_return_address_p()̖߂AhX, %r10 := Ăяo֐̃X^bNt[
		;//--- Ăяo֐̖ɂAyret[.d]zT[v ---
get_return_address_p_LOOP_2:
		ld.uh		%r14, [%r13]+			;// %r14 := Ăяo֐̖, %r13 := Ăяo֐%pc
		;// yret[.d]z̃R[hF
		;// -Œ-@Œ脟
		;// OOOOOPPOPOOOOOO
		xand		%r14, %r14, 0xFEFF		;// if(%r14 != yret[.d]z) {
		xcmp		%r14,       0x0640		;//   goto get_return_address_p_LOOP_2
		jrne		get_return_address_p_LOOP_2	;// }
		;//--- yret[.d]z̒OɁAypopn %rdz΁AX^bNt[𒲐 ---
		;// ypopn %rdz̃R[hF
		;// Œ脟
		;// OOOOOOPOOPOOEEEE
		sub		%r13, 4				;// %r13 := yret[.d]z̒O̖߃AhX
		ld.uh		%r14, [%r13]			;// %r14 := yret[.d]z̒O̖
		xsub		%r15, %r14, 0x0240		;// %r15 := (%r14 == ypopn %rdz) łꍇrd
		xcmp		%r15,       0x000F
		jrugt		6				;// if(%r14 == ypopn %rdz) {
		 add		%r15, 1				;//   %r15 :=                                     (rd + 1)
		 sll		%r15, 2				;//   %r15 :=                                    ((rd + 1) * 4)
		 add		%r10, %r15			;//   %r10 := Ăяo֐̃X^bNt[ + ((rd + 1) * 4)
		 sub		%r13, 2				;//   %r13 := ypopn %rdz̒O̖߃AhX
		 ld.uh		%r14, [%r13]			;//   %r14 := ypopn %rdz̒O̖
		;//						;// }
		;//--- yret[.d]źypopn %rdz̒OɁAyadd %sp, imm10z΁AX^bNt[𒲐 ---
		;// yadd %sp, imm10z̃R[hF
		;// Œ脟-PO-
		;// POOOOOEEEEEEEEEE
		xsub		%r15, %r14, 0x8000		;// %r15 := (%r14 == yadd %sp, imm10z) łꍇimm10
		xcmp		%r15,       0x03FF
		jrugt		3				;// if(%r14 == yadd %sp, imm10z) {
		 sll		%r15, 2				;//   %r15 :=                                    (imm10 * 4)
		 add		%r10, %r15			;//   %r10 := Ăяo֐̃X^bNt[ + (imm10 * 4)
		;//						;// }
		;//--- __builtin_return_address()̈levelŎw肳ꂽ񐔁AɌĂяo֐ǂ郋[v ---
		sub		%r12, 1				;// if(--level >= 0)
		jruge		get_return_address_p_LOOP_1	;//   goto get_return_address_p_LOOP_1
		ret
");

