//
//	ToolLib_Button.cpp
//
//	GfB^[ʏ - c[GUĨ{^
//
//	* Tue Apr 18 21:46:46 JST 2017 Naoyuki Sawa
//	- 1st [XB
//	* Wed Apr 19 22:11:14 JST 2017 Naoyuki Sawa
//	- u@DxLibɈˑȂ悤ɂvƁuACŃRpCo悤ɂvΉ܂B
//	  ڍׂ́A/clip/ToolLib/README.TXT ́ÃRgQƂĉB
//	* Thu Apr 20 21:31:57 JST 2017 Naoyuki Sawa
//	- CuIuWFNg̎ʎqAnh˃|C^ɕύX܂B
//	  IWiłł͐IuWFNgŒ蒷zɊi[ĊǗĂ̂łAߖ̂߂ɃXgŊǗ悤ɕύXÂ߂ɂ͐nh|C^̕sǂłB
//	  AtHgnhƕ̓nh́ACuIuWFNgł͂ȂobNGh̃IuWFNgȂ̂ŁA̕ύXɂ͊֌Wnĥ܂܂łB
//
#include "clip.h"
//*****************************************************************************
//	萔A}NA\
//*****************************************************************************
#define TOOL_FIRST_REPEAT_WAIT	(0.2)		//{^s[g̍ŏ̑҂ԁB
#define TOOL_REPEAT_WAIT	(0.017)		//2ڈȍ~̃{^s[g̊ԊuB
//-----------------------------------------------------------------------------
//{^\
/*typedef*/ struct _SToolButton {
	SToolVisible*	TVisible;		//֘AtĂ\ԏB
	SToolWindow*	TWindow;		//֘AtĂEChEB
	int		On_Off_SwitchType;	//ONԂOFFԂтɐ؂ւ^Cṽ{^ǂB
	POINT		Position;		//{^̈ʒuB
	SIZE		Size;			//{^̃TCYB
	char*		Name;			//{^̖O̕񂪊i[Ă郁AhXۑĂ|C^B
	int		Visible;		//\ԁB
	int		Bottom;			//{^ԂǂB
	double		BottomTime;		//{^Ă鎞ԁB
	int		FirstRepeat;		//ŏ̃s[gsꂽǂB
	int		RepeatBottom;		//s[g͂l{^ԁB
	int		Click;			//{^NbNꂽǂB
	int		OnOffFlag;		//{^ON/OFFԁB
} /*SToolButton*/;
//*****************************************************************************
//	[Jϐ
//*****************************************************************************
static GSList*	g_TButton;
//*****************************************************************************
//	[J֐錾
//*****************************************************************************
static void ToolButton_Step(SToolButton* TButton, double StepTime);
static void ToolButton_Draw(SToolButton* TButton);
//*****************************************************************************
//	AvP[Vp֐
//*****************************************************************************
//{^쐬B
//[in]
//	On_Off_SwitchType	ONԂOFFԂтɐ؂ւ^Cṽ{^ǂB
//	Name			OƂȂ镶̃AhXB
//	x,y			{^\鍶WB
//	w,h			{^̕ƍB
//[out]
//	߂l			{^B
SToolButton* ToolButton_Create(int On_Off_SwitchType, const char* Name, int x, int y, int w, int h) {
	SToolButton* TButton;
	//V{^i[邽߂̃̊mہB
	TButton = calloc(1, sizeof(SToolButton));
	if(!TButton) { DIE(); }
	//mۂ̈ۑB
	g_TButton = g_slist_append(g_TButton, TButton);
	//B
//sv	TButton->TVisible          = NULL;
//sv	TButton->TWindow           = NULL;
	TButton->On_Off_SwitchType = On_Off_SwitchType;
	TButton->Position.x        = x;
	TButton->Position.y        = y;
	TButton->Size.cx           = w;
	TButton->Size.cy           = h;
	TButton->Visible           = 1;
//sv	TButton->Bottom            = 0;
//sv	TButton->BottomTime        = 0.0;
//sv	TButton->FirstRepeat       = 0;
//sv	TButton->Click             = 0;
//sv	TButton->OnOffFlag         = 0;
	ToolButton_SetName(TButton, Name);
	//{^ԂB
	return TButton;
}
//-----------------------------------------------------------------------------
//{^폜B
//[in]
//	TButton			{^B
void ToolButton_Delete(SToolButton* TButton) {
	//OۑpɃmۂĂꍇ͉B
	free(TButton->Name);
	//mۂĂB
	g_TButton = g_slist_remove(g_TButton, TButton);
	free(TButton);
}
//-----------------------------------------------------------------------------
//SẴ{^폜B
void ToolButton_Delete_All() {
	//LȑSẴ{^폜B
	while(g_TButton) { ToolButton_Delete(g_TButton->data); }
}
//-----------------------------------------------------------------------------
//{^Ɋ֘At\ԏZbgB
//[in]
//	TButton			{^B
//	TVisible		\ԏB
void ToolButton_SetVisibleHandle(SToolButton* TButton, SToolVisible* TVisible) {
	TButton->TVisible = TVisible;
}
//-----------------------------------------------------------------------------
//{^̖Oݒ肷B
//[in]
//	TButton			{^B
//	Name			OƂȂ镶̃AhXB
void ToolButton_SetName(SToolButton* TButton, const char* Name) {
	//ɖOpɃmۂĂꍇ͉B
	free(TButton->Name);
	TButton->Name = NULL;
	//ÕAhXLȏꍇ̓mۂĕۑB
	if(Name) {
		TButton->Name = strdup(Name);
		if(!TButton->Name) { DIE(); }
	}
}
//-----------------------------------------------------------------------------
//{^Ɗ֘AtEChEݒ肷B
//[in]
//	TButton			{^B
//	TWindow			EChEB
void ToolButton_SetWindow(SToolButton* TButton, SToolWindow* TWindow) {
	TButton->TWindow = TWindow;
}
//-----------------------------------------------------------------------------
//{^̈ʒuύXB
//[in]
//	TButton			{^B
//	x,y			ύX̃{^̍WB
void ToolButton_SetPosition(SToolButton* TButton, int x, int y) {
	TButton->Position.x = x;
	TButton->Position.y = y;
}
//-----------------------------------------------------------------------------
//{^ON/OFFԂύXB
//[in]
//	TButton			{^B
//	Flag			ύXON/OFFԁB(0ȊO:ON,0:OFF)
void ToolButton_SetOnOffFlag(SToolButton* TButton, int Flag) {
	TButton->OnOffFlag = Flag;
}
//-----------------------------------------------------------------------------
//{^ON/OFFԂ擾B
//[in]
//	TButton			{^B
//[out]
//	߂l			ON/OFFԁB(0ȊO:ON,0:OFF)
int ToolButton_GetOnOffFlag(SToolButton* TButton) {
	return TButton->OnOffFlag;
}
//-----------------------------------------------------------------------------
//{^̃{^NbNꂽǂ擾B
//[in]
//	TButton			{^B
//	Reset			NbNꂽǂ̏ԂZbg邩ǂB(0ȊO:Zbg,0:ZbgȂ)
//[out]
//	߂l			{^NbNꂽǂB(0ȊO:NbNꂽ,0:NbNĂȂ)
int ToolButton_GetClick(SToolButton* TButton, int Reset) {
	int Ret = TButton->Click;
	if(Reset) { TButton->Click = 0; }
	return Ret;
}
//-----------------------------------------------------------------------------
//{^̃{^Ă邩ǂ擾B
//[in]
//	TButton			{^B
//[out]
//	߂l			{^Ă邩ǂB(0ȊO:Ă,0:ĂȂ)
int ToolButton_GetBottom(SToolButton* TButton) {
	return TButton->Bottom;
}
//-----------------------------------------------------------------------------
//{^̃{^Ă邩ǂ擾B(s[g@\t)
//[in]
//	TButton			{^B
//[out]
//	߂l			{^Ă邩ǂB(0ȊO:Ă,0:ĂȂ)
int ToolButton_GetRepeatBottom(SToolButton* TButton) {
	return TButton->RepeatBottom;
}
//-----------------------------------------------------------------------------
//{^̕\ԂύXB
//[in]
//	TButton			{^B
//	Visible			V\ԁB
void ToolButton_SetVisible(SToolButton* TButton, int Visible) {
	//V\ԂۑB
	TButton->Visible = Visible;
}
//-----------------------------------------------------------------------------
//{^̕\Ԃ擾B
//[in]
//	TButton			{^B
//[out]
//	߂l			\ԁB(0ȊO:\,0:\)
int ToolButton_GetVisible(SToolButton* TButton) {
	//\Ԃ0̏ꍇ0ԂB
	if(!TButton->Visible) { return 0; }
	//֘AtĂEChE̕\Ԃ0̏ꍇ0ԂB
	if(!ToolWindow_GetVisible(TButton->TWindow)) { return 0; }
	//\ԏ񂪓o^ĂāA\ԏ̕\Ԃ0̏ꍇ0ԂB
	if(!ToolVisible_GetVisible(TButton->TVisible)) { return 0; }
	//ɂĂ\ł͂ȂƂƂȂ̂0ȊOԂB
	return 1;
}
//-----------------------------------------------------------------------------
//SẴ{^̏ԐڏsB
//[in]
//	StepTime		i߂鎞ԁB(P:b)
void ToolButton_Step_All(double StepTime) {
	GSList* list = g_TButton;
	while(list) {
		ToolButton_Step(list->data, StepTime);
		list = list->next;
	}
}
//-----------------------------------------------------------------------------
//SẴ{^̕`ڏsB
void ToolButton_Draw_All() {
	GSList* list = g_TButton;
	while(list) {
		ToolButton_Draw(list->data);
		list = list->next;
	}
}
//*****************************************************************************
//	[J֐
//*****************************************************************************
//{^̏ԐڏsB
//[in]
//	TButton			{^B
//	StepTime		i߂鎞ԁB(P:b)
static void ToolButton_Step(SToolButton* TButton, double StepTime) {
	int MouseX, MouseY;
	int MouseRepeatInput, MouseInput, MouseEdgeInput;
	int TempX, TempY;
	int In;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolButton_GetVisible(TButton)) { return; }	//܂
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//}EX̓͏Ԃ擾B
	MouseRepeatInput = 0;
	MouseInput       = (ToolStatic_GetMouseButton()     & (1<<0)/*MOUSE_INPUT_LEFT*/) != 0;
	MouseEdgeInput   = (ToolStatic_GetMouseEdgeButton() & (1<<0)/*MOUSE_INPUT_LEFT*/) != 0;
	//{^̕\̈Ƀ}EXJ[\邩ǂ𒲂ׂB
	if(TButton->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TButton->TWindow, &TempX, &TempY);
		TempX += TButton->Position.x;
		TempY += TButton->Position.y;
		In = ToolStatic_CheckMouseIn(TempX,
		                             TempY,
		                             TempX + TButton->Size.cx,
		                             TempY + TButton->Size.cy) &&
		                             ToolWindow_CheckInfoAreaIn(
		                             TButton->TWindow, MouseX, MouseY);
	} else {
		In = ToolStatic_CheckMouseIn(TButton->Position.x,
		                             TButton->Position.y,
		                             TButton->Position.x + TButton->Size.cx,
		                             TButton->Position.y + TButton->Size.cy);
	}
	//{^Ă邩ǂŏ𕪊B
	if(MouseInput) {
		//{^Ăꍇ̓s[gsB
		TButton->BottomTime += StepTime;
		if(TButton->FirstRepeat) {
			if(TButton->BottomTime >= TOOL_REPEAT_WAIT) {
				MouseRepeatInput      = 1;
				TButton->BottomTime  -= TOOL_REPEAT_WAIT;
			}
		} else {
			if(TButton->BottomTime >= TOOL_FIRST_REPEAT_WAIT) {
				MouseRepeatInput      = 1;
				TButton->FirstRepeat  = 1;
				TButton->BottomTime  -= TOOL_FIRST_REPEAT_WAIT;
			}
		}
		//{^ꂽuԂ͕Ks[g͍l̃{^Ԃ0ȊOɂB
		if(MouseEdgeInput) { MouseRepeatInput = 1; }
		//{^\̈ɃJ[\A{^ꂽuԂ̏ꍇ̓{^ԂɂB
		if(MouseEdgeInput && In) { TButton->Bottom = 1; }
	} else {
		//{^ĂȂꍇ̓s[gZbgB
		TButton->FirstRepeat = 0;
		TButton->BottomTime  = 0.0;
		//}EXJ[\{^̕\̈ɂA܂Ń{^Ԃꍇ̓NbNtO𗧂āAON/OFFԂ𔽓]B
		if(In && TButton->Bottom) {
			TButton->Click     = 1;
			TButton->OnOffFlag = !TButton->OnOffFlag;
		}
		//{^ԂZbgB
		TButton->Bottom = 0;
	}
	//s[g͂ĂāA}EXJ[\{^̕\̈ɂ烊s[g͍l̃{^Ԃ0ȊOɂB
	if(MouseRepeatInput && In) {
		TButton->RepeatBottom = 1;
	} else {
		TButton->RepeatBottom = 0;
	}
}
//-----------------------------------------------------------------------------
//{^ʂɕ`悷B
//[in]
//	TButton			{^B
static void ToolButton_Draw(SToolButton* TButton) {
	int MouseX, MouseY;
	int ButtonFontHandle;
	int DrawWidth;
	int TempX, TempY;
	int In;
	int addx, addy;
	int CenterColor;
	int TopLeftC1, TopLeftC2;
	int RightBottomC1, RightBottomC2;
	//\Ԃ0̏ꍇ͉IB
	if(!ToolButton_GetVisible(TButton)) { return; }	//܂
	//}EXJ[\̈ʒu擾B
	ToolStatic_GetMousePosition(&MouseX, &MouseY);
	//{^`p̃tHgnh擾B
	ButtonFontHandle = ToolStatic_GetButtonFontHandle();
	//{^̕`敝擾B
	DrawWidth = ToolFunc_GetDrawStringWidthToHandle(TButton->Name, -1, ButtonFontHandle);
	//{^̕\ʒuƃ{^̕\̈Ƀ}EXJ[\邩ǂ擾B
	if(TButton->TWindow) {
		ToolWindow_GetDrawLeftUpPos(TButton->TWindow, &TempX, &TempY);
		TempX += TButton->Position.x;
		TempY += TButton->Position.y;
		In = ToolStatic_CheckMouseIn(TempX,
		                             TempY,
		                             TempX + TButton->Size.cx,
		                             TempY + TButton->Size.cy) &&
		     ToolWindow_CheckInfoAreaIn(TButton->TWindow,
		                                MouseX,
		                                MouseY);
	} else {
		TempX = TButton->Position.x;
		TempY = TButton->Position.y;
		In = ToolStatic_CheckMouseIn(TempX,
		                             TempY,
		                             TempX + TButton->Size.cx,
		                             TempY + TButton->Size.cy);
	}
	//{^Ă邩AႵON/OFF؂ւ[hONԂ̏ꍇ͉Ă{^̔zFɂB
	if((In && TButton->Bottom) ||
	   (TButton->On_Off_SwitchType && TButton->OnOffFlag)) {
		addx          = 1;
		addy          = 1;
		CenterColor   = ToolFunc_GetColor(192,192,192);
		TopLeftC1     = ToolFunc_GetColor(  0,  0,  0);
		TopLeftC2     = ToolFunc_GetColor( 64, 64, 64);
		RightBottomC1 = ToolFunc_GetColor(255,255,255);
		RightBottomC2 = ToolFunc_GetColor(191,191,191);
	} else {
		addx          = 0;
		addy          = 0;
		CenterColor   = ToolFunc_GetColor(255,255,255);
		RightBottomC1 = ToolFunc_GetColor(  0,  0,  0);
		RightBottomC2 = ToolFunc_GetColor( 64, 64, 64);
		TopLeftC1     = ToolFunc_GetColor(255,255,255);
		TopLeftC2     = ToolFunc_GetColor(191,191,191);
	}
	//{^ɃEChE񂪊֘AtĂꍇ͕`̈̐ݒsB
	if(TButton->TWindow) { ToolWindow_SetupDrawArea(TButton->TWindow); }
	//{^̕`B
	ToolStatic_DrawButton(TempX,
	                      TempY,
	                      TButton->Size.cx,
	                      TButton->Size.cy,
	                      TopLeftC1,
	                      TopLeftC2,
	                      RightBottomC1,
	                      RightBottomC2,
	                      CenterColor);
	//{^̕`B
	ToolFunc_SetDrawBlendMode(1/*DX_BLENDMODE_ALPHA*/, 180);
	ToolFunc_DrawStringToHandle(TempX + (TButton->Size.cx - DrawWidth              ) / 2 + addx,
	                            TempY + (TButton->Size.cy - TOOL_BUTTON_FONT_HEIGHT) / 2 + addy,
	                            TButton->Name,
	                            ToolFunc_GetColor(0,0,0),
	                            ButtonFontHandle);
	//uh[hƕ`\̈ɖ߂B
	ToolFunc_SetDrawBlendMode(0/*DX_BLENDMODE_NOBLEND*/, 0);
	ToolFunc_SetDrawAreaFull();
}
